/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.util.List;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.FixedIntegerValue;
import org.yamcs.xtce.IntegerValue;
import org.yamcs.xtce.NameDescription;

public class ArrayDataType
extends NameDescription
implements DataType {
    private static final long serialVersionUID = 1L;
    List<IntegerValue> dim;
    private DataType type;
    private int numberOfDimensions;
    private Object[] initialValue;

    public ArrayDataType(Builder<?> builder) {
        super(builder);
        if (builder.type == null) {
            throw new IllegalArgumentException("Array element type cannot be null");
        }
        this.dim = builder.dim;
        this.type = builder.type;
        this.numberOfDimensions = builder.numberOfDimensions;
        if (builder.initialValue != null) {
            this.initialValue = builder.initialValue instanceof Object[] ? (Object[])builder.initialValue : this.convertType(builder.initialValue.toString());
        }
    }

    public ArrayDataType(String name, int numberOfDimensions) {
        super(name);
        this.numberOfDimensions = numberOfDimensions;
    }

    public ArrayDataType(ArrayDataType t) {
        super(t);
        this.type = t.type;
        this.numberOfDimensions = t.numberOfDimensions;
        this.initialValue = t.initialValue;
        this.dim = t.dim;
    }

    public DataType getElementType() {
        return this.type;
    }

    public int getNumberOfDimensions() {
        return this.numberOfDimensions;
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.ARRAY;
    }

    @Override
    public String getTypeAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.type.getTypeAsString().replace("[]", ""));
        for (int i = 0; i < this.numberOfDimensions; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public List<IntegerValue> getSize() {
        return this.dim;
    }

    public boolean isFixedSize() {
        for (IntegerValue iv : this.dim) {
            if (iv instanceof FixedIntegerValue) continue;
            return false;
        }
        return true;
    }

    public IntegerValue getDimension(int n) {
        return this.dim.get(n);
    }

    public int[] getFixedSize() {
        int[] r = new int[this.dim.size()];
        for (int i = 0; i < this.dim.size(); ++i) {
            FixedIntegerValue fiv = (FixedIntegerValue)this.dim.get(i);
            if (!(fiv instanceof FixedIntegerValue)) continue;
            r[i] = (int)fiv.getValue();
        }
        return r;
    }

    public Object[] convertType(Object value) {
        if (value instanceof String) {
            return this.parse((String)value, false);
        }
        if (value instanceof List) {
            return this.toArray((List)value, this.numberOfDimensions - 1, false);
        }
        throw new IllegalArgumentException("Cannot convert value of type '" + value.getClass() + "'");
    }

    @Override
    public Object parseStringForRawValue(String stringValue) {
        return this.parse(stringValue, true);
    }

    private Object[] parse(String stringValue, boolean raw) {
        try {
            JsonElement el = JsonParser.parseString((String)stringValue);
            return this.toArray(el, this.numberOfDimensions - 1, raw);
        }
        catch (JsonParseException e) {
            throw new IllegalArgumentException("Cannot parse string as json: " + e.getMessage());
        }
    }

    private Object[] toArray(JsonElement jel, int numDim, boolean raw) {
        if (!(jel instanceof JsonArray)) {
            throw new IllegalArgumentException("Expected '" + jel + "' to be an array but instead it is: " + jel.getClass());
        }
        JsonArray jarr = (JsonArray)jel;
        Object[] r = new Object[jarr.size()];
        if (numDim > 0) {
            for (int i = 0; i < jarr.size(); ++i) {
                r[i] = this.toArray(jarr.get(i), numDim - 1, raw);
            }
        } else if (raw) {
            for (int i = 0; i < jarr.size(); ++i) {
                r[i] = this.type.parseStringForRawValue(jarr.get(i).getAsString());
            }
        } else {
            for (int i = 0; i < jarr.size(); ++i) {
                r[i] = this.type.convertType(jarr.get(i).getAsString());
            }
        }
        return r;
    }

    private Object[] toArray(List<Object> arr, int numDim, boolean raw) {
        Object[] r = new Object[arr.size()];
        if (numDim > 0) {
            for (int i = 0; i < arr.size(); ++i) {
                Object el = arr.get(i);
                if (!(el instanceof List)) {
                    throw new IllegalArgumentException("Expected '" + el + "' to be an array but instead it is: " + el.getClass());
                }
                r[i] = this.toArray((List)el, numDim - 1, raw);
            }
        } else if (raw) {
            for (int i = 0; i < arr.size(); ++i) {
                r[i] = this.type.parseStringForRawValue((String)arr.get(i));
            }
        } else {
            for (int i = 0; i < arr.size(); ++i) {
                r[i] = this.type.convertType(arr.get(i));
            }
        }
        return r;
    }

    @Override
    public String toString(Object v) {
        if (v instanceof Object[]) {
            Object[] v1 = (Object[])v;
            String[] v2 = new String[v1.length];
            for (int i = 0; i < v1.length; ++i) {
                v2[i] = this.type.toString(v1[i]);
            }
            Gson gson = new Gson();
            return gson.toJson((Object)v2);
        }
        throw new IllegalArgumentException("Can only convert arrays not " + v.getClass());
    }

    public Object[] getInitialValue() {
        return this.initialValue;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends NameDescription.Builder<T>
    implements DataType.Builder<T> {
        List<IntegerValue> dim;
        private DataType type;
        private int numberOfDimensions;
        private Object initialValue;

        public Builder() {
        }

        public Builder(ArrayDataType dataType) {
            super(dataType);
            this.dim = dataType.dim;
            this.type = dataType.type;
            this.numberOfDimensions = dataType.numberOfDimensions;
            this.initialValue = dataType.initialValue;
        }

        public T setElementType(DataType type) {
            this.type = type;
            return (T)((Builder)this.self());
        }

        public void setSize(List<IntegerValue> list) {
            if (list.isEmpty()) {
                throw new IllegalArgumentException("Dimension sizes cannot be empty");
            }
            this.dim = list;
            this.setNumberOfDimensions(this.dim.size());
        }

        public T setNumberOfDimensions(int numberOfDimensions) {
            this.numberOfDimensions = numberOfDimensions;
            return (T)((Builder)this.self());
        }

        @Override
        public T setInitialValue(String initialValue) {
            this.initialValue = initialValue;
            return (T)((Builder)this.self());
        }

        public boolean isResolved() {
            return this.type != null;
        }
    }
}

