/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.xtce.ArrayDataType;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.ParameterType;

public class ArrayParameterType
extends ArrayDataType
implements ParameterType {
    private static final long serialVersionUID = 1L;

    public ArrayParameterType(Builder builder) {
        super(builder);
    }

    public ArrayParameterType(String name) {
        super(name, -1);
    }

    public ArrayParameterType(String name, int numberOfDimensions) {
        super(name, numberOfDimensions);
        if (numberOfDimensions < 0) {
            throw new IllegalArgumentException("numberOfDimensions should be positive");
        }
    }

    public ArrayParameterType(ArrayParameterType t) {
        super(t);
    }

    @Override
    public String getTypeAsString() {
        return this.getElementType().getTypeAsString() + "[]";
    }

    @Override
    public boolean hasAlarm() {
        return false;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public DataEncoding getEncoding() {
        throw new UnsupportedOperationException("array parameters do not support encodings");
    }

    public String toString() {
        return "ArrayParameterType name:" + this.name + " numberOfDimensions:" + this.getNumberOfDimensions();
    }

    public static class Builder
    extends ArrayDataType.Builder<Builder>
    implements ParameterType.Builder<Builder> {
        public Builder() {
        }

        public Builder(ArrayParameterType arrayParameterType) {
            super(arrayParameterType);
        }

        @Override
        public ArrayParameterType build() {
            return new ArrayParameterType(this);
        }

        @Override
        public Builder setEncoding(DataEncoding.Builder<?> dataEncoding) {
            throw new UnsupportedOperationException("array parameters do not support encodings");
        }
    }
}

