/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.xtce.BaseDataType;

public abstract class BaseTimeDataType
extends BaseDataType {
    private static final long serialVersionUID = 2L;
    boolean needsScaling;
    double scale = 1.0;
    double offset = 0.0;

    BaseTimeDataType(Builder<?> builder) {
        super((BaseDataType.Builder<?>)builder);
        this.needsScaling = builder.needsScaling;
        this.scale = builder.scale;
        this.offset = builder.offset;
        if (builder.baseType instanceof BaseTimeDataType) {
            BaseTimeDataType baseType = (BaseTimeDataType)builder.baseType;
            if (!builder.needsScaling && baseType.needsScaling) {
                this.needsScaling = baseType.needsScaling;
                this.scale = baseType.scale;
                this.offset = baseType.offset;
            }
        }
        this.setInitialValue(builder);
    }

    BaseTimeDataType(String name) {
        super(name);
    }

    protected BaseTimeDataType(BaseTimeDataType t) {
        super(t);
        this.encoding = t.encoding;
        this.needsScaling = t.needsScaling;
        this.scale = t.scale;
        this.offset = t.offset;
    }

    @Override
    public Object parseStringForRawValue(String stringValue) {
        return this.encoding.parseString(stringValue);
    }

    public void setScaling(double offset, double scale) {
        this.needsScaling = true;
        this.offset = offset;
        this.scale = scale;
    }

    public boolean needsScaling() {
        return this.needsScaling;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getScale() {
        return this.scale;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseDataType.Builder<T> {
        boolean needsScaling;
        double scale = 1.0;
        double offset = 0.0;

        public Builder() {
        }

        public Builder(BaseTimeDataType dataType) {
            super(dataType);
            this.needsScaling = dataType.needsScaling;
            this.scale = dataType.scale;
            this.offset = dataType.offset;
        }

        public void setScaling(double offset, double scale) {
            this.needsScaling = true;
            this.offset = offset;
            this.scale = scale;
        }
    }
}

