/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.xtce.Algorithm;
import org.yamcs.xtce.BinaryDataType;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.DynamicIntegerValue;

public class BinaryDataEncoding
extends DataEncoding {
    private static final long serialVersionUID = 3L;
    int sizeInBitsOfSizeTag = 16;
    private Type type = Type.FIXED_SIZE;
    protected DynamicIntegerValue dynamicSize;

    public BinaryDataEncoding(BinaryDataEncoding bde) {
        super(bde);
        this.sizeInBitsOfSizeTag = bde.sizeInBitsOfSizeTag;
        this.type = bde.type;
    }

    public BinaryDataEncoding(Builder builder) {
        super(builder, -1);
        if (builder.type != null) {
            this.type = builder.type;
        }
        if (builder.sizeInBitsOfSizeTag != null) {
            this.sizeInBitsOfSizeTag = builder.sizeInBitsOfSizeTag;
        }
        if (builder.dynamicSize != null) {
            this.sizeInBits = -1;
            this.dynamicSize = builder.dynamicSize;
        }
        if (builder.baseEncoding instanceof BinaryDataEncoding) {
            BinaryDataEncoding baseEncoding = (BinaryDataEncoding)builder.baseEncoding;
            if (builder.type == null) {
                this.type = baseEncoding.type;
            }
            if (builder.sizeInBitsOfSizeTag == null) {
                this.sizeInBitsOfSizeTag = baseEncoding.sizeInBitsOfSizeTag;
            }
            if (builder.dynamicSize == null) {
                this.dynamicSize = baseEncoding.dynamicSize;
            }
        }
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public void setSizeType(Type sizeType) {
        this.type = sizeType;
    }

    public Type getType() {
        return this.type;
    }

    public int getSizeInBitsOfSizeTag() {
        return this.sizeInBitsOfSizeTag;
    }

    public void setSizeInBitsOfSizeTag(int sizeInBits) {
        this.sizeInBitsOfSizeTag = sizeInBits;
    }

    public boolean isVariableSize() {
        return this.dynamicSize != null;
    }

    public DynamicIntegerValue getDynamicSize() {
        return this.dynamicSize;
    }

    @Override
    public Object parseString(String stringValue) {
        return BinaryDataType.hexStringToArray(stringValue);
    }

    @Override
    public BinaryDataEncoding copy() {
        return new BinaryDataEncoding(this);
    }

    public String toString() {
        return "BinaryDataEncoding(sizeInBits:" + this.sizeInBits + ", type:" + this.type + ")";
    }

    public static enum Type {
        FIXED_SIZE,
        LEADING_SIZE,
        CUSTOM,
        DYNAMIC;

    }

    public static class Builder
    extends DataEncoding.Builder<Builder> {
        Integer sizeInBitsOfSizeTag;
        private Type type;
        DynamicIntegerValue dynamicSize;

        public Builder(BinaryDataEncoding encoding) {
            super(encoding);
            this.sizeInBitsOfSizeTag = encoding.sizeInBitsOfSizeTag;
            this.type = encoding.type;
        }

        public Builder() {
        }

        public DynamicIntegerValue getDynamicSize() {
            return this.dynamicSize;
        }

        public Builder setDynamicSize(DynamicIntegerValue v) {
            this.dynamicSize = v;
            return (Builder)this.self();
        }

        public Builder setType(Type type) {
            this.type = type;
            return (Builder)this.self();
        }

        public Builder setSizeInBitsOfSizeTag(int sizeInBitsOfSizeTag) {
            this.sizeInBitsOfSizeTag = sizeInBitsOfSizeTag;
            return (Builder)this.self();
        }

        @Override
        public Builder setToBinaryTransformAlgorithm(Algorithm alg) {
            super.setToBinaryTransformAlgorithm(alg);
            this.type = Type.CUSTOM;
            return (Builder)this.self();
        }

        @Override
        public Builder setFromBinaryTransformAlgorithm(Algorithm alg) {
            super.setFromBinaryTransformAlgorithm(alg);
            this.type = Type.CUSTOM;
            return (Builder)this.self();
        }

        @Override
        public BinaryDataEncoding build() {
            return new BinaryDataEncoding(this);
        }
    }
}

