/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.AbstractMap;
import java.util.List;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.AncillaryData;
import org.yamcs.xtce.BaseDataType;
import org.yamcs.xtce.IntegerRange;

public class BinaryDataType
extends BaseDataType {
    private static final long serialVersionUID = 3L;
    byte[] initialValue;
    IntegerRange sizeRangeInBytes;

    protected BinaryDataType(Builder<?> builder) {
        super((BaseDataType.Builder<?>)builder);
        this.sizeRangeInBytes = builder.sizeRangeInBytes;
        if (builder.baseType instanceof BinaryDataType) {
            BinaryDataType baseType = (BinaryDataType)builder.baseType;
            if (builder.sizeRangeInBytes == null && baseType.sizeRangeInBytes != null) {
                this.sizeRangeInBytes = baseType.sizeRangeInBytes;
            }
        }
        this.setInitialValue(builder);
    }

    protected BinaryDataType(BinaryDataType t) {
        super(t);
        this.sizeRangeInBytes = t.sizeRangeInBytes;
    }

    @Override
    protected void setInitialValue(Object initialValue) {
        this.initialValue = this.convertType(initialValue);
    }

    public byte[] getInitialValue() {
        return this.initialValue;
    }

    public IntegerRange getSizeRangeInBytes() {
        return this.sizeRangeInBytes;
    }

    public void setSizeRangeInBytes(IntegerRange sizeRangeInBytes) {
        this.sizeRangeInBytes = sizeRangeInBytes;
    }

    public String toString() {
        return "BinaryData encoding: " + this.encoding;
    }

    public byte[] convertType(Object value) {
        if (value instanceof String) {
            return BinaryDataType.hexStringToArray((String)value);
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        throw new IllegalArgumentException("Cannot convert value of type '" + value.getClass() + "'");
    }

    @Override
    public String toString(Object v) {
        if (v instanceof byte[]) {
            return BinaryDataType.arrayToHexString((byte[])v);
        }
        throw new IllegalArgumentException("Can only convert byte arrays");
    }

    public static byte[] hexStringToArray(String s) {
        if ((((String)s).length() & 1) == 1) {
            s = "0" + (String)s;
        }
        byte[] b = new byte[((String)s).length() / 2];
        for (int i = 0; i < ((String)s).length() / 2; ++i) {
            b[i] = (byte)(Integer.parseInt(((String)s).substring(2 * i, 2 * i + 2), 16) & 0xFF);
        }
        return b;
    }

    public static String arrayToHexString(byte[] b) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < b.length; ++i) {
            sb.append(String.format("%02X", b[i] & 0xFF));
        }
        return sb.toString();
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.BINARY;
    }

    @Override
    public String getTypeAsString() {
        return "binary";
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseDataType.Builder<T> {
        IntegerRange sizeRangeInBytes;

        public Builder() {
        }

        public Builder(BinaryDataType binaryDataType) {
            super(binaryDataType);
            this.sizeRangeInBytes = binaryDataType.sizeRangeInBytes;
        }

        public void setSizeRangeInBytes(IntegerRange sizeRangeInBytes) {
            this.sizeRangeInBytes = sizeRangeInBytes;
        }

        @Override
        public void setAncillaryData(List<AncillaryData> ancillaryData) {
            super.setAncillaryData(ancillaryData);
            long minLength = Long.MIN_VALUE;
            long maxLength = Long.MAX_VALUE;
            for (AncillaryData ad : ancillaryData) {
                if (!ad.isYamcs()) continue;
                AbstractMap.SimpleEntry<String, String> p = ad.getValueAsPair();
                if (p != null && "minLength".equals(p.getKey())) {
                    minLength = Integer.valueOf(p.getValue()).intValue();
                }
                if (p == null || !"maxLength".equals(p.getKey())) continue;
                maxLength = Integer.valueOf(p.getValue()).intValue();
            }
            if (minLength != Long.MIN_VALUE || maxLength != Long.MAX_VALUE) {
                this.sizeRangeInBytes = new IntegerRange(minLength, maxLength);
            }
        }
    }
}

