/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.BaseDataType;

public class BooleanDataType
extends BaseDataType {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger(BooleanDataType.class);
    public static final String DEFAULT_ONE_STRING_VALUE = "True";
    public static final String DEFAULT_ZERO_STRING_VALUE = "False";
    Boolean initialValue;
    String oneStringValue = "True";
    String zeroStringValue = "False";

    protected BooleanDataType(Builder<?> builder) {
        super((BaseDataType.Builder<?>)builder);
        if (builder.oneStringValue != null) {
            this.oneStringValue = builder.oneStringValue;
        }
        if (builder.zeroStringValue != null) {
            this.zeroStringValue = builder.zeroStringValue;
        }
        if (builder.baseType instanceof BooleanDataType) {
            BooleanDataType baseType = (BooleanDataType)builder.baseType;
            if (builder.oneStringValue == null && baseType.oneStringValue != null) {
                this.oneStringValue = baseType.oneStringValue;
            }
            if (builder.zeroStringValue == null && baseType.zeroStringValue != null) {
                this.zeroStringValue = baseType.zeroStringValue;
            }
        }
        this.setInitialValue(builder);
    }

    protected BooleanDataType(BooleanDataType t) {
        super(t);
    }

    @Override
    protected void setInitialValue(Object initialValue) {
        this.initialValue = this.convertType(initialValue);
    }

    @Override
    public Boolean getInitialValue() {
        return this.initialValue;
    }

    @Override
    public Boolean convertType(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (this.oneStringValue.equals(stringValue)) {
                return Boolean.TRUE;
            }
            if (this.zeroStringValue.equals(stringValue)) {
                return Boolean.FALSE;
            }
            if (this.oneStringValue.equalsIgnoreCase(stringValue)) {
                log.warn("DEPRECATION: Boolean conversion from string should use '{}' instead of '{}'. This check will be enforced in a future release of Yamcs", (Object)this.oneStringValue, value);
                return Boolean.TRUE;
            }
            if (this.zeroStringValue.equalsIgnoreCase(stringValue)) {
                log.warn("DEPRECATION: Boolean conversion from string should use '{}' instead of '{}'. This check will be enforced in a future release of Yamcs", (Object)this.zeroStringValue, value);
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("Invalid initialValue, should be '" + this.oneStringValue + "' or '" + this.zeroStringValue + "'");
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new IllegalArgumentException("Cannot convert value of type '" + value.getClass() + "'");
    }

    @Override
    public String toString(Object o) {
        if (o instanceof Boolean) {
            return (Boolean)o != false ? this.oneStringValue : this.zeroStringValue;
        }
        throw new IllegalArgumentException("Can only convert a boolean value, not " + o.getClass());
    }

    public String getOneStringValue() {
        return this.oneStringValue;
    }

    public String getZeroStringValue() {
        return this.zeroStringValue;
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.BOOLEAN;
    }

    @Override
    public String getTypeAsString() {
        return "boolean";
    }

    public String toString() {
        return "BooleanData encoding: " + this.encoding;
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseDataType.Builder<T> {
        String oneStringValue;
        String zeroStringValue;

        public Builder() {
        }

        public Builder(BooleanDataType dataType) {
            super(dataType);
            this.oneStringValue = dataType.oneStringValue;
            this.zeroStringValue = dataType.zeroStringValue;
        }

        public void setOneStringValue(String oneStringValue) {
            this.oneStringValue = oneStringValue;
        }

        public void setZeroStringValue(String zeroStringValue) {
            this.zeroStringValue = zeroStringValue;
        }
    }
}

