/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;

public class CheckWindow
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final long timeToStartChecking;
    private final long timeToStopChecking;
    private final TimeWindowIsRelativeToType timeWindowIsRelativeTo;

    public CheckWindow(long timeToStartChecking, long timeToStopChecking, TimeWindowIsRelativeToType timeWindowIsRelativeTo) {
        this.timeToStartChecking = timeToStartChecking;
        this.timeToStopChecking = timeToStopChecking;
        this.timeWindowIsRelativeTo = timeWindowIsRelativeTo;
    }

    public long getTimeToStartChecking() {
        return this.timeToStartChecking;
    }

    public long getTimeToStopChecking() {
        return this.timeToStopChecking;
    }

    public TimeWindowIsRelativeToType getTimeWindowIsRelativeTo() {
        return this.timeWindowIsRelativeTo;
    }

    public boolean hasStart() {
        return this.timeToStartChecking != -1L;
    }

    public String toString() {
        return this.timeWindowIsRelativeTo + "[" + this.timeToStartChecking + "," + this.timeToStopChecking + "]";
    }

    public static enum TimeWindowIsRelativeToType {
        COMMAND_RELEASE,
        LAST_VERIFIER;


        public static TimeWindowIsRelativeToType fromXtce(String xtceAttr) {
            if ("timeLastVerifierPassed".equals(xtceAttr)) {
                return LAST_VERIFIER;
            }
            if ("commandRelease".equals(xtceAttr)) {
                return COMMAND_RELEASE;
            }
            throw new IllegalArgumentException("Invalid value '" + xtceAttr + "' for timeWindowIsRelativeTo");
        }

        public static TimeWindowIsRelativeToType fromXls(String xlsStr) {
            if ("LastVerifier".equals(xlsStr)) {
                return LAST_VERIFIER;
            }
            if ("CommandRelease".equals(xlsStr)) {
                return COMMAND_RELEASE;
            }
            throw new IllegalArgumentException("Invalid value '" + xlsStr + "' for timeWindowIsRelativeTo");
        }

        public String toXtce() {
            if (this == COMMAND_RELEASE) {
                return "commandRelease";
            }
            return "timeLastVerifierPassed";
        }
    }
}

