/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.yamcs.xtce.Algorithm;
import org.yamcs.xtce.CheckWindow;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterValueChange;
import org.yamcs.xtce.SequenceContainer;

public class CommandVerifier
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final Type type;
    private TerminationAction onSuccess = null;
    private TerminationAction onFail = null;
    private TerminationAction onTimeout = null;
    private final String stage;
    private CheckWindow checkWindow;
    SequenceContainer containerRef;
    Algorithm algorithm;
    MatchCriteria matchCriteria;
    ParameterValueChange paraValueChange;
    boolean verifierFailOnFirstFailedMatch = false;
    private Parameter returnParameter;

    public CommandVerifier(Type type, String stage) {
        this.type = type;
        this.stage = stage;
    }

    public CommandVerifier(Type type, String stage, CheckWindow checkWindow) {
        this(type, stage);
        this.checkWindow = checkWindow;
    }

    public CommandVerifier(CommandVerifier cv) {
        this.algorithm = cv.algorithm;
        this.checkWindow = cv.checkWindow;
        this.type = cv.type;
        this.stage = cv.stage;
        this.containerRef = cv.containerRef;
        this.onSuccess = cv.onSuccess;
        this.onFail = cv.onFail;
        this.onTimeout = cv.onTimeout;
        this.matchCriteria = cv.matchCriteria;
    }

    public String getStage() {
        return this.stage;
    }

    public Type getType() {
        return this.type;
    }

    public void setContainerRef(SequenceContainer containerRef) {
        this.containerRef = containerRef;
    }

    public SequenceContainer getContainerRef() {
        return this.containerRef;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algo) {
        this.algorithm = algo;
    }

    public void setMatchCriteria(MatchCriteria matchCriteria) {
        if (this.type != Type.MATCH_CRITERIA) {
            throw new IllegalStateException("This verifier is of type " + this.type);
        }
        this.matchCriteria = matchCriteria;
    }

    public CheckWindow getCheckWindow() {
        return this.checkWindow;
    }

    public TerminationAction getOnTimeout() {
        return this.onTimeout;
    }

    public void setOnTimeout(TerminationAction onTimeout) {
        this.onTimeout = onTimeout;
    }

    public TerminationAction getOnFail() {
        return this.onFail;
    }

    public void setCheckWindow(CheckWindow checkWindow) {
        this.checkWindow = checkWindow;
    }

    public void setOnFail(TerminationAction onFail) {
        this.onFail = onFail;
    }

    public TerminationAction getOnSuccess() {
        return this.onSuccess;
    }

    public void setOnSuccess(TerminationAction onSuccess) {
        this.onSuccess = onSuccess;
    }

    public MatchCriteria getMatchCriteria() {
        return this.matchCriteria;
    }

    public ParameterValueChange getParameterValueChange() {
        return this.paraValueChange;
    }

    public void setParameterValueChange(ParameterValueChange paraValueChange) {
        this.paraValueChange = paraValueChange;
    }

    public boolean failOnFirstFailedMatch() {
        return this.verifierFailOnFirstFailedMatch;
    }

    public Parameter getReturnParameter() {
        return this.returnParameter;
    }

    public void setReturnParameter(Parameter returnParameter) {
        this.returnParameter = returnParameter;
    }

    public List<Parameter> getDependentParameters() {
        ArrayList<Parameter> plist = new ArrayList<Parameter>();
        if (this.matchCriteria != null) {
            plist.addAll(this.matchCriteria.getDependentParameters());
        }
        if (this.paraValueChange != null) {
            plist.add(this.paraValueChange.getParameterRef().getParameter());
        }
        if (this.returnParameter != null) {
            plist.add(this.returnParameter);
        }
        return plist;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{stage: ").append(this.stage);
        if (this.containerRef != null) {
            sb.append(", containerRef: ").append(this.containerRef.getName());
        }
        if (this.algorithm != null) {
            sb.append(", algorithm: ").append(this.algorithm.getName());
        }
        if (this.matchCriteria != null) {
            sb.append(", matchCriteria: ").append(this.matchCriteria);
        }
        sb.append(", checkWindow: ").append(this.checkWindow.toString()).append("}");
        return sb.toString();
    }

    public static enum TerminationAction {
        SUCCESS,
        FAIL;

    }

    public static enum Type {
        CONTAINER,
        ALGORITHM,
        MATCH_CRITERIA,
        PARAMETER_VALUE_CHANGE;

    }
}

