/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.yamcs.xtce.AggregateDataType;
import org.yamcs.xtce.ArgumentInstanceRef;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.OperatorType;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterOrArgumentRef;
import org.yamcs.xtce.PathElement;
import org.yamcs.xtce.util.DataTypeUtil;

public class Comparison
implements MatchCriteria {
    private static final long serialVersionUID = 10L;
    private ParameterOrArgumentRef ref;
    private OperatorType comparisonOperator;
    String stringValue;

    public Comparison(ParameterInstanceRef paraRef, String stringValue, OperatorType op) {
        if (stringValue == null) {
            throw new NullPointerException("stringValue");
        }
        this.ref = paraRef;
        this.stringValue = stringValue;
        this.comparisonOperator = op;
        this.checkParaRef(paraRef);
    }

    public Comparison(ArgumentInstanceRef argRef, String stringValue, OperatorType op) {
        if (stringValue == null) {
            throw new NullPointerException("stringValue");
        }
        this.ref = argRef;
        this.stringValue = stringValue;
        this.comparisonOperator = op;
    }

    private void checkParaRef(ParameterInstanceRef paraRef) {
        if (paraRef.getInstance() != 0) {
            throw new UnsupportedOperationException("Condition on parameter values from history are not supported");
        }
    }

    public void validateValueType() {
        boolean useCalibratedValue = this.ref.useCalibratedValue;
        DataType dtype = this.ref.getDataType();
        if (dtype instanceof AggregateDataType) {
            if (this.ref.getMemberPath() == null) {
                throw new IllegalArgumentException("Reference to an aggregate parameter type " + dtype.getName() + " without speciyfing the path");
            }
            DataType dtype1 = DataTypeUtil.getMemberType(dtype, this.ref.getMemberPath());
            if (dtype1 == null) {
                throw new IllegalArgumentException("reference " + PathElement.pathToString(this.ref.getMemberPath()) + " points to a nonexistent member inside the parameter type " + dtype.getName());
            }
            dtype = dtype1;
        }
        try {
            if (useCalibratedValue) {
                dtype.convertType(this.stringValue);
            } else {
                dtype.parseStringForRawValue(this.stringValue);
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot parse value required for comparing with " + this.ref.getName() + ": " + e.getMessage(), e);
        }
    }

    public ParameterOrArgumentRef getRef() {
        return this.ref;
    }

    public OperatorType getComparisonOperator() {
        return this.comparisonOperator;
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        if (this.ref instanceof ParameterInstanceRef) {
            HashSet<Parameter> pset = new HashSet<Parameter>();
            pset.add(((ParameterInstanceRef)this.ref).getParameter());
            return pset;
        }
        return Collections.emptySet();
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String toString() {
        return "Comparison: " + this.ref + this.comparisonOperator + this.stringValue;
    }
}

