/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.yamcs.xtce.BooleanExpression;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.OperatorType;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterOrArgumentRef;

public class Condition
implements BooleanExpression {
    private static final long serialVersionUID = 2L;
    ParameterOrArgumentRef leftRef;
    ParameterOrArgumentRef rightRef;
    String rightValue;
    OperatorType comparisonOperator;

    public Condition(OperatorType comparisonOperator, ParameterOrArgumentRef leftRef, ParameterOrArgumentRef rightRef) {
        this.leftRef = leftRef;
        this.comparisonOperator = comparisonOperator;
        this.rightRef = rightRef;
    }

    public Condition(OperatorType comparisonOperator, ParameterOrArgumentRef leftRef, String rightValue) {
        this.leftRef = leftRef;
        this.comparisonOperator = comparisonOperator;
        this.rightValue = rightValue;
    }

    public void validateValueType() {
        DataType ptype;
        if (this.rightValue != null && (ptype = this.leftRef.getDataType()) != null) {
            if (this.leftRef.useCalibratedValue()) {
                ptype.convertType(this.rightValue);
            } else {
                ptype.parseStringForRawValue(this.rightValue);
            }
        }
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        ParameterInstanceRef pref;
        HashSet<Parameter> pset = new HashSet<Parameter>();
        if (this.leftRef instanceof ParameterInstanceRef) {
            pref = (ParameterInstanceRef)this.leftRef;
            pset.add(pref.getParameter());
        }
        if (this.rightRef instanceof ParameterInstanceRef) {
            pref = (ParameterInstanceRef)this.rightRef;
            pset.add(pref.getParameter());
        }
        return pset;
    }

    public String toString() {
        return "Condition: " + this.leftRef + this.comparisonOperator + (Serializable)(this.rightValue == null ? this.rightRef : this.rightValue);
    }

    public ParameterOrArgumentRef getLeftRef() {
        return this.leftRef;
    }

    public ParameterOrArgumentRef getRightRef() {
        return this.rightRef;
    }

    public OperatorType getComparisonOperator() {
        return this.comparisonOperator;
    }

    public String getRightValue() {
        return this.rightValue;
    }
}

