/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.xtce.IntegerValue;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterOrArgumentRef;

public class DynamicIntegerValue
extends IntegerValue {
    private static final long serialVersionUID = 14L;
    private long intercept = 0L;
    private long slope = 1L;
    private ParameterOrArgumentRef instanceRef;

    public DynamicIntegerValue(ParameterOrArgumentRef ir) {
        this.instanceRef = ir;
    }

    public ParameterInstanceRef getParameterInstanceRef() {
        if (!(this.instanceRef instanceof ParameterInstanceRef)) {
            throw new IllegalStateException("In DynamicIntegerValue: wanted ParameterInstanceRef but got " + this.instanceRef.getClass().getName());
        }
        return (ParameterInstanceRef)this.instanceRef;
    }

    public ParameterOrArgumentRef getDynamicInstanceRef() {
        return this.instanceRef;
    }

    public long getIntercept() {
        return this.intercept;
    }

    public void setIntercept(long intercept) {
        this.intercept = intercept;
    }

    public long getSlope() {
        return this.slope;
    }

    public void setSlope(long slope) {
        this.slope = slope;
    }

    public long transform(long v) {
        return Math.addExact(Math.multiplyExact(v, this.slope), this.intercept);
    }

    public long reverse(long v) {
        return Math.subtractExact(v / this.slope, this.intercept);
    }

    public String toString() {
        return "DynamicIntegerValue(instanceRef=" + this.instanceRef.getName() + ", slope=" + this.slope + ", intercept=" + this.intercept + ")";
    }
}

