/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.BaseDataType;
import org.yamcs.xtce.ValueEnumeration;
import org.yamcs.xtce.ValueEnumerationRange;

public class EnumeratedDataType
extends BaseDataType {
    private static final long serialVersionUID = 2L;
    String initialValue;
    protected HashMap<Long, ValueEnumeration> enumeration = new HashMap();
    protected List<ValueEnumeration> enumerationList = new ArrayList<ValueEnumeration>();
    protected List<ValueEnumerationRange> ranges = new ArrayList<ValueEnumerationRange>();

    EnumeratedDataType(Builder<?> builder) {
        super((BaseDataType.Builder<?>)builder);
        this.enumerationList = builder.enumerationList;
        this.ranges = builder.ranges;
        if (builder.baseType instanceof EnumeratedDataType) {
            EnumeratedDataType baseType = (EnumeratedDataType)builder.baseType;
            if (builder.enumerationList.isEmpty()) {
                this.enumerationList.addAll(baseType.enumerationList);
            }
            if (builder.ranges.isEmpty()) {
                this.ranges.addAll(baseType.ranges);
            }
        }
        for (ValueEnumeration ve : this.enumerationList) {
            this.enumeration.put(ve.value, ve);
        }
        this.setInitialValue(builder);
    }

    protected EnumeratedDataType(EnumeratedDataType t) {
        super(t);
        this.enumeration = t.enumeration;
        this.enumerationList = t.enumerationList;
        this.ranges = t.ranges;
        this.initialValue = t.initialValue;
    }

    @Override
    protected void setInitialValue(Object initialValue) {
        this.initialValue = this.convertType(initialValue);
    }

    @Override
    public String getInitialValue() {
        return this.initialValue;
    }

    public ValueEnumeration enumValue(Long key) {
        if (this.enumeration.containsKey(key)) {
            return this.enumeration.get(key);
        }
        if (this.ranges != null) {
            for (ValueEnumerationRange range : this.ranges) {
                if (!range.isValueInRange(key)) continue;
                return new ValueEnumeration(key, range.getLabel());
            }
        }
        return null;
    }

    public ValueEnumeration enumValue(String label) {
        for (ValueEnumeration enumeration : this.enumerationList) {
            if (!enumeration.getLabel().equals(label)) continue;
            return enumeration;
        }
        return null;
    }

    public String calibrate(long raw) {
        ValueEnumeration v = this.enumeration.get(raw);
        if (v != null) {
            return v.label;
        }
        if (this.ranges != null) {
            for (ValueEnumerationRange range : this.ranges) {
                if (!range.isValueInRange(raw)) continue;
                return range.label;
            }
        }
        return "UNDEF";
    }

    public boolean hasLabel(String label) {
        for (ValueEnumeration enumeration : this.enumerationList) {
            if (!enumeration.getLabel().equals(label)) continue;
            return true;
        }
        if (this.ranges != null) {
            for (ValueEnumerationRange range : this.ranges) {
                if (!range.getLabel().equals(label)) continue;
                return true;
            }
        }
        return false;
    }

    public List<ValueEnumeration> getValueEnumerationList() {
        return Collections.unmodifiableList(this.enumerationList);
    }

    public List<ValueEnumerationRange> getValueEnumerationRangeList() {
        return Collections.unmodifiableList(this.ranges);
    }

    @Override
    public String convertType(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            ValueEnumeration e = this.enumValue(((Number)value).longValue());
            if (e != null) {
                return e.label;
            }
            throw new IllegalArgumentException("Cannot find enumeration for number '" + value + "'");
        }
        throw new IllegalArgumentException("Cannot convert value of type '" + value.getClass() + "'");
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return Yamcs.Value.Type.STRING;
    }

    @Override
    public String getTypeAsString() {
        return "enumeration";
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseDataType.Builder<T> {
        protected List<ValueEnumeration> enumerationList = new ArrayList<ValueEnumeration>();
        protected List<ValueEnumerationRange> ranges = new ArrayList<ValueEnumerationRange>();

        public Builder() {
        }

        public Builder(EnumeratedDataType dataType) {
            super(dataType);
            this.enumerationList = dataType.enumerationList;
            this.ranges = dataType.ranges;
        }

        public T addEnumerationValue(long value, String label) {
            ValueEnumeration valEnum = new ValueEnumeration(value, label);
            this.enumerationList.add(valEnum);
            return (T)((Builder)this.self());
        }

        public T addEnumerationValue(ValueEnumeration ve) {
            this.enumerationList.add(ve);
            return (T)((Builder)this.self());
        }

        public T addEnumerationRange(ValueEnumerationRange range) {
            this.ranges.add(range);
            return (T)((Builder)this.self());
        }

        public boolean hasLabel(String label) {
            for (ValueEnumeration enumeration : this.enumerationList) {
                if (!enumeration.getLabel().equals(label)) continue;
                return true;
            }
            for (ValueEnumerationRange range : this.ranges) {
                if (!range.getLabel().equals(label)) continue;
                return true;
            }
            return false;
        }

        public ValueEnumeration enumValue(Long key) {
            for (ValueEnumeration ve : this.enumerationList) {
                if (ve.getValue() != key.longValue()) continue;
                return ve;
            }
            for (ValueEnumerationRange range : this.ranges) {
                if (!range.isValueInRange(key)) continue;
                return new ValueEnumeration(key, range.getLabel());
            }
            return null;
        }

        public ValueEnumeration enumValue(String label) {
            for (ValueEnumeration enumeration : this.enumerationList) {
                if (!enumeration.getLabel().equals(label)) continue;
                return enumeration;
            }
            return null;
        }

        public List<ValueEnumeration> getValueEnumerationList() {
            return Collections.unmodifiableList(this.enumerationList);
        }

        public List<ValueEnumerationRange> getValueEnumerationRangeList() {
            return Collections.unmodifiableList(this.ranges);
        }
    }
}

