/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yamcs.xtce.AlarmLevels;
import org.yamcs.xtce.EnumeratedDataType;
import org.yamcs.xtce.EnumerationAlarm;
import org.yamcs.xtce.EnumerationContextAlarm;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterType;

public class EnumeratedParameterType
extends EnumeratedDataType
implements ParameterType {
    private static final long serialVersionUID = 5L;
    private EnumerationAlarm defaultAlarm = null;
    private List<EnumerationContextAlarm> contextAlarmList = null;

    public EnumeratedParameterType(Builder builder) {
        super(builder);
        this.defaultAlarm = builder.defaultAlarm;
        this.contextAlarmList = builder.contextAlarmList;
        if (builder.baseType instanceof EnumeratedParameterType) {
            EnumeratedParameterType baseType = (EnumeratedParameterType)builder.baseType;
            if (builder.defaultAlarm == null && baseType.defaultAlarm != null) {
                this.defaultAlarm = baseType.defaultAlarm;
            }
            if (builder.contextAlarmList == null && baseType.contextAlarmList != null) {
                this.contextAlarmList = baseType.contextAlarmList;
            }
        }
    }

    public EnumeratedParameterType(EnumeratedParameterType t) {
        super(t);
        this.defaultAlarm = t.defaultAlarm;
        this.contextAlarmList = t.contextAlarmList;
    }

    @Override
    public boolean hasAlarm() {
        return this.defaultAlarm != null || this.contextAlarmList != null && !this.contextAlarmList.isEmpty();
    }

    public void setDefaultAlarm(EnumerationAlarm enumerationAlarm) {
        this.defaultAlarm = enumerationAlarm;
    }

    @Override
    public Set<Parameter> getDependentParameters() {
        if (this.contextAlarmList == null) {
            return Collections.emptySet();
        }
        HashSet<Parameter> dependentParameters = new HashSet<Parameter>();
        for (EnumerationContextAlarm eca : this.contextAlarmList) {
            dependentParameters.addAll(eca.getContextMatch().getDependentParameters());
        }
        return dependentParameters;
    }

    public EnumerationAlarm getDefaultAlarm() {
        return this.defaultAlarm;
    }

    public EnumerationContextAlarm getContextAlarm(MatchCriteria contextMatch) {
        if (this.contextAlarmList == null) {
            return null;
        }
        for (EnumerationContextAlarm eca : this.contextAlarmList) {
            if (!eca.getContextMatch().equals(contextMatch)) continue;
            return eca;
        }
        return null;
    }

    public List<EnumerationContextAlarm> getContextAlarmList() {
        return this.contextAlarmList;
    }

    public String getCalibrationDescription() {
        return "EnumeratedParameterType: " + this.enumeration;
    }

    public void setContextAlarmList(List<EnumerationContextAlarm> contextAlarmList) {
        this.contextAlarmList = contextAlarmList;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return "EnumeratedParameterType: " + this.enumerationList + " encoding:" + this.encoding + (Serializable)(this.defaultAlarm != null ? this.defaultAlarm : "") + (this.contextAlarmList != null ? this.contextAlarmList : "");
    }

    public static class Builder
    extends EnumeratedDataType.Builder<Builder>
    implements ParameterType.Builder<Builder> {
        private EnumerationAlarm defaultAlarm = null;
        private List<EnumerationContextAlarm> contextAlarmList = null;

        public Builder() {
        }

        public Builder(EnumeratedParameterType enumeratedParameterType) {
            super(enumeratedParameterType);
            this.defaultAlarm = enumeratedParameterType.defaultAlarm;
            this.contextAlarmList = enumeratedParameterType.contextAlarmList;
        }

        public void setDefaultAlarm(EnumerationAlarm enumerationAlarm) {
            this.defaultAlarm = enumerationAlarm;
        }

        public void addContextAlarm(EnumerationContextAlarm nca) {
            if (this.contextAlarmList == null) {
                this.contextAlarmList = new ArrayList<EnumerationContextAlarm>();
            }
            this.contextAlarmList.add(nca);
        }

        public void addAlarm(MatchCriteria contextMatch, String enumLabel, AlarmLevels level) {
            this.createOrGetAlarm(contextMatch).addAlarm(enumLabel, level);
        }

        public EnumerationAlarm createOrGetAlarm(MatchCriteria contextMatch) {
            if (contextMatch == null) {
                if (this.defaultAlarm == null) {
                    this.defaultAlarm = new EnumerationAlarm();
                }
                return this.defaultAlarm;
            }
            EnumerationContextAlarm eca = this.getContextAlarm(contextMatch);
            if (eca == null) {
                eca = new EnumerationContextAlarm();
                eca.setContextMatch(contextMatch);
                this.addContextAlarm(eca);
            }
            return eca;
        }

        public EnumerationAlarm getDefaultAlarm() {
            return this.defaultAlarm;
        }

        public EnumerationContextAlarm getContextAlarm(MatchCriteria contextMatch) {
            if (this.contextAlarmList == null) {
                return null;
            }
            for (EnumerationContextAlarm eca : this.contextAlarmList) {
                if (!eca.getContextMatch().equals(contextMatch)) continue;
                return eca;
            }
            return null;
        }

        public void setContextAlarmList(List<EnumerationContextAlarm> contextAlarmList) {
            this.contextAlarmList = contextAlarmList;
        }

        @Override
        public EnumeratedParameterType build() {
            return new EnumeratedParameterType(this);
        }
    }
}

