/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.xtce.SequenceEntry;
import org.yamcs.xtce.util.HexUtils;

public class FixedValueEntry
extends SequenceEntry {
    private static final long serialVersionUID = 1L;
    final String name;
    final byte[] binaryValue;
    final int sizeInBits;

    public FixedValueEntry(String name, byte[] binaryValue, int sizeInBits) {
        if (sizeInBits > binaryValue.length * 8) {
            throw new IllegalArgumentException("binaryValue has to have at least sizeInBits(" + sizeInBits + ") bits, instead of " + binaryValue.length * 8);
        }
        this.name = name;
        this.binaryValue = binaryValue;
        this.sizeInBits = sizeInBits;
    }

    public FixedValueEntry(int locationInContainerInBits, SequenceEntry.ReferenceLocationType location, String name, byte[] binaryValue, int sizeInBits) {
        super(locationInContainerInBits, location);
        if (sizeInBits > binaryValue.length * 8) {
            throw new IllegalArgumentException("binaryValue has to have at least sizeInBits(" + sizeInBits + ") bits, instead of " + binaryValue.length * 8);
        }
        this.name = name;
        this.binaryValue = binaryValue;
        this.sizeInBits = sizeInBits;
    }

    public String getName() {
        return this.name;
    }

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public String toString() {
        return "FixedValueEntry position:" + this.getIndex() + ", container:" + this.container.getName() + " locationInContainer:" + this.getLocationInContainerInBits() + " from:" + this.getReferenceLocation() + ", sizeInBits: " + this.sizeInBits + ", binaryValue: " + HexUtils.hex(this.binaryValue);
    }
}

