/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.BaseDataType;
import org.yamcs.xtce.FloatValidRange;
import org.yamcs.xtce.NumberFormatType;
import org.yamcs.xtce.NumericDataType;

public abstract class FloatDataType
extends NumericDataType {
    private static final long serialVersionUID = 1L;
    Double initialValue;
    FloatValidRange validRange;
    int sizeInBits = 32;
    NumberFormatType numberFormat;

    protected FloatDataType(Builder<?> builder) {
        super((BaseDataType.Builder<?>)builder);
        this.validRange = builder.validRange;
        this.numberFormat = builder.numberFormat;
        if (builder.sizeInBits != null) {
            this.sizeInBits = builder.sizeInBits;
        }
        if (builder.baseType instanceof FloatDataType) {
            FloatDataType baseType = (FloatDataType)builder.baseType;
            if (builder.sizeInBits == null) {
                this.sizeInBits = baseType.sizeInBits;
            }
            if (builder.validRange == null && baseType.validRange != null) {
                this.validRange = baseType.validRange;
            }
            if (builder.numberFormat == null && baseType.numberFormat != null) {
                this.numberFormat = baseType.numberFormat;
            }
        }
        this.setInitialValue(builder);
    }

    protected FloatDataType(FloatDataType t) {
        super(t);
        this.validRange = t.validRange;
        this.sizeInBits = t.sizeInBits;
        this.numberFormat = t.numberFormat;
    }

    @Override
    public Double getInitialValue() {
        return this.initialValue;
    }

    @Override
    protected void setInitialValue(Object initialValue) {
        this.initialValue = this.convertType(initialValue);
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    public FloatValidRange getValidRange() {
        return this.validRange;
    }

    public NumberFormatType getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public Double convertType(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            try {
                if (this.sizeInBits == 32) {
                    return Float.parseFloat(stringValue);
                }
                return Double.parseDouble(stringValue);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Not a valid float");
            }
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        throw new IllegalArgumentException("Cannot convert value of type '" + value.getClass() + "'");
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return this.sizeInBits <= 32 ? Yamcs.Value.Type.FLOAT : Yamcs.Value.Type.DOUBLE;
    }

    @Override
    public String getTypeAsString() {
        return "float";
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseDataType.Builder<T> {
        private FloatValidRange validRange;
        Integer sizeInBits;
        private NumberFormatType numberFormat;

        public Builder() {
        }

        public Builder(FloatDataType dataType) {
            super(dataType);
            this.validRange = dataType.validRange;
            this.sizeInBits = dataType.sizeInBits;
        }

        public T setSizeInBits(int sizeInBits) {
            this.sizeInBits = sizeInBits;
            return (T)((Builder)this.self());
        }

        public T setValidRange(FloatValidRange validRange) {
            this.validRange = validRange;
            return (T)((Builder)this.self());
        }

        public T setInitialValue(double initialValue) {
            this.initialValue = Double.toString(initialValue);
            return (T)((Builder)this.self());
        }

        public T setNumberFormat(NumberFormatType numberFormat) {
            this.numberFormat = numberFormat;
            return (T)((Builder)this.self());
        }
    }
}

