/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import org.yamcs.xtce.ArgumentInstanceRef;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterOrArgumentRef;

public class InputParameter
implements Serializable {
    private static final long serialVersionUID = 4L;
    private final ParameterInstanceRef parameterInstance;
    private final ArgumentInstanceRef argumentRef;
    private String inputName;
    private boolean mandatory = false;

    private InputParameter(ParameterInstanceRef parameterInstance, ArgumentInstanceRef argRef, String inputName) {
        this.parameterInstance = parameterInstance;
        this.argumentRef = argRef;
        this.inputName = inputName;
    }

    public InputParameter(ParameterInstanceRef parameterInstance) {
        this(parameterInstance, null, null);
    }

    public InputParameter(ParameterInstanceRef parameterInstance, String inputName) {
        this(parameterInstance, null, inputName);
    }

    public InputParameter(ArgumentInstanceRef argumentRef, String inputName) {
        this(null, argumentRef, inputName);
    }

    public ParameterInstanceRef getParameterInstance() {
        return this.parameterInstance;
    }

    public ArgumentInstanceRef getArgumentRef() {
        return this.argumentRef;
    }

    public ParameterOrArgumentRef getRef() {
        return this.parameterInstance == null ? this.argumentRef : this.parameterInstance;
    }

    public String getInputName() {
        return this.inputName;
    }

    public String getEffectiveInputName() {
        if (this.inputName != null) {
            return this.inputName;
        }
        if (this.parameterInstance != null) {
            return this.parameterInstance.getParameter().getName();
        }
        return this.argumentRef.getArgument().getName();
    }

    public void setInputName(String inputName) {
        this.inputName = inputName;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    public String toString() {
        if (this.inputName == null) {
            return this.parameterInstance.toString() + (this.mandatory ? "[M]" : "");
        }
        return this.parameterInstance + " inputName:" + this.inputName + (this.mandatory ? "[M]" : "");
    }
}

