/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.math.BigInteger;
import org.yamcs.protobuf.Yamcs;
import org.yamcs.xtce.BaseDataType;
import org.yamcs.xtce.IntegerValidRange;
import org.yamcs.xtce.NumberFormatType;
import org.yamcs.xtce.NumericDataType;

public abstract class IntegerDataType
extends NumericDataType {
    private static final long serialVersionUID = 1L;
    int sizeInBits = 32;
    protected boolean signed = true;
    Long initialValue;
    IntegerValidRange validRange;
    NumberFormatType numberFormat;

    protected IntegerDataType(Builder<?> builder) {
        super((BaseDataType.Builder<?>)builder);
        if (builder.sizeInBits != null) {
            this.sizeInBits = builder.sizeInBits;
        }
        if (builder.signed != null) {
            this.signed = builder.signed;
        }
        if (builder.validRange != null) {
            this.validRange = builder.validRange;
        }
        if (builder.numberFormat != null) {
            this.numberFormat = builder.numberFormat;
        }
        if (builder.baseType instanceof IntegerDataType) {
            IntegerDataType baseType = (IntegerDataType)builder.baseType;
            if (builder.sizeInBits == null) {
                this.sizeInBits = baseType.sizeInBits;
            }
            if (builder.signed == null) {
                this.signed = baseType.signed;
            }
            if (builder.validRange == null && baseType.validRange != null) {
                this.validRange = baseType.validRange;
            }
            if (builder.numberFormat == null && baseType.numberFormat != null) {
                this.numberFormat = baseType.numberFormat;
            }
        }
        this.setInitialValue(builder);
    }

    protected IntegerDataType(IntegerDataType t) {
        super(t);
        this.sizeInBits = t.sizeInBits;
        this.signed = t.signed;
        this.validRange = t.validRange;
        this.numberFormat = t.numberFormat;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getSizeInBits() {
        return this.sizeInBits;
    }

    @Override
    protected void setInitialValue(Object initialValue) {
        this.initialValue = this.convertType(initialValue);
    }

    public IntegerValidRange getValidRange() {
        return this.validRange;
    }

    public void setInitialValue(Long initialValue) {
        this.initialValue = initialValue;
    }

    @Override
    public Long getInitialValue() {
        return this.initialValue;
    }

    public NumberFormatType getNumberFormat() {
        return this.numberFormat;
    }

    @Override
    public Long convertType(Object value) {
        if (value instanceof Number) {
            long longValue = ((Number)value).longValue();
            boolean negative = longValue < 0L;
            BigInteger bn = BigInteger.valueOf(negative ? -longValue : longValue);
            int bs = this.sizeInBits;
            if (this.signed) {
                --bs;
            }
            if (bn.bitLength() > bs) {
                throw new NumberFormatException("Number " + longValue + " does not fit the bit size (" + this.sizeInBits + (this.signed ? "/signed" : "unsigned") + ")");
            }
            long x = bn.longValue();
            if (negative) {
                x = -x;
            }
            return x;
        }
        if (value instanceof String) {
            BigInteger bn;
            String stringValue = (String)value;
            String sv = stringValue.replace("_", "");
            if (sv.length() == 0) {
                throw new NumberFormatException("Zero length string");
            }
            int off = 0;
            char sv0 = sv.charAt(0);
            boolean negative = false;
            int radix = 10;
            if (sv0 == '-') {
                if (!this.signed) {
                    throw new NumberFormatException("negative number specified for unsigned integer");
                }
                negative = true;
                ++off;
            } else if (sv0 == '+') {
                ++off;
            }
            if (sv.startsWith("0b", off) || sv.startsWith("0B", off)) {
                off += 2;
                radix = 2;
            } else if (sv.startsWith("0o", off) || sv.startsWith("0O", off)) {
                off += 2;
                radix = 8;
            } else if (sv.startsWith("0x", off) || sv.startsWith("0X", off)) {
                off += 2;
                radix = 16;
            }
            if (sv.startsWith("-", off) || sv.startsWith("+", off)) {
                throw new NumberFormatException("Sign character in the middle of the number");
            }
            try {
                bn = new BigInteger(sv.substring(off), radix);
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("Not a valid integer");
            }
            int bs = this.sizeInBits;
            if (this.signed) {
                --bs;
            }
            if (bn.bitLength() > bs) {
                throw new NumberFormatException("Number " + stringValue + " does not fit the bit size (" + this.sizeInBits + (this.signed ? "/signed" : "unsigned") + ")");
            }
            long x = bn.longValue();
            if (negative) {
                x = -x;
            }
            return x;
        }
        throw new IllegalArgumentException("Cannot convert value of type '" + value.getClass() + "'");
    }

    @Override
    public Yamcs.Value.Type getValueType() {
        return this.sizeInBits > 32 ? (this.signed ? Yamcs.Value.Type.SINT64 : Yamcs.Value.Type.UINT64) : (this.signed ? Yamcs.Value.Type.SINT32 : Yamcs.Value.Type.UINT32);
    }

    @Override
    public String getTypeAsString() {
        return "integer";
    }

    public static abstract class Builder<T extends Builder<T>>
    extends BaseDataType.Builder<T> {
        Integer sizeInBits;
        Boolean signed;
        IntegerValidRange validRange;
        NumberFormatType numberFormat;

        public Builder() {
        }

        public Builder(IntegerDataType dataType) {
            super(dataType);
            this.sizeInBits = dataType.sizeInBits;
            this.signed = dataType.signed;
            this.validRange = dataType.validRange;
            this.numberFormat = dataType.numberFormat;
        }

        public T setSizeInBits(int sizeInBits) {
            this.sizeInBits = sizeInBits;
            return (T)((Builder)this.self());
        }

        public T setSigned(boolean signed) {
            this.signed = signed;
            return (T)((Builder)this.self());
        }

        public boolean isSigned() {
            return this.signed == null ? true : this.signed;
        }

        public T setValidRange(IntegerValidRange range) {
            this.validRange = range;
            return (T)((Builder)this.self());
        }

        public T setNumberFormat(NumberFormatType numberFormat) {
            this.numberFormat = numberFormat;
            return (T)((Builder)this.self());
        }
    }
}

