/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.Set;
import java.util.logging.Logger;
import org.yamcs.xtce.ANDedConditions;
import org.yamcs.xtce.Comparison;
import org.yamcs.xtce.ComparisonList;
import org.yamcs.xtce.Condition;
import org.yamcs.xtce.ExpressionList;
import org.yamcs.xtce.ORedConditions;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterOrArgumentRef;
import org.yamcs.xtce.PathElement;

public interface MatchCriteria
extends Serializable {
    public Set<Parameter> getDependentParameters();

    public static String printExpressionReference(ParameterOrArgumentRef ref) {
        Object fullName = ref.getName();
        PathElement[] path = ref.getMemberPath();
        if (path != null) {
            for (PathElement el : path) {
                if (el.getName() != null) {
                    fullName = (String)fullName + ".";
                }
                fullName = (String)fullName + el;
            }
        }
        if (!ref.useCalibratedValue()) {
            return "'raw://" + (String)fullName + "'";
        }
        return "'" + (String)fullName + "'";
    }

    public static String printExpressionValue(Object value) {
        if (value instanceof String) {
            String escaped = ((String)value).replace("\\", "\\\\").replace("\"", "\\\"");
            return "\"" + escaped + "\"";
        }
        return String.valueOf(value);
    }

    public static void printParsedMatchCriteria(Logger log, MatchCriteria criteria, String indent) {
        if (criteria instanceof Comparison) {
            log.fine(indent + criteria.toString());
        } else if (criteria instanceof ComparisonList) {
            log.fine(indent + "ComparisonList (");
            for (Comparison comparison : ((ComparisonList)criteria).comparisons) {
                log.fine(indent + "  " + comparison.toString());
            }
            log.fine(indent + ")");
        } else if (criteria instanceof Condition) {
            log.fine(indent + criteria.toString());
        } else if (criteria instanceof ANDedConditions) {
            log.fine(indent + "AND (");
            for (MatchCriteria matchCriteria : ((ExpressionList)criteria).expressions) {
                MatchCriteria.printParsedMatchCriteria(log, matchCriteria, indent + "  ");
            }
            log.fine(indent + ")");
        } else if (criteria instanceof ORedConditions) {
            log.fine(indent + "OR (");
            for (MatchCriteria matchCriteria : ((ExpressionList)criteria).expressions) {
                MatchCriteria.printParsedMatchCriteria(log, matchCriteria, indent + "  ");
            }
            log.fine(indent + ")");
        }
    }
}

