/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yamcs.xtce.Argument;
import org.yamcs.xtce.ArgumentAssignment;
import org.yamcs.xtce.CommandContainer;
import org.yamcs.xtce.CommandVerifier;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.Significance;
import org.yamcs.xtce.TransmissionConstraint;

public class MetaCommand
extends NameDescription {
    private static final long serialVersionUID = 5L;
    List<Argument> argumentList = new ArrayList<Argument>();
    CommandContainer commandContainer;
    MetaCommand baseMetaCommand;
    List<ArgumentAssignment> argumentAssignmentList;
    private Significance defaultSignificance = null;
    boolean abstractCmd = false;
    List<TransmissionConstraint> transmissionContstraintList = new ArrayList<TransmissionConstraint>();
    private List<CommandVerifier> verifierList = new ArrayList<CommandVerifier>();

    public MetaCommand(String name) {
        super(name);
    }

    public void setAbstract(boolean a) {
        this.abstractCmd = a;
    }

    public boolean isAbstract() {
        return this.abstractCmd;
    }

    public void setCommandContainer(CommandContainer mcc) {
        this.commandContainer = mcc;
    }

    public CommandContainer getCommandContainer() {
        return this.commandContainer;
    }

    public void setBaseMetaCommand(MetaCommand mc) {
        this.baseMetaCommand = mc;
    }

    public MetaCommand getBaseMetaCommand() {
        return this.baseMetaCommand;
    }

    public List<ArgumentAssignment> getArgumentAssignmentList() {
        if (this.argumentAssignmentList == null) {
            return null;
        }
        return Collections.unmodifiableList(this.argumentAssignmentList);
    }

    public List<Argument> getArgumentList() {
        if (this.argumentList == null) {
            return null;
        }
        return Collections.unmodifiableList(this.argumentList);
    }

    public List<Argument> getEffectiveArgumentList() {
        List<MetaCommand> mclist = this.getHierarchy();
        ArrayList<Argument> r = new ArrayList<Argument>();
        for (int i = mclist.size() - 1; i >= 0; --i) {
            MetaCommand mc = mclist.get(i);
            if (mc.argumentList == null) continue;
            r.addAll(mc.argumentList);
        }
        return r;
    }

    public List<ArgumentAssignment> getEffectiveArgumentAssignmentList() {
        List<MetaCommand> mclist = this.getHierarchy();
        ArrayList<ArgumentAssignment> r = new ArrayList<ArgumentAssignment>();
        for (int i = mclist.size() - 1; i >= 0; --i) {
            MetaCommand mc = mclist.get(i);
            if (mc.argumentAssignmentList == null) continue;
            r.addAll(mc.argumentAssignmentList);
        }
        return r;
    }

    private List<MetaCommand> getHierarchy() {
        ArrayList<MetaCommand> mcList = new ArrayList<MetaCommand>();
        for (MetaCommand mc = this; mc != null; mc = mc.getBaseMetaCommand()) {
            mcList.add(mc);
        }
        return mcList;
    }

    public Argument getArgument(String argumentName) {
        for (Argument a : this.argumentList) {
            if (!a.getName().equals(argumentName)) continue;
            return a;
        }
        return null;
    }

    public Argument getEffectiveArgument(String argumentName) {
        Argument arg = this.getArgument(argumentName);
        if (arg == null && this.baseMetaCommand != null) {
            arg = this.baseMetaCommand.getEffectiveArgument(argumentName);
        }
        return arg;
    }

    public void addArgument(Argument arg) {
        this.argumentList.stream().filter(a -> a.getName().equals(arg.getName())).findFirst().ifPresent(a -> {
            throw new IllegalArgumentException("An argument named '" + arg.getName() + "' already exists");
        });
        this.argumentList.add(arg);
    }

    public void addTransmissionConstrain(TransmissionConstraint constraint) {
        this.transmissionContstraintList.add(constraint);
    }

    public List<TransmissionConstraint> getTransmissionConstraintList() {
        return this.transmissionContstraintList;
    }

    public void addArgumentAssignment(ArgumentAssignment aa) {
        if (this.argumentAssignmentList == null) {
            this.argumentAssignmentList = new ArrayList<ArgumentAssignment>();
        }
        this.argumentAssignmentList.add(aa);
    }

    public boolean hasTransmissionConstraints() {
        return !this.transmissionContstraintList.isEmpty();
    }

    public Significance getEffectiveDefaultSignificance() {
        return this.defaultSignificance != null ? this.defaultSignificance : (this.baseMetaCommand != null ? this.baseMetaCommand.getEffectiveDefaultSignificance() : null);
    }

    public Significance getDefaultSignificance() {
        return this.defaultSignificance;
    }

    public void setDefaultSignificance(Significance defaultSignificance) {
        this.defaultSignificance = defaultSignificance;
    }

    public void addVerifier(CommandVerifier cmdVerifier) {
        this.verifierList.add(cmdVerifier);
    }

    public boolean hasCommandVerifiers() {
        return !this.verifierList.isEmpty() || this.baseMetaCommand != null && this.baseMetaCommand.hasCommandVerifiers();
    }

    public List<CommandVerifier> getCommandVerifiers() {
        return Collections.unmodifiableList(this.verifierList);
    }

    public void print(PrintStream out) {
        out.print("MetaCommand name: " + this.name + " abstract:" + this.abstractCmd);
        if (this.getAliasSet() != null) {
            out.print(", aliases: " + this.getAliasSet());
        }
        if (!this.transmissionContstraintList.isEmpty()) {
            out.print(", TransmissionConstraints: ");
            out.print(this.transmissionContstraintList.toString());
        }
        if (this.defaultSignificance != null) {
            out.print(", defaultSignificance: ");
            out.print(this.defaultSignificance.toString());
        }
        if (!this.verifierList.isEmpty()) {
            out.print(", Verifiers: ");
            out.print(this.verifierList.toString());
        }
        out.println();
        if (this.baseMetaCommand != null) {
            out.println("\t baseMetaCommand: " + this.baseMetaCommand.getName() + " with argument assignment:" + this.argumentAssignmentList);
        }
        if (this.commandContainer != null) {
            this.commandContainer.print(out);
        }
    }

    public void setArgumentAssignmentList(List<ArgumentAssignment> argumentAssignmentList) {
        this.argumentAssignmentList = argumentAssignmentList;
    }
}

