/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.yamcs.xtce.AncillaryData;
import org.yamcs.xtce.xml.XtceAliasSet;

public class NameDescription
implements Serializable {
    private static final long serialVersionUID = 200706050619L;
    public static char PATH_SEPARATOR = (char)47;
    protected String name = null;
    protected String qualifiedName = null;
    protected XtceAliasSet xtceAliasSet = XtceAliasSet.NO_ALIAS;
    protected List<AncillaryData> ancillaryData = null;
    String shortDescription;
    String longDescription;

    public NameDescription(Builder<?> builder) {
        this.name = builder.name;
        this.longDescription = builder.longDescription;
        this.shortDescription = builder.shortDescription;
        this.ancillaryData = builder.ancillaryData;
        this.xtceAliasSet = builder.xtceAliasSet;
        this.qualifiedName = builder.qualifiedName;
    }

    NameDescription(String name) {
        this.name = name;
    }

    protected NameDescription(NameDescription t) {
        this.ancillaryData = t.ancillaryData;
        this.longDescription = t.longDescription;
        this.shortDescription = t.shortDescription;
        this.name = t.name;
        this.qualifiedName = t.qualifiedName;
        this.xtceAliasSet = t.xtceAliasSet;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public String getAlias(String namespace) {
        if (this.xtceAliasSet == null) {
            return null;
        }
        return this.xtceAliasSet.getAlias(namespace);
    }

    public void setQualifiedName(String qname) {
        if (!qname.endsWith(this.name)) {
            throw new IllegalArgumentException("qualified name '" + qname + "' must end with '" + this.name + "'");
        }
        this.qualifiedName = qname;
    }

    public void addAncillaryData(AncillaryData data) {
        if (this.ancillaryData == null) {
            this.ancillaryData = new ArrayList<AncillaryData>();
        }
        this.ancillaryData.add(data);
    }

    public void setAncillaryData(List<AncillaryData> ancillaryData) {
        this.ancillaryData = ancillaryData;
    }

    public List<AncillaryData> getAncillaryData() {
        return this.ancillaryData;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setAliasSet(XtceAliasSet aliasSet) {
        this.xtceAliasSet = aliasSet;
    }

    public XtceAliasSet getAliasSet() {
        return this.xtceAliasSet;
    }

    public void addAliases(XtceAliasSet newAliases) {
        if (this.xtceAliasSet == XtceAliasSet.NO_ALIAS) {
            this.xtceAliasSet = new XtceAliasSet();
        }
        for (Map.Entry<String, String> e : newAliases.getAliases().entrySet()) {
            this.xtceAliasSet.addAlias(e.getKey(), e.getValue());
        }
    }

    public void addAlias(String namespace, String alias) {
        if (this.xtceAliasSet == XtceAliasSet.NO_ALIAS) {
            this.xtceAliasSet = new XtceAliasSet();
        }
        this.xtceAliasSet.addAlias(namespace, alias);
    }

    public static String qualifiedName(String root, String ... subsystems) {
        if (root.charAt(0) != PATH_SEPARATOR) {
            throw new IllegalArgumentException("root has to start with " + PATH_SEPARATOR);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(root);
        for (String s : subsystems) {
            if (s.charAt(0) != PATH_SEPARATOR) {
                sb.append(PATH_SEPARATOR);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public String getOpsName() {
        String alias = this.xtceAliasSet.getAlias("MDB:OPS Name");
        if (alias != null) {
            return alias;
        }
        return this.name;
    }

    public String getSubsystemName() {
        return NameDescription.getSubsystemName(this.qualifiedName);
    }

    public static String getName(String fqname) {
        int index = fqname.lastIndexOf(PATH_SEPARATOR);
        if (index < 0) {
            return fqname;
        }
        return fqname.substring(index + 1);
    }

    public static String getSubsystemName(String fqname) {
        int index = fqname.lastIndexOf(PATH_SEPARATOR);
        if (index == 0) {
            return String.valueOf(PATH_SEPARATOR);
        }
        if (index < 0) {
            throw new RuntimeException("Illegal qualified name '" + fqname + "'");
        }
        return fqname.substring(0, index);
    }

    public static abstract class Builder<T extends Builder<T>> {
        private String name;
        private XtceAliasSet xtceAliasSet = XtceAliasSet.NO_ALIAS;
        private List<AncillaryData> ancillaryData = null;
        private String shortDescription;
        private String longDescription;
        private String qualifiedName;

        public Builder() {
        }

        public Builder(NameDescription nd) {
            this.name = nd.name;
            this.xtceAliasSet = nd.xtceAliasSet;
            this.ancillaryData = nd.ancillaryData;
            this.shortDescription = nd.shortDescription;
            this.longDescription = nd.longDescription;
            this.qualifiedName = nd.qualifiedName;
        }

        public T setName(String name) {
            this.name = name;
            return this.self();
        }

        public T setQualifiedName(String fqn) {
            this.qualifiedName = fqn;
            return this.self();
        }

        public T setLongDescription(String longDescription) {
            this.longDescription = longDescription;
            return this.self();
        }

        public T setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this.self();
        }

        public T setAliasSet(XtceAliasSet aliasSet) {
            this.xtceAliasSet = aliasSet;
            return this.self();
        }

        public T addAlias(String namespace, String alias) {
            if (this.xtceAliasSet == XtceAliasSet.NO_ALIAS) {
                this.xtceAliasSet = new XtceAliasSet();
            }
            this.xtceAliasSet.addAlias(namespace, alias);
            return this.self();
        }

        public void setAncillaryData(List<AncillaryData> ancillaryData) {
            this.ancillaryData = ancillaryData;
        }

        protected T self() {
            return (T)this;
        }

        public String getName() {
            return this.name;
        }
    }
}

