/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.util.ArrayList;

public class PathElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String name;
    final int[] index;

    public PathElement(String name, int[] index) {
        this.name = name;
        this.index = index;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        if (this.index != null) {
            for (int i = 0; i < this.index.length; ++i) {
                sb.append("[").append(this.index[i]).append("]");
            }
        }
        return sb.toString();
    }

    public static PathElement fromString(String s) {
        String name;
        ArrayList<Integer> idx = new ArrayList<Integer>();
        int k = s.indexOf(91, 0);
        if (k == -1) {
            return new PathElement(s, null);
        }
        String string = name = k > 0 ? s.substring(0, k) : null;
        while ((k = s.indexOf(91, k)) != -1) {
            int k2 = s.indexOf(93, k);
            if (k2 == -1) {
                throw new IllegalArgumentException("Invalid aggregate member path '" + s + "'");
            }
            int n = Integer.parseInt(s.substring(k + 1, k2));
            if (n < 0) {
                throw new IllegalArgumentException("Negative array index: " + n);
            }
            idx.add(n);
            k = k2;
        }
        int[] idx1 = null;
        if (!idx.isEmpty()) {
            idx1 = new int[idx.size()];
            for (int u = 0; u < idx.size(); ++u) {
                idx1[u] = (Integer)idx.get(u);
            }
        }
        return new PathElement(name, idx1);
    }

    public String getName() {
        return this.name;
    }

    public int[] getIndex() {
        return this.index;
    }

    public static String pathToString(PathElement[] path) {
        if (path == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (PathElement pe : path) {
            if (first) {
                first = false;
            } else {
                sb.append("/");
            }
            sb.append(pe.toString());
        }
        return sb.toString();
    }
}

