/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;

public class Significance
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String reasonForWarning;
    private Levels consequenceLevel;

    public Significance(Levels consequenceLevel, String reasonForWarning) {
        this.reasonForWarning = reasonForWarning;
        this.consequenceLevel = consequenceLevel;
    }

    public String getReasonForWarning() {
        return this.reasonForWarning;
    }

    public Levels getConsequenceLevel() {
        return this.consequenceLevel;
    }

    public String toString() {
        return this.consequenceLevel + "(" + this.reasonForWarning + ")";
    }

    public static enum Levels {
        NONE("normal"),
        WATCH("user1"),
        WARNING("user2"),
        DISTRESS("vital"),
        CRITICAL("critical"),
        SEVERE("forbidden");

        private String xtceAlias;

        private Levels(String xtceAlias) {
            this.xtceAlias = xtceAlias;
        }

        public String xtceAlias() {
            return this.xtceAlias;
        }

        public boolean isMoreSevere(Levels other) {
            return this.ordinal() > other.ordinal();
        }

        public static Levels fromString(String value) {
            try {
                return Levels.valueOf(value.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                for (Levels level : Levels.values()) {
                    if (!level.xtceAlias.equalsIgnoreCase(value)) continue;
                    return level;
                }
                throw e;
            }
        }
    }
}

