/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.nio.charset.Charset;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.DynamicIntegerValue;

public class StringDataEncoding
extends DataEncoding {
    private static final long serialVersionUID = 1L;
    private DynamicIntegerValue dynamicBufferSize;
    private SizeType sizeType;
    private byte terminationChar = 0;
    int sizeInBytesOfSizeTag = 2;
    private String encoding = "UTF-8";
    private int maxSizeInBytes = -1;

    public StringDataEncoding(Builder builder) {
        super(builder, -1);
        this.sizeType = builder.sizeType;
        if (builder.terminationChar != null) {
            this.terminationChar = builder.terminationChar;
        }
        if (builder.sizeInBytesOfSizeTag != null) {
            this.sizeInBytesOfSizeTag = builder.sizeInBytesOfSizeTag;
        }
        if (builder.encoding != null) {
            this.encoding = builder.encoding;
        }
        this.maxSizeInBytes = builder.maxSizeInBytes;
        this.dynamicBufferSize = builder.dynamicBufferSize;
        if (builder.baseEncoding instanceof StringDataEncoding) {
            StringDataEncoding baseEncoding = (StringDataEncoding)builder.baseEncoding;
            if (builder.sizeType == null) {
                this.sizeType = baseEncoding.sizeType;
            }
            if (builder.terminationChar == null) {
                this.terminationChar = baseEncoding.terminationChar;
            }
            if (builder.sizeInBytesOfSizeTag == null) {
                this.sizeInBytesOfSizeTag = baseEncoding.sizeInBytesOfSizeTag;
            }
            if (builder.encoding == null) {
                this.encoding = baseEncoding.encoding;
            }
            if (builder.dynamicBufferSize == null) {
                this.dynamicBufferSize = baseEncoding.dynamicBufferSize;
            }
            if (builder.maxSizeInBytes == -1) {
                this.maxSizeInBytes = baseEncoding.maxSizeInBytes;
            }
        }
    }

    StringDataEncoding(StringDataEncoding sde) {
        super(sde);
        this.sizeType = sde.sizeType;
        this.terminationChar = sde.terminationChar;
        this.sizeInBytesOfSizeTag = sde.sizeInBytesOfSizeTag;
        this.encoding = sde.encoding;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public void setSizeType(SizeType sizeType) {
        this.sizeType = sizeType;
    }

    public SizeType getSizeType() {
        return this.sizeType;
    }

    public int getSizeInBytesOfSizeTag() {
        return this.sizeInBytesOfSizeTag;
    }

    public int getSizeInBitsOfSizeTag() {
        return this.sizeInBytesOfSizeTag << 3;
    }

    public byte getTerminationChar() {
        return this.terminationChar;
    }

    public void setTerminationChar(byte tc) {
        this.terminationChar = tc;
    }

    public DynamicIntegerValue getDynamicBufferSize() {
        return this.dynamicBufferSize;
    }

    public int getMaxSizeInBytes() {
        return this.maxSizeInBytes;
    }

    public void setMaxSizeInBytes(int maxSizeInBytes) {
        this.maxSizeInBytes = maxSizeInBytes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StringDataEncoding size: ");
        sb.append((Object)this.getSizeType()).append("(");
        switch (this.getSizeType()) {
            case FIXED: {
                sb.append("fixedSizeInBits=" + this.getSizeInBits());
                break;
            }
            case LEADING_SIZE: {
                sb.append("sizeInBitsOfSizeTag=" + this.getSizeInBitsOfSizeTag());
                if (this.getSizeInBits() != -1) {
                    sb.append(", sizeInBits=" + this.getSizeInBits());
                    break;
                }
                if (this.dynamicBufferSize == null) break;
                sb.append(", dynamicBufferSize=").append(this.dynamicBufferSize);
                break;
            }
            case TERMINATION_CHAR: {
                sb.append("terminationChar=" + this.getTerminationChar());
                if (this.getSizeInBits() != -1) {
                    sb.append(", sizeInBits=" + this.getSizeInBits());
                    break;
                }
                if (this.dynamicBufferSize == null) break;
                sb.append(", dynamicBufferSize=").append(this.dynamicBufferSize);
                break;
            }
            case CUSTOM: {
                sb.append(this.getFromBinaryTransformAlgorithm());
            }
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Object parseString(String stringValue) {
        return stringValue;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        Charset.forName(encoding);
        this.encoding = encoding;
    }

    @Override
    public StringDataEncoding copy() {
        return new StringDataEncoding(this);
    }

    public static class Builder
    extends DataEncoding.Builder<Builder> {
        private SizeType sizeType;
        private Byte terminationChar = null;
        Integer sizeInBytesOfSizeTag = null;
        private String encoding = "UTF-8";
        private DynamicIntegerValue dynamicBufferSize;
        private int maxSizeInBytes = -1;

        public Builder(StringDataEncoding encoding) {
            super(encoding);
            this.sizeType = encoding.sizeType;
            this.terminationChar = encoding.terminationChar;
            this.sizeInBytesOfSizeTag = encoding.sizeInBytesOfSizeTag;
        }

        public Builder() {
        }

        @Override
        public StringDataEncoding build() {
            return new StringDataEncoding(this);
        }

        @Override
        public Builder setSizeInBits(Integer sizeInBits) {
            if (sizeInBits > 0) {
                if (sizeInBits % 8 != 0) {
                    throw new IllegalArgumentException("Size in bits for string encoding has to be multiple of 8.");
                }
                this.maxSizeInBytes = sizeInBits / 8;
            }
            super.setSizeInBits(sizeInBits);
            return (Builder)this.self();
        }

        public Builder setSizeType(SizeType sizeType) {
            this.sizeType = sizeType;
            return (Builder)this.self();
        }

        public Builder setTerminationChar(byte terminationChar) {
            this.terminationChar = terminationChar;
            return (Builder)this.self();
        }

        public Builder setSizeInBitsOfSizeTag(int size) {
            if ((size & 7) != 0) {
                throw new IllegalArgumentException("Size in bits of size tag has to be a multiple of 8");
            }
            this.sizeInBytesOfSizeTag = size >> 3;
            return (Builder)this.self();
        }

        public Builder setEncoding(String stringEncoding) {
            this.encoding = stringEncoding;
            return (Builder)this.self();
        }

        public Builder setMaxSizeInBits(int maxSizeInBits) {
            if (maxSizeInBits % 8 != 0) {
                throw new IllegalArgumentException("Maximum size in bits for string encoding has to be multiple of 8.");
            }
            this.maxSizeInBytes = maxSizeInBits / 8;
            return (Builder)this.self();
        }

        public Builder setDynamicBufferSize(DynamicIntegerValue div) {
            this.dynamicBufferSize = div;
            return (Builder)this.self();
        }

        public SizeType getSizeType() {
            return this.sizeType;
        }
    }

    public static enum SizeType {
        FIXED,
        TERMINATION_CHAR,
        LEADING_SIZE,
        CUSTOM;

    }
}

