/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import org.yamcs.xtce.DataSource;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.Parameter;

public class SystemParameter
extends Parameter {
    private static final long serialVersionUID = 2L;

    private SystemParameter(String spaceSystemName, String name, DataSource ds) {
        super(name);
        this.setQualifiedName(spaceSystemName + "/" + name);
        this.setDataSource(ds);
    }

    public static SystemParameter getForFullyQualifiedName(String fqname) {
        DataSource ds = SystemParameter.getSystemParameterDataSource(fqname);
        SystemParameter sp = new SystemParameter(NameDescription.getSubsystemName(fqname), NameDescription.getName(fqname), ds);
        int pos = fqname.indexOf(PATH_SEPARATOR, 0);
        pos = fqname.indexOf(PATH_SEPARATOR, pos + 1);
        pos = fqname.indexOf(PATH_SEPARATOR, pos + 1);
        sp.setRecordingGroup(fqname.substring(0, pos));
        return sp;
    }

    private static DataSource getSystemParameterDataSource(String fqname) {
        if (fqname.startsWith("/yamcs/cmd")) {
            return DataSource.COMMAND;
        }
        if (fqname.startsWith("/yamcs/cmdHist")) {
            return DataSource.COMMAND_HISTORY;
        }
        return DataSource.SYSTEM;
    }

    @Override
    public String toString() {
        return "SysParam(qname=" + this.getQualifiedName() + ")";
    }
}

