/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class TimeEpoch
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final CommonEpochs epoch;
    private final String dateTime;

    public TimeEpoch(CommonEpochs epoch) {
        this.epoch = epoch;
        this.dateTime = null;
    }

    public TimeEpoch(String dateTime) {
        this.epoch = null;
        if (!TimeEpoch.validate(dateTime)) {
            throw new IllegalArgumentException("Invalid date time '" + dateTime + "'");
        }
        this.dateTime = dateTime;
    }

    public CommonEpochs getCommonEpoch() {
        return this.epoch;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    private static boolean validate(String dateTime) {
        try {
            DateTimeFormatter.ISO_DATE_TIME.parse(dateTime);
            return true;
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                DateTimeFormatter.ISO_DATE.parse(dateTime);
                return true;
            }
            catch (DateTimeParseException dateTimeParseException2) {
                return false;
            }
        }
    }

    public String toString() {
        return this.epoch == null ? this.dateTime : this.epoch.toString();
    }

    public static enum CommonEpochs {
        TAI,
        J2000,
        UNIX,
        GPS;

    }
}

