/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.util;

import java.util.ArrayList;
import org.yamcs.xtce.AggregateParameterType;
import org.yamcs.xtce.ArrayParameterType;
import org.yamcs.xtce.Member;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.PathElement;

public class AggregateTypeUtil {
    public static int findSeparator(String s) {
        int found = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (found == -1 && (c == '.' || c == '[')) {
                found = i;
                continue;
            }
            if (c != '/') continue;
            found = -1;
        }
        return found;
    }

    public static PathElement[] parseReference(String name) {
        String[] a;
        ArrayList<PathElement> tmp = new ArrayList<PathElement>();
        for (String ps : a = name.split("\\.")) {
            if (ps.isEmpty()) continue;
            tmp.add(PathElement.fromString(ps));
        }
        return tmp.toArray(new PathElement[0]);
    }

    public static boolean verifyPath(ParameterType parameterType, PathElement[] path) {
        ParameterType ptype = parameterType;
        for (PathElement pe : path) {
            if (pe.getName() != null) {
                if (!(ptype instanceof AggregateParameterType)) {
                    return false;
                }
                Member m = ((AggregateParameterType)ptype).getMember(pe.getName());
                if (m == null) {
                    return false;
                }
                ptype = (ParameterType)m.getType();
            }
            if (pe.getIndex() == null) continue;
            int[] idx = pe.getIndex();
            if (!(ptype instanceof ArrayParameterType)) {
                return false;
            }
            ArrayParameterType at = (ArrayParameterType)ptype;
            if (at.getNumberOfDimensions() != idx.length) {
                return false;
            }
            ptype = (ParameterType)at.getElementType();
        }
        return true;
    }

    public static ParameterType getMemberType(ParameterType parameterType, PathElement[] path) {
        ParameterType ptype = parameterType;
        for (PathElement pe : path) {
            if (pe.getName() != null) {
                if (!(ptype instanceof AggregateParameterType)) {
                    return null;
                }
                Member m = ((AggregateParameterType)ptype).getMember(pe.getName());
                if (m == null) {
                    return null;
                }
                ptype = (ParameterType)m.getType();
            }
            if (pe.getIndex() == null) continue;
            int[] idx = pe.getIndex();
            if (!(ptype instanceof ArrayParameterType)) {
                return null;
            }
            ArrayParameterType at = (ArrayParameterType)ptype;
            if (at.getNumberOfDimensions() != idx.length) {
                return null;
            }
            ptype = (ParameterType)at.getElementType();
        }
        return ptype;
    }

    public static String toString(PathElement[] path) {
        StringBuilder sb = new StringBuilder();
        for (PathElement pe : path) {
            if (pe.getName() != null) {
                sb.append(".").append(pe.getName());
            }
            if (pe.getIndex() == null) continue;
            for (int x : pe.getIndex()) {
                sb.append("[").append(x).append("]");
            }
        }
        return sb.toString();
    }
}

