/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.util;

import org.yamcs.xtce.Argument;
import org.yamcs.xtce.MetaCommand;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.PathElement;
import org.yamcs.xtce.util.AggregateTypeUtil;
import org.yamcs.xtce.util.NameReference;
import org.yamcs.xtce.util.ReferenceFinder;

public class ArgumentReference
extends NameReference {
    PathElement[] path;
    final MetaCommand metaCmd;

    public ArgumentReference(MetaCommand metaCmd, String argName, PathElement[] path) {
        super(argName, NameReference.Type.ARGUMENT);
        this.metaCmd = metaCmd;
        this.path = path;
    }

    public ArgumentReference(MetaCommand metaCmd, Argument arg, PathElement[] path) {
        this(metaCmd, arg.getName(), path);
        this.result = arg;
    }

    public void resolved(Argument argument, PathElement[] path) {
        this.result = argument;
        for (NameReference.ResolvedAction ra : this.actions) {
            if (ra instanceof ArgumentResolvedAction) {
                ((ArgumentResolvedAction)ra).resolved(argument, path);
                continue;
            }
            ra.resolved(argument);
        }
        this.actions.clear();
    }

    public ArgumentReference addResolvedAction(ArgumentResolvedAction action) {
        this.actions.add(action);
        if (this.result != null && !action.resolved((Argument)this.result, this.path)) {
            this.actions.add(action);
        }
        return this;
    }

    public MetaCommand getMetaCommand() {
        return this.metaCmd;
    }

    public String getArgName() {
        return this.ref;
    }

    public PathElement[] getPath() {
        return this.path;
    }

    static String toString(String argName, PathElement[] path) {
        return path == null ? argName : argName + "." + AggregateTypeUtil.toString(path);
    }

    public static ArgumentReference getReference(MetaCommand metaCmd, String argRef) {
        PathElement[] path;
        String argName;
        int pos = argRef.indexOf(46);
        if (pos == -1) {
            pos = argRef.indexOf(47);
        }
        if (pos == -1) {
            argName = argRef;
            path = null;
        } else {
            argName = argRef.substring(0, pos);
            path = AggregateTypeUtil.parseReference(argRef.substring(pos));
        }
        Argument arg = null;
        for (MetaCommand tmpcmd = metaCmd; arg == null && tmpcmd != null; tmpcmd = tmpcmd.getBaseMetaCommand()) {
            arg = tmpcmd.getArgument(argName);
        }
        if (arg == null || arg.getArgumentType() == null || path != null && !ReferenceFinder.verifyPath(arg.getArgumentType(), path)) {
            return new ArgumentReference(metaCmd, argName, path);
        }
        return new ArgumentReference(metaCmd, arg, path);
    }

    @FunctionalInterface
    public static interface ArgumentResolvedAction
    extends NameReference.ResolvedAction {
        public boolean resolved(Argument var1, PathElement[] var2);

        @Override
        default public void resolved(NameDescription nd) {
            this.resolved((Argument)nd, null);
        }
    }
}

