/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.util;

import java.util.ArrayList;
import java.util.List;
import org.yamcs.xtce.ArgumentType;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.SpaceSystem;
import org.yamcs.xtce.util.NameReference;

public class IncompleteType {
    final DataType.Builder<?> typeBuilder;
    final SpaceSystem spaceSystem;
    private List<NameReference> references;

    public IncompleteType(SpaceSystem spaceSystem, DataType.Builder<?> typeBuilder) {
        this.spaceSystem = spaceSystem;
        this.typeBuilder = typeBuilder;
    }

    public DataType.Builder<?> getTypeBuilder() {
        return this.typeBuilder;
    }

    public void scheduleCompletion() {
        if (this.references == null || this.references.isEmpty()) {
            this.complete();
            return;
        }
        for (NameReference nr : this.references) {
            nr.addResolvedAction(nd -> this.tryComplete());
        }
    }

    private void tryComplete() {
        for (NameReference nr : this.references) {
            if (nr.isResolved()) continue;
            return;
        }
        this.complete();
    }

    private void complete() {
        DataType type = this.typeBuilder.build();
        if (type instanceof ParameterType) {
            this.spaceSystem.addParameterType((ParameterType)type);
        } else {
            this.spaceSystem.addArgumentType((ArgumentType)type);
        }
    }

    public void addReference(NameReference ref) {
        if (this.references == null) {
            this.references = new ArrayList<NameReference>();
        }
        this.references.add(ref);
    }
}

