/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.util;

import java.util.ArrayList;
import java.util.List;
import org.yamcs.xtce.NameDescription;

public class NameReference {
    protected List<ResolvedAction> actions = new ArrayList<ResolvedAction>();
    protected NameDescription result;
    protected final String ref;
    protected final Type type;

    public NameReference(String ref, Type type) {
        this.ref = ref;
        this.type = type;
    }

    public void resolved(NameDescription nd) {
        this.result = nd;
        for (ResolvedAction ra : this.actions) {
            ra.resolved(nd);
        }
        this.actions.clear();
    }

    public NameReference addResolvedAction(ResolvedAction action) {
        if (this.result != null) {
            action.resolved(this.result);
        } else {
            this.actions.add(action);
        }
        return this;
    }

    public String getReference() {
        return this.ref;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isResolved() {
        return this.result != null;
    }

    public String toString() {
        return this.type + "(" + this.ref + ")";
    }

    public boolean isAbsolute() {
        return this.ref.startsWith("/");
    }

    public static enum Type {
        SEQUENCE_CONTAINER,
        COMMAND_CONTAINER,
        PARAMETER,
        PARAMETER_TYPE,
        META_COMMAND,
        ALGORITHM,
        ARGUMENT_TYPE,
        ARGUMENT;

    }

    @FunctionalInterface
    public static interface ResolvedAction {
        public void resolved(NameDescription var1);
    }
}

