/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.yamcs.xtce.AggregateArgumentType;
import org.yamcs.xtce.AggregateDataType;
import org.yamcs.xtce.AggregateParameterType;
import org.yamcs.xtce.Argument;
import org.yamcs.xtce.ArgumentType;
import org.yamcs.xtce.ArrayDataType;
import org.yamcs.xtce.Container;
import org.yamcs.xtce.DataType;
import org.yamcs.xtce.Member;
import org.yamcs.xtce.MetaCommand;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.PathElement;
import org.yamcs.xtce.SpaceSystem;
import org.yamcs.xtce.SystemParameter;
import org.yamcs.xtce.util.ArgumentReference;
import org.yamcs.xtce.util.NameReference;
import org.yamcs.xtce.util.ParameterReference;

public class ReferenceFinder {
    Consumer<String> logger;

    public ReferenceFinder(Consumer<String> logger) {
        this.logger = logger;
    }

    public FoundReference findReference(SpaceSystem rootSs, NameReference nr, SpaceSystem ss) {
        String ref = nr.getReference();
        boolean absolute = false;
        SpaceSystem startSs = null;
        if (ref.startsWith("/")) {
            absolute = true;
            startSs = rootSs;
        } else if (ref.startsWith("./") || ref.startsWith("..")) {
            absolute = true;
            startSs = ss;
        }
        if (absolute) {
            return ReferenceFinder.findReference(startSs, nr);
        }
        FoundReference rr = null;
        for (startSs = ss; (rr = ReferenceFinder.findReference(startSs, nr)) == null && startSs != rootSs; startSs = startSs.getParent()) {
        }
        return rr;
    }

    private FoundReference findAliasReference(SpaceSystem ss, NameReference nr) {
        List<NameDescription> l;
        String alias = nr.getReference();
        switch (nr.getType()) {
            case PARAMETER: {
                l = ss.getParameterByAlias(alias);
                break;
            }
            case SEQUENCE_CONTAINER: {
                l = ss.getSequenceContainerByAlias(alias);
                break;
            }
            case META_COMMAND: {
                l = ss.getMetaCommandByAlias(alias);
                break;
            }
            default: {
                return null;
            }
        }
        if (l == null || l.isEmpty()) {
            return null;
        }
        if (l.size() > 1) {
            this.logger.accept("When looking for aliases '" + nr + "' found multiple matches: " + l);
        }
        return new FoundReference(l.get(0));
    }

    public FoundReference findAliasReference(SpaceSystem rootSs, NameReference nr, SpaceSystem startSs) {
        FoundReference nd = null;
        for (SpaceSystem ss = startSs; (nd = this.findAliasReference(ss, nr)) == null && ss != rootSs; ss = ss.getParent()) {
        }
        return nd;
    }

    public static FoundReference findReference(SpaceSystem startSs, NameReference nr) {
        String[] path = nr.getReference().split("/");
        SpaceSystem ss = startSs;
        for (int i = 0; i < path.length - 1; ++i) {
            if (".".equals(path[i]) || "".equals(path[i])) continue;
            if ("..".equals(path[i])) {
                if ((ss = ss.getParent()) != null) continue;
                break;
            }
            if (i == path.length - 1) break;
            SpaceSystem ss1 = ss.getSubsystem(path[i]);
            if (ss1 == null && nr.getType() == NameReference.Type.PARAMETER) {
                Parameter p = ss.getParameter(path[i]);
                if (p == null || !(p.getParameterType() instanceof AggregateParameterType)) break;
                PathElement[] aggregateMemberPath = ReferenceFinder.getAggregateMemberPath(Arrays.copyOfRange(path, i + 1, path.length));
                if (!ReferenceFinder.verifyPath(p.getParameterType(), aggregateMemberPath)) break;
                return new FoundReference(p, aggregateMemberPath);
            }
            if (ss1 == null) {
                ss = ss1;
                break;
            }
            ss = ss1;
        }
        if (ss == null) {
            return null;
        }
        String name = path[path.length - 1];
        if ("..".equals(name)) {
            return null;
        }
        switch (nr.getType()) {
            case PARAMETER: {
                return ReferenceFinder.findParameterReference(ss, name);
            }
            case PARAMETER_TYPE: {
                return ReferenceFinder.findSimpleReference((NameDescription)((Object)ss.getParameterType(name)));
            }
            case SEQUENCE_CONTAINER: {
                return ReferenceFinder.findSimpleReference(ss.getSequenceContainer(name));
            }
            case COMMAND_CONTAINER: {
                Container c = ss.getCommandContainer(name);
                if (c == null) {
                    c = ss.getSequenceContainer(name);
                }
                return ReferenceFinder.findSimpleReference(c);
            }
            case META_COMMAND: {
                return ReferenceFinder.findSimpleReference(ss.getMetaCommand(name));
            }
            case ALGORITHM: {
                return ReferenceFinder.findSimpleReference(ss.getAlgorithm(name));
            }
            case ARGUMENT_TYPE: {
                return ReferenceFinder.findArgumentTypeReference(ss, name);
            }
            case ARGUMENT: {
                return ReferenceFinder.findArgumentReference((ArgumentReference)nr);
            }
        }
        throw new IllegalStateException("Unknown reference of type " + nr.getType());
    }

    public static FoundReference findParameterReference(SpaceSystem ss, String name) {
        Parameter p;
        PathElement[] path = null;
        String pname = name;
        int idx = ReferenceFinder.findSeparator(name);
        if (idx > 0) {
            path = ReferenceFinder.parseReference(name.substring(idx));
            pname = name.substring(0, idx);
        }
        if ((p = ss.getParameter(pname)) == null) {
            return null;
        }
        ParameterType ptype = p.getParameterType();
        if (ptype != null && path != null && !ReferenceFinder.verifyPath(ptype, path)) {
            return null;
        }
        return new FoundReference(p, path);
    }

    public static FoundReference findArgumentReference(ArgumentReference argRef) {
        Argument arg = null;
        for (MetaCommand cmd = argRef.getMetaCommand(); arg == null && cmd != null; cmd = cmd.getBaseMetaCommand()) {
            arg = cmd.getArgument(argRef.getArgName());
        }
        if (arg == null) {
            return null;
        }
        ArgumentType atype = arg.getArgumentType();
        if (atype != null && argRef.getPath() != null && !ReferenceFinder.verifyPath(arg.getArgumentType(), argRef.getPath())) {
            return null;
        }
        return new FoundReference(arg, argRef.getPath());
    }

    public static FoundReference findArgumentTypeReference(SpaceSystem ss, String name) {
        AggregateArgumentType aggregateArgumentType;
        ArgumentType argumentType = ss.getArgumentType(name);
        if (argumentType != null && argumentType instanceof AggregateArgumentType && !ReferenceFinder.isAggregateArgumentTypeResolved(aggregateArgumentType = (AggregateArgumentType)argumentType)) {
            return null;
        }
        return ReferenceFinder.findSimpleReference((NameDescription)((Object)ss.getArgumentType(name)));
    }

    private static boolean isAggregateArgumentTypeResolved(AggregateArgumentType argumentType) {
        for (Member member : argumentType.getMemberList()) {
            if (member.getType() == null) {
                return false;
            }
            if (!(member.getType() instanceof AggregateArgumentType)) continue;
            return ReferenceFinder.isAggregateArgumentTypeResolved((AggregateArgumentType)member.getType());
        }
        return true;
    }

    public static PathElement[] parseReference(String name) {
        String[] p;
        ArrayList<PathElement> tmp = new ArrayList<PathElement>();
        for (String ps : p = name.split("\\.")) {
            if (ps.isEmpty()) continue;
            tmp.add(PathElement.fromString(ps));
        }
        return tmp.toArray(new PathElement[0]);
    }

    public static boolean verifyPath(DataType dataType, PathElement[] path) {
        DataType ptype = dataType;
        for (PathElement pe : path) {
            if (pe.getName() != null) {
                if (!(ptype instanceof AggregateDataType)) {
                    return false;
                }
                Member m = ((AggregateDataType)ptype).getMember(pe.getName());
                if (m == null) {
                    return false;
                }
                ptype = m.getType();
            }
            if (pe.getIndex() == null) continue;
            int[] idx = pe.getIndex();
            if (!(ptype instanceof ArrayDataType)) {
                return false;
            }
            ArrayDataType at = (ArrayDataType)ptype;
            if (at.getNumberOfDimensions() != idx.length) {
                return false;
            }
            ptype = at.getElementType();
        }
        return ptype != null;
    }

    private static FoundReference findSimpleReference(NameDescription nd) {
        if (nd == null) {
            return null;
        }
        return new FoundReference(nd);
    }

    private static PathElement[] getAggregateMemberPath(String[] path) {
        PathElement[] pea = new PathElement[path.length];
        for (int i = 0; i < path.length; ++i) {
            pea[i] = PathElement.fromString(path[i]);
        }
        return pea;
    }

    public static int findSeparator(String s) {
        int found = -1;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (found == -1 && (c == '.' || c == '[')) {
                found = i;
                continue;
            }
            if (c != '/') continue;
            found = -1;
        }
        return found;
    }

    public static class FoundReference {
        private final NameDescription nd;
        private final PathElement[] aggregateMemberPath;
        boolean complete = true;

        public FoundReference(NameDescription nd) {
            this(nd, null);
        }

        public FoundReference(Parameter parameter, PathElement[] path) {
            this((NameDescription)parameter, path);
            this.complete = parameter instanceof SystemParameter || parameter.getParameterType() != null;
        }

        public FoundReference(Argument arg, PathElement[] path) {
            this((NameDescription)arg, path);
            this.complete = arg.getArgumentType() != null;
        }

        private FoundReference(NameDescription nd, PathElement[] aggregateMemberPath) {
            if (nd == null) {
                throw new NullPointerException("nd cannot be null");
            }
            this.nd = nd;
            this.aggregateMemberPath = aggregateMemberPath;
        }

        public NameDescription getNameDescription() {
            return this.nd;
        }

        public PathElement[] getAggregateMemberPath() {
            return this.aggregateMemberPath;
        }

        public void resolved(NameReference nr) {
            if (nr instanceof ParameterReference) {
                ((ParameterReference)nr).resolved((Parameter)this.nd, this.aggregateMemberPath);
            } else if (nr instanceof ArgumentReference) {
                ((ArgumentReference)nr).resolved((Argument)this.nd, this.aggregateMemberPath);
            } else {
                nr.resolved(this.nd);
            }
        }

        public boolean isComplete() {
            return this.complete;
        }

        public String toString() {
            return this.nd.getName() + (String)(this.aggregateMemberPath == null ? "" : "." + Arrays.toString(this.aggregateMemberPath));
        }
    }
}

