/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class AbstractStaxReader
implements AutoCloseable {
    protected final XMLEventReader xmlEventReader;
    protected final String fileName;
    final InputStream in;
    protected XMLEvent xmlEvent = null;

    protected AbstractStaxReader(String fileName) throws IOException, XMLStreamException {
        this.fileName = fileName;
        this.in = new FileInputStream(new File(fileName));
        this.xmlEventReader = this.initEventReader(this.in);
    }

    private XMLEventReader initEventReader(InputStream in) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return factory.createXMLEventReader(in);
    }

    protected boolean hasAttributes(StartElement element) {
        if (element == null) {
            return false;
        }
        return element.getAttributes().hasNext();
    }

    protected boolean isStartElementWithName(String localName) {
        return this.xmlEvent.getEventType() == 1 && this.xmlEvent.asStartElement().getName().getLocalPart().equals(localName);
    }

    protected String readStringBetweenTags(String tagName) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StringBuilder longDescr = new StringBuilder();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName(tagName)) break;
            if (!this.xmlEvent.isCharacters()) {
                throw new IllegalStateException(tagName + " characters or end element expected but instead got " + this.xmlEvent);
            }
            longDescr.append(this.xmlEvent.asCharacters().getData());
        }
        return longDescr.toString();
    }

    protected StartElement checkStartElementPreconditions() throws IllegalStateException {
        if (this.xmlEvent == null) {
            throw new IllegalStateException("xmlEvent is null");
        }
        if (this.xmlEvent.getEventType() != 1) {
            throw new IllegalStateException("xmlEvent type is not start element");
        }
        return this.xmlEvent.asStartElement();
    }

    protected boolean hasAttribute(String attName, StartElement element) throws XMLStreamException {
        Attribute attribute = element.getAttributeByName(new QName(attName));
        return attribute != null;
    }

    protected String readMandatoryAttribute(String attName, StartElement element) throws XMLStreamException {
        Attribute attribute = element.getAttributeByName(new QName(attName));
        if (attribute != null) {
            return attribute.getValue();
        }
        throw new XMLStreamException("Mandatory attribute '" + attName + "' not defined", element.getLocation());
    }

    protected String readAttribute(String attName, StartElement element, String defaultValue) {
        Attribute attribute = element.getAttributeByName(new QName(attName));
        if (attribute != null) {
            return attribute.getValue();
        }
        return defaultValue;
    }

    protected int readIntAttribute(String attName, StartElement element, int defaultValue) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to integer");
        }
    }

    protected int readIntAttribute(String attName, StartElement element) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            throw new XMLStreamException("Mandatory attribute '" + attName + "' not defined");
        }
        try {
            return Integer.parseInt(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to integer");
        }
    }

    protected long readLongAttribute(String attName, StartElement element) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            throw new XMLStreamException("Mandatory attribute '" + attName + "' not defined");
        }
        try {
            return Long.parseLong(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to integer");
        }
    }

    protected long readLongAttribute(String attName, StartElement element, long defaultValue) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to integer");
        }
    }

    protected double readDoubleAttribute(String attName, StartElement element) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            throw new XMLStreamException("Mandatory attribute '" + attName + "' not defined");
        }
        try {
            return Double.parseDouble(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to double float number");
        }
    }

    protected double readDoubleAttribute(String attName, StartElement element, double defaultValue) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(v);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Cannot parse '" + v + "' to double floating point number");
        }
    }

    protected boolean readBooleanAttribute(String attName, StartElement element, boolean defaultValue) throws XMLStreamException {
        String v = this.readAttribute(attName, element, null);
        if (v == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(v) || "1".equals(v)) {
            return true;
        }
        if ("false".equalsIgnoreCase(v) || "0".equals(v)) {
            return false;
        }
        throw new XMLStreamException("Cannot parse '" + v + "' to boolean");
    }

    protected boolean isEndElementWithName(String localName) {
        return this.xmlEvent.getEventType() == 2 && this.xmlEvent.asEndElement().getName().getLocalPart().equals(localName);
    }

    @Override
    public void close() throws XMLStreamException, IOException {
        this.xmlEventReader.close();
        this.in.close();
    }
}

