/*
 * Decompiled with CFR 0.152.
 */
package org.yamcs.xtce.xml;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteOrder;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yamcs.xtce.ANDedConditions;
import org.yamcs.xtce.AbsoluteTimeArgumentType;
import org.yamcs.xtce.AbsoluteTimeDataType;
import org.yamcs.xtce.AbsoluteTimeParameterType;
import org.yamcs.xtce.AggregateArgumentType;
import org.yamcs.xtce.AggregateParameterType;
import org.yamcs.xtce.AlarmLevels;
import org.yamcs.xtce.AlarmRanges;
import org.yamcs.xtce.AlarmType;
import org.yamcs.xtce.Algorithm;
import org.yamcs.xtce.AncillaryData;
import org.yamcs.xtce.Argument;
import org.yamcs.xtce.ArgumentAssignment;
import org.yamcs.xtce.ArgumentEntry;
import org.yamcs.xtce.ArgumentInstanceRef;
import org.yamcs.xtce.ArgumentType;
import org.yamcs.xtce.ArrayArgumentType;
import org.yamcs.xtce.ArrayParameterEntry;
import org.yamcs.xtce.ArrayParameterType;
import org.yamcs.xtce.BaseDataType;
import org.yamcs.xtce.BinaryArgumentType;
import org.yamcs.xtce.BinaryDataEncoding;
import org.yamcs.xtce.BinaryParameterType;
import org.yamcs.xtce.BooleanArgumentType;
import org.yamcs.xtce.BooleanExpression;
import org.yamcs.xtce.BooleanParameterType;
import org.yamcs.xtce.Calibrator;
import org.yamcs.xtce.CheckWindow;
import org.yamcs.xtce.CommandContainer;
import org.yamcs.xtce.CommandVerifier;
import org.yamcs.xtce.Comparison;
import org.yamcs.xtce.ComparisonList;
import org.yamcs.xtce.Condition;
import org.yamcs.xtce.Container;
import org.yamcs.xtce.ContainerEntry;
import org.yamcs.xtce.ContextCalibrator;
import org.yamcs.xtce.CustomAlgorithm;
import org.yamcs.xtce.DataEncoding;
import org.yamcs.xtce.DataSource;
import org.yamcs.xtce.DynamicIntegerValue;
import org.yamcs.xtce.EnumeratedArgumentType;
import org.yamcs.xtce.EnumeratedDataType;
import org.yamcs.xtce.EnumeratedParameterType;
import org.yamcs.xtce.EnumerationAlarm;
import org.yamcs.xtce.EnumerationContextAlarm;
import org.yamcs.xtce.FixedIntegerValue;
import org.yamcs.xtce.FixedValueEntry;
import org.yamcs.xtce.FloatArgumentType;
import org.yamcs.xtce.FloatDataEncoding;
import org.yamcs.xtce.FloatParameterType;
import org.yamcs.xtce.FloatValidRange;
import org.yamcs.xtce.FloatingPointNotationType;
import org.yamcs.xtce.Header;
import org.yamcs.xtce.InputParameter;
import org.yamcs.xtce.IntegerArgumentType;
import org.yamcs.xtce.IntegerDataEncoding;
import org.yamcs.xtce.IntegerParameterType;
import org.yamcs.xtce.IntegerRange;
import org.yamcs.xtce.IntegerValidRange;
import org.yamcs.xtce.IntegerValue;
import org.yamcs.xtce.LinearAdjusment;
import org.yamcs.xtce.MatchCriteria;
import org.yamcs.xtce.MathAlgorithm;
import org.yamcs.xtce.MathOperation;
import org.yamcs.xtce.MathOperationCalibrator;
import org.yamcs.xtce.MathOperator;
import org.yamcs.xtce.Member;
import org.yamcs.xtce.MetaCommand;
import org.yamcs.xtce.NameDescription;
import org.yamcs.xtce.NumberFormatType;
import org.yamcs.xtce.NumericAlarm;
import org.yamcs.xtce.NumericContextAlarm;
import org.yamcs.xtce.NumericParameterType;
import org.yamcs.xtce.ORedConditions;
import org.yamcs.xtce.OnParameterUpdateTrigger;
import org.yamcs.xtce.OnPeriodicRateTrigger;
import org.yamcs.xtce.OperatorType;
import org.yamcs.xtce.OutputParameter;
import org.yamcs.xtce.Parameter;
import org.yamcs.xtce.ParameterEntry;
import org.yamcs.xtce.ParameterInstanceRef;
import org.yamcs.xtce.ParameterOrArgumentRef;
import org.yamcs.xtce.ParameterType;
import org.yamcs.xtce.ParameterValueChange;
import org.yamcs.xtce.PolynomialCalibrator;
import org.yamcs.xtce.RadixType;
import org.yamcs.xtce.RateInStream;
import org.yamcs.xtce.ReferenceTime;
import org.yamcs.xtce.Repeat;
import org.yamcs.xtce.SequenceContainer;
import org.yamcs.xtce.SequenceEntry;
import org.yamcs.xtce.Significance;
import org.yamcs.xtce.SpaceSystem;
import org.yamcs.xtce.SplineCalibrator;
import org.yamcs.xtce.SplinePoint;
import org.yamcs.xtce.StringArgumentType;
import org.yamcs.xtce.StringDataEncoding;
import org.yamcs.xtce.StringParameterType;
import org.yamcs.xtce.SystemParameter;
import org.yamcs.xtce.TimeEpoch;
import org.yamcs.xtce.TransmissionConstraint;
import org.yamcs.xtce.TriggerSetType;
import org.yamcs.xtce.TriggeredMathOperation;
import org.yamcs.xtce.UnitType;
import org.yamcs.xtce.ValueEnumeration;
import org.yamcs.xtce.ValueEnumerationRange;
import org.yamcs.xtce.util.AggregateTypeUtil;
import org.yamcs.xtce.util.ArgumentReference;
import org.yamcs.xtce.util.DoubleRange;
import org.yamcs.xtce.util.HexUtils;
import org.yamcs.xtce.util.IncompleteType;
import org.yamcs.xtce.util.NameReference;
import org.yamcs.xtce.util.ParameterReference;
import org.yamcs.xtce.util.ReferenceFinder;
import org.yamcs.xtce.xml.AbstractStaxReader;
import org.yamcs.xtce.xml.XtceAliasSet;
import org.yamcs.xtce.xml.XtceLoadException;
import org.yamcs.xtce.xml.XtceNotImplemented;
import org.yamcs.xtce.xml.XtceParameterProperties;
import org.yamcs.xtce.xml.XtceTerm;

public class XtceStaxReader
extends AbstractStaxReader {
    private static final String YAMCS_IGNORE = "_yamcs_ignore";
    public static final DynamicIntegerValue IGNORED_DYNAMIC_VALUE = new DynamicIntegerValue(new ParameterInstanceRef(new Parameter("_yamcs_ignore")));
    private static Logger log = LoggerFactory.getLogger(XtceStaxReader.class);
    private Map<String, Integer> xtceSkipStatistics = new HashMap<String, Integer>();
    private Set<String> excludedContainers = new HashSet<String>();

    public XtceStaxReader(String fileName) throws IOException, XMLStreamException {
        super(fileName);
    }

    public SpaceSystem readXmlDocument() throws XMLStreamException, IOException, XtceLoadException {
        SpaceSystem spaceSystem;
        block10: {
            log.info("Parsing XTCE file {}", (Object)this.fileName);
            this.xmlEvent = null;
            spaceSystem = null;
            while (true) {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                int eventType = this.xmlEvent.getEventType();
                if (eventType == 5) continue;
                if (eventType == 7) {
                    this.onStartDocument((StartDocument)this.xmlEvent);
                } else if (eventType == 1) {
                    spaceSystem = this.readSpaceSystem();
                } else {
                    if (eventType == 8) break block10;
                    if (this.isStartElementWithName("SpaceSystem")) {
                        SpaceSystem ss = this.readSpaceSystem();
                        spaceSystem.addSpaceSystem(ss);
                    } else if (eventType == 3) {
                        log.debug("Skipping processing instruction: {} ", (Object)this.xmlEvent);
                    } else {
                        log.error("Unhandled event: {} ", (Object)this.xmlEvent);
                    }
                }
                if (this.xmlEventReader.peek() == null) break;
            }
            this.xmlEvent = null;
            throw new IllegalStateException("XML file parsing error");
        }
        this.onEndDocument();
        log.info("XTCE file parsing finished, loaded: {} parameters, {} tm containers, {} commands", new Object[]{spaceSystem.getParameterCount(true), spaceSystem.getSequenceContainerCount(true), spaceSystem.getMetaCommandCount(true)});
        ReferenceFinder refFinder = new ReferenceFinder(s -> log.warn(s));
        while (XtceStaxReader.resolveReferences(spaceSystem, spaceSystem, refFinder) > 0) {
        }
        return spaceSystem;
    }

    private static int resolveReferences(SpaceSystem topSs, SpaceSystem ss, ReferenceFinder refFinder) {
        List<NameReference> refs = ss.getUnresolvedReferences();
        if (refs == null) {
            refs = Collections.emptyList();
        }
        int n = refs.isEmpty() ? -1 : 0;
        Iterator<NameReference> it = refs.iterator();
        while (it.hasNext()) {
            NameReference nr = it.next();
            if (nr.getReference().charAt(0) == NameDescription.PATH_SEPARATOR) continue;
            ReferenceFinder.FoundReference rr = refFinder.findReference(topSs, nr, ss);
            if (rr == null) {
                rr = refFinder.findAliasReference(topSs, nr, ss);
            }
            if (rr == null || !rr.isComplete()) continue;
            rr.resolved(nr);
            ++n;
            it.remove();
        }
        for (SpaceSystem ss1 : ss.getSubSystems()) {
            int m = XtceStaxReader.resolveReferences(topSs, ss1, refFinder);
            if (n == -1) {
                n = m;
                continue;
            }
            if (m <= 0) continue;
            n += m;
        }
        return n;
    }

    private void onStartDocument(StartDocument start) {
        log.trace("XML version='{} encoding: '{}'", (Object)start.getVersion(), (Object)start.getCharacterEncodingScheme());
    }

    private SpaceSystem readSpaceSystem() throws XMLStreamException {
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String value = this.readMandatoryAttribute("name", startElement);
        SpaceSystem spaceSystem = new SpaceSystem(value);
        spaceSystem.setShortDescription(this.readAttribute("shortDescription", startElement, null));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("Header")) {
                this.readHeader(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("TelemetryMetaData")) {
                this.readTelemetryMetaData(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("CommandMetaData")) {
                this.readCommandMetaData(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("SpaceSystem")) {
                SpaceSystem ss = this.readSpaceSystem();
                spaceSystem.addSpaceSystem(ss);
                continue;
            }
            if (this.isEndElementWithName("SpaceSystem")) break;
            this.logUnknown();
        }
        return spaceSystem;
    }

    private void onEndDocument() {
        log.trace("End of XML document");
    }

    private XtceAliasSet readAliasSet() throws XMLStreamException {
        log.trace("AliasSet");
        this.checkStartElementPreconditions();
        XtceAliasSet xtceAliasSet = new XtceAliasSet();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Alias")) {
                this.readAlias(xtceAliasSet);
                continue;
            }
            if (this.isEndElementWithName("AliasSet")) {
                return xtceAliasSet;
            }
            this.logUnknown();
        }
    }

    private void readAlias(XtceAliasSet aliasSet) throws XMLStreamException {
        log.trace("Alias");
        this.checkStartElementPreconditions();
        String nameSpace = this.readMandatoryAttribute("nameSpace", this.xmlEvent.asStartElement());
        nameSpace = nameSpace.intern();
        String alias = this.readMandatoryAttribute("alias", this.xmlEvent.asStartElement());
        aliasSet.addAlias(nameSpace, alias);
        this.xmlEvent = this.xmlEventReader.nextEvent();
        if (!this.isEndElementWithName("Alias")) {
            throw new XMLStreamException("Alias end element expected");
        }
    }

    private List<AncillaryData> readAncillaryDataSet() throws XMLStreamException {
        log.trace("AncillaryDataSet");
        this.checkStartElementPreconditions();
        ArrayList<AncillaryData> ancillaryData = new ArrayList<AncillaryData>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("AncillaryData")) {
                this.readAncillaryData(ancillaryData);
                continue;
            }
            if (this.isEndElementWithName("AncillaryDataSet")) {
                return ancillaryData;
            }
            this.logUnknown();
        }
    }

    private void readAncillaryData(List<AncillaryData> ancillaryData) throws XMLStreamException {
        log.trace("AncillaryData");
        StartElement element = this.checkStartElementPreconditions();
        String name = this.readMandatoryAttribute("name", element);
        String mimeType = this.readAttribute("mimeType", element, null);
        String href = this.readAttribute("href", element, null);
        String text = null;
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (!this.xmlEvent.isCharacters()) continue;
            text = this.xmlEvent.asCharacters().getData().trim();
            break;
        } while (!this.isEndElementWithName("AncillaryData"));
        AncillaryData ad = new AncillaryData(name, text);
        if (mimeType != null) {
            ad.setMimeType(mimeType);
        }
        if (href != null) {
            ad.setHref(URI.create(href));
        }
        ancillaryData.add(ad);
    }

    private void readHeader(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("Header");
        this.checkStartElementPreconditions();
        Header h = new Header();
        String value = this.readAttribute("version", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            h.setVersion(value);
        }
        if ((value = this.readAttribute("date", this.xmlEvent.asStartElement(), null)) != null) {
            h.setDate(value);
        }
        spaceSystem.setHeader(h);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("AuthorSet")) {
                this.skipXtceSection("AuthorSet");
                continue;
            }
            if (this.isStartElementWithName("NoteSet")) {
                this.skipXtceSection("NoteSet");
                continue;
            }
            if (this.isStartElementWithName("HistorySet")) {
                this.skipXtceSection("HistorySet");
                continue;
            }
            if (this.isEndElementWithName("Header")) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readTelemetryMetaData(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("TelemetryMetaData");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ParameterTypeSet")) {
                this.readParameterTypeSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("ParameterSet")) {
                this.readParameterSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("ContainerSet")) {
                this.readContainerSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("MessageSet")) {
                this.readMessageSet();
                continue;
            }
            if (this.isStartElementWithName("StreamSet")) {
                this.readStreamSet();
                continue;
            }
            if (this.isStartElementWithName("AlgorithmSet")) {
                this.readAlgorithmSet(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName("TelemetryMetaData")) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readParameterTypeSet(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("ParameterTypeSet");
        this.checkStartElementPreconditions();
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            IncompleteType incompleteType = null;
            if (this.isStartElementWithName("BooleanParameterType")) {
                incompleteType = this.readBooleanParameterType(spaceSystem);
            } else if (this.isStartElementWithName("EnumeratedParameterType")) {
                incompleteType = this.readEnumeratedParameterType(spaceSystem);
            } else if (this.isStartElementWithName("FloatParameterType")) {
                incompleteType = this.readFloatParameterType(spaceSystem);
            } else if (this.isStartElementWithName("IntegerParameterType")) {
                incompleteType = this.readIntegerParameterType(spaceSystem);
            } else if (this.isStartElementWithName("BinaryParameterType")) {
                incompleteType = this.readBinaryParameterType(spaceSystem);
            } else if (this.isStartElementWithName("StringParameterType")) {
                incompleteType = this.readStringParameterType(spaceSystem);
            } else if (this.isStartElementWithName("RelativeTimeParameterType")) {
                incompleteType = this.readRelativeTimeParameterType();
            } else if (this.isStartElementWithName("AbsoluteTimeParameterType")) {
                incompleteType = this.readAbsoluteTimeParameterType(spaceSystem);
            } else if (this.isStartElementWithName("ArrayParameterType")) {
                incompleteType = this.readArrayParameterType(spaceSystem);
            } else if (this.isStartElementWithName("AggregateParameterType")) {
                incompleteType = this.readAggregateParameterType(spaceSystem);
            } else {
                this.logUnknown();
            }
            if (incompleteType == null) continue;
            incompleteType.scheduleCompletion();
        } while (!this.isEndElementWithName("ParameterTypeSet"));
    }

    private IncompleteType readBooleanParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("BooleanParameterType");
        StartElement element = this.checkStartElementPreconditions();
        BooleanParameterType.Builder typeBuilder = new BooleanParameterType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readParameterBaseTypeAttributes(spaceSystem, element, incompleteType);
        typeBuilder.setOneStringValue(this.readAttribute("oneStringValue", element, null));
        typeBuilder.setZeroStringValue(this.readAttribute("zeroStringValue", element, null));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                typeBuilder.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                typeBuilder.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                typeBuilder.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("BooleanParameterType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readAggregateParameterType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("AggregateParameterType");
        this.checkStartElementPreconditions();
        String name = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        AggregateParameterType.Builder typeBuilder = (AggregateParameterType.Builder)new AggregateParameterType.Builder().setName(name);
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(typeBuilder);
                continue;
            }
            if (this.isStartElementWithName("MemberList")) {
                typeBuilder.addMembers(this.readMemberList(spaceSystem, true));
                continue;
            }
            if (this.isEndElementWithName("AggregateParameterType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private List<Member> readMemberList(SpaceSystem spaceSystem, boolean paramOrAggreg) throws XMLStreamException {
        log.trace("MemberList");
        this.checkStartElementPreconditions();
        ArrayList<Member> l = new ArrayList<Member>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Member")) {
                l.add(this.readXtceMember(spaceSystem, paramOrAggreg));
                continue;
            }
            if (this.isEndElementWithName("MemberList")) break;
        }
        return l;
    }

    private Member readXtceMember(SpaceSystem spaceSystem, boolean paramOrAggreg) throws XMLStreamException {
        log.trace("Member");
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        String name = this.readMandatoryAttribute("name", element);
        Member member = new Member(name);
        member.setShortDescription(this.readAttribute("shortDescription", element, null));
        String typeRef = this.readMandatoryAttribute("typeRef", element);
        String initialValue = this.readAttribute("initialValue", element, null);
        if (paramOrAggreg) {
            NameReference nr = new NameReference(typeRef, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> {
                member.setDataType((ParameterType)((Object)nd));
                if (initialValue != null) {
                    member.setInitialValue(initialValue);
                }
            });
            spaceSystem.addUnresolvedReference(nr);
        } else {
            NameReference nr = new NameReference(typeRef, NameReference.Type.ARGUMENT_TYPE).addResolvedAction(nd -> {
                member.setDataType((ArgumentType)((Object)nd));
                if (initialValue != null) {
                    member.setInitialValue(initialValue);
                }
            });
            spaceSystem.addUnresolvedReference(nr);
        }
        return member;
    }

    private IncompleteType readArrayParameterType(SpaceSystem spaceSystem) throws XMLStreamException {
        int dim;
        log.trace("ArrayParameterType");
        StartElement element = this.checkStartElementPreconditions();
        String name = this.readMandatoryAttribute("name", element);
        ArrayParameterType.Builder typeBuilder = (ArrayParameterType.Builder)new ArrayParameterType.Builder().setName(name);
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        if (this.hasAttribute("numberOfDimensions", element)) {
            dim = this.readIntAttribute("numberOfDimensions", element);
            typeBuilder.setNumberOfDimensions(dim);
        } else {
            dim = -1;
        }
        String refName = this.readMandatoryAttribute("arrayTypeRef", this.xmlEvent.asStartElement());
        NameReference nr = new NameReference(refName, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> typeBuilder.setElementType((ParameterType)((Object)nd)));
        incompleteType.addReference(nr);
        spaceSystem.addUnresolvedReference(nr);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(typeBuilder);
                continue;
            }
            if (this.isStartElementWithName("DimensionList")) {
                List<IntegerValue> dimList = this.readDimensionList(spaceSystem);
                dim = dimList.size();
                typeBuilder.setSize(dimList);
                continue;
            }
            if (this.isEndElementWithName("ArrayParameterType")) {
                if (dim == -1) {
                    throw new XMLStreamException("Neither numberOfDimensions (XTCE 1.1) attribute nor DimensionList (XTCE 1.2) element defined for the ArrayParameter " + name);
                }
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private void readParameterBaseTypeAttributes(SpaceSystem spaceSystem, StartElement element, IncompleteType incompleteType) throws XMLStreamException {
        BaseDataType.Builder typeBuilder = (BaseDataType.Builder)incompleteType.getTypeBuilder();
        String name = this.readMandatoryAttribute("name", element);
        typeBuilder.setName(name);
        typeBuilder.setShortDescription(this.readAttribute("shortDescription", element, null));
        String baseType = this.readAttribute("baseType", element, null);
        if (baseType != null) {
            NameReference nr = new NameReference(baseType, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> {
                ParameterType ptype = (ParameterType)((Object)nd);
                if (!(ptype instanceof BaseDataType)) {
                    this.throwException(element.getLocation(), "cannot use " + ptype.getName() + " as a baseType");
                }
                typeBuilder.setBaseType((BaseDataType)((Object)ptype));
            });
            incompleteType.addReference(nr);
            spaceSystem.addUnresolvedReference(nr);
        }
    }

    private void readArgumentBaseTypeAttributes(SpaceSystem spaceSystem, StartElement element, IncompleteType incompleteType) throws XMLStreamException {
        BaseDataType.Builder typeBuilder = (BaseDataType.Builder)incompleteType.getTypeBuilder();
        String name = this.readMandatoryAttribute("name", element);
        typeBuilder.setName(name);
        typeBuilder.setShortDescription(this.readAttribute("shortDescription", element, null));
        String baseType = this.readAttribute("baseType", element, null);
        if (baseType != null) {
            NameReference nr = new NameReference(baseType, NameReference.Type.ARGUMENT_TYPE).addResolvedAction(nd -> {
                ArgumentType ptype = (ArgumentType)((Object)nd);
                if (!(ptype instanceof BaseDataType)) {
                    this.throwException(element.getLocation(), "cannot use " + ptype.getName() + " as a baseType");
                }
                typeBuilder.setBaseType((BaseDataType)((Object)ptype));
            });
            incompleteType.addReference(nr);
            spaceSystem.addUnresolvedReference(nr);
        }
    }

    private boolean readBaseTypeProperties(BaseDataType.Builder<?> typeBuilder) throws XMLStreamException {
        if (this.isNamedItemProperty()) {
            this.readNamedItemProperty(typeBuilder);
        } else if (this.isStartElementWithName("UnitSet")) {
            typeBuilder.addAllUnits(this.readUnitSet());
            return true;
        }
        return false;
    }

    private IncompleteType readAbsoluteTimeParameterType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("AbsoluteTimeParameterType");
        StartElement element = this.checkStartElementPreconditions();
        AbsoluteTimeParameterType.Builder typeBuilder = new AbsoluteTimeParameterType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readParameterBaseTypeAttributes(spaceSystem, element, incompleteType);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("ReferenceTime")) {
                typeBuilder.setReferenceTime(this.readReferenceTime(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("Encoding")) {
                this.readEncoding(spaceSystem, typeBuilder);
                continue;
            }
            if (this.isEndElementWithName("AbsoluteTimeParameterType")) {
                if (typeBuilder.getReferenceTime() == null) {
                    throw new XMLStreamException("AbsoluteTimeParameterType without a reference time not supported", this.xmlEvent.getLocation());
                }
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readRelativeTimeParameterType() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection("RelativeTimeParameterType");
        return null;
    }

    private ReferenceTime readReferenceTime(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("ReferenceTime");
        this.checkStartElementPreconditions();
        ReferenceTime referenceTime = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("OffsetFrom")) {
                referenceTime = new ReferenceTime(this.readParameterInstanceRef(spaceSystem, null));
                continue;
            }
            if (this.isStartElementWithName("Epoch")) {
                referenceTime = new ReferenceTime(this.readEpoch());
                continue;
            }
            if (this.isEndElementWithName("ReferenceTime")) {
                return referenceTime;
            }
            this.logUnknown();
        }
    }

    private TimeEpoch readEpoch() throws XMLStreamException {
        log.trace("Epoch");
        String s = this.readStringBetweenTags("Epoch");
        try {
            return new TimeEpoch(TimeEpoch.CommonEpochs.valueOf(s));
        }
        catch (IllegalArgumentException e) {
            try {
                return new TimeEpoch(s);
            }
            catch (DateTimeParseException e1) {
                e1.printStackTrace();
                throw new XMLStreamException(e.getMessage(), this.xmlEvent.getLocation());
            }
        }
    }

    private void readEncoding(SpaceSystem spaceSystem, AbsoluteTimeDataType.Builder<?> ptype) throws XMLStreamException {
        String scales;
        log.trace("Encoding");
        this.checkStartElementPreconditions();
        String units = this.readAttribute("units", this.xmlEvent.asStartElement(), null);
        if (units != null && !"seconds".equals(units)) {
            throw new XMLStreamException("Unsupported unit types '" + units + "' for time encoding. Only seconds (with scaling) supported", this.xmlEvent.getLocation());
        }
        boolean needsScaling = false;
        double offset = 0.0;
        double scale = 1.0;
        String offsets = this.readAttribute("offset", this.xmlEvent.asStartElement(), null);
        if (offsets != null) {
            needsScaling = true;
            offset = this.parseDouble(offsets);
        }
        if ((scales = this.readAttribute("scale", this.xmlEvent.asStartElement(), null)) != null) {
            needsScaling = true;
            scale = this.parseDouble(scales);
        }
        if (needsScaling) {
            ptype.setScaling(offset, scale);
        }
        DataEncoding.Builder dataEncoding = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                dataEncoding = this.readIntegerDataEncoding(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                dataEncoding = this.readFloatDataEncoding(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName("Encoding")) {
                ptype.setEncoding(dataEncoding);
                return;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readFloatParameterType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("FloatParameterType");
        StartElement element = this.checkStartElementPreconditions();
        FloatParameterType.Builder typeBuilder = new FloatParameterType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readParameterBaseTypeAttributes(spaceSystem, element, incompleteType);
        String value = this.readAttribute("sizeInBits", element, null);
        if (value != null) {
            int sizeInBits = Integer.parseInt(value);
            if (sizeInBits != 32 && sizeInBits != 64) {
                throw new XMLStreamException("Float encoding " + sizeInBits + " not supported; Only 32 and 64 bits are supported", this.xmlEvent.getLocation());
            }
            typeBuilder.setSizeInBits(sizeInBits);
        }
        if ((value = this.readAttribute("initialValue", element, null)) != null) {
            typeBuilder.setInitialValue(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                typeBuilder.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                typeBuilder.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                throw new XMLStreamException("Cannot use a binary data encoding for float parameter type");
            }
            if (this.isStartElementWithName("DefaultAlarm")) {
                typeBuilder.setDefaultAlarm(this.readDefaultAlarm());
                continue;
            }
            if (this.isStartElementWithName("ContextAlarmList")) {
                typeBuilder.setContextAlarmList(this.readNumericContextAlarmList(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("ValidRange")) {
                typeBuilder.setValidRange(this.readFloatValidRange());
                continue;
            }
            if (this.isStartElementWithName("ToString")) {
                typeBuilder.setNumberFormat(this.readToString());
                continue;
            }
            if (this.isEndElementWithName("FloatParameterType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private FloatDataEncoding.Builder readFloatDataEncoding(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("FloatDataEncoding");
        StartElement element = this.checkStartElementPreconditions();
        FloatDataEncoding.Builder floatDataEncoding = null;
        Integer sizeInBits = null;
        if (this.hasAttribute("sizeInBits", element)) {
            sizeInBits = this.readIntAttribute("sizeInBits", element);
        }
        ByteOrder byteOrder = this.readByteOrder();
        String value = this.readAttribute("encoding", element, null);
        FloatDataEncoding.Encoding enc = null;
        if (value != null && !"IEEE754_1985".equalsIgnoreCase(value)) {
            if ("MILSTD_1750A".equalsIgnoreCase(value)) {
                enc = FloatDataEncoding.Encoding.MILSTD_1750A;
            } else {
                this.throwException("Unknown encoding '" + value + "'");
            }
        }
        floatDataEncoding = ((FloatDataEncoding.Builder)((FloatDataEncoding.Builder)new FloatDataEncoding.Builder().setSizeInBits(sizeInBits)).setByteOrder(byteOrder)).setFloatEncoding(enc);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("DefaultCalibrator")) {
                floatDataEncoding.setDefaultCalibrator(this.readCalibrator(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("ContextCalibratorList")) {
                floatDataEncoding.setContextCalibratorList((List)this.readContextCalibratorList(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("FloatDataEncoding")) {
                return floatDataEncoding;
            }
            this.logUnknown();
        }
    }

    private List<NumericContextAlarm> readNumericContextAlarmList(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("ContextAlarmList");
        ArrayList<NumericContextAlarm> contextAlarmList = new ArrayList<NumericContextAlarm>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ContextAlarm")) {
                contextAlarmList.add(this.readNumericContextAlarm(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("ContextAlarmList")) break;
        }
        return contextAlarmList;
    }

    private NumericAlarm readDefaultAlarm() throws XMLStreamException {
        NumericAlarm na = new NumericAlarm();
        this.readAlarmAttributes(na);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName("DefaultAlarm")) {
                return na;
            }
            if (this.xmlEvent.getEventType() != 1) continue;
            this.readNumericAlarmElement(na);
        }
    }

    private NumericContextAlarm readNumericContextAlarm(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("ContextAlarm");
        NumericContextAlarm nca = new NumericContextAlarm();
        this.readAlarmAttributes(nca);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ContextMatch")) {
                nca.setContextMatch(this.readMatchCriteria(spaceSystem, null));
                continue;
            }
            if (this.xmlEvent.getEventType() == 1) {
                this.readNumericAlarmElement(nca);
                continue;
            }
            if (this.isEndElementWithName("ContextAlarm")) {
                return nca;
            }
            this.logUnknown();
        }
    }

    private void readNumericAlarmElement(NumericAlarm numericAlarm) throws XMLStreamException {
        if (this.isStartElementWithName("StaticAlarmRanges")) {
            numericAlarm.setStaticAlarmRanges(this.readAlarmRanges());
        }
    }

    private AlarmRanges readAlarmRanges() throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        AlarmRanges ar = new AlarmRanges();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("WatchRange")) {
                ar.addWatchRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("WarningRange")) {
                ar.addWarningRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("DistressRange")) {
                ar.addDistressRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("CriticalRange")) {
                ar.addCriticalRange(this.readFloatRange());
                continue;
            }
            if (this.isStartElementWithName("SevereRange")) {
                ar.addSevereRange(this.readFloatRange());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return ar;
    }

    private DoubleRange readFloatRange() throws XMLStreamException {
        StartElement element = this.xmlEvent.asStartElement();
        double minExclusive = this.readDoubleAttribute("minExclusive", element, Double.NaN);
        double maxExclusive = this.readDoubleAttribute("maxExclusive", element, Double.NaN);
        double minInclusive = this.readDoubleAttribute("minInclusive", element, Double.NaN);
        double maxInclusive = this.readDoubleAttribute("maxInclusive", element, Double.NaN);
        return DoubleRange.fromXtceComplement(minExclusive, maxExclusive, minInclusive, maxInclusive);
    }

    private FloatValidRange readFloatValidRange() throws XMLStreamException {
        StartElement element = this.xmlEvent.asStartElement();
        FloatValidRange fvr = new FloatValidRange(this.readFloatRange());
        boolean calib = this.readBooleanAttribute("validRangeAppliesToCalibrated", element, true);
        fvr.setValidRangeAppliesToCalibrated(calib);
        return fvr;
    }

    private IntegerRange readIntegerRange(boolean signed) throws XMLStreamException {
        StartElement element = this.xmlEvent.asStartElement();
        long minInclusive = this.readLongAttribute("minInclusive", element, signed ? Long.MIN_VALUE : 0L);
        long maxInclusive = this.readLongAttribute("maxInclusive", element, Long.MAX_VALUE);
        return new IntegerRange(minInclusive, maxInclusive);
    }

    private IntegerValidRange readIntegerValidRange(boolean signed) throws XMLStreamException {
        StartElement element = this.xmlEvent.asStartElement();
        IntegerValidRange ivr = new IntegerValidRange(this.readIntegerRange(signed));
        boolean calib = this.readBooleanAttribute("validRangeAppliesToCalibrated", element, true);
        ivr.setValidRangeAppliesToCalibrated(calib);
        return ivr;
    }

    private IntegerValidRange readIntegerValidRangeSet(boolean signed) throws XMLStreamException {
        log.trace("ValidRangeSet");
        StartElement element = this.xmlEvent.asStartElement();
        boolean calib = this.readBooleanAttribute("validRangeAppliesToCalibrated", element, true);
        IntegerValidRange ivr = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ValidRange")) {
                if (ivr != null) {
                    throw new XMLStreamException("Only one ValidRange supported. ", this.xmlEvent.getLocation());
                }
                ivr = this.readIntegerValidRange(signed);
                continue;
            }
            if (this.isEndElementWithName("ValidRangeSet")) break;
        }
        if (ivr == null) {
            throw new XMLStreamException("No ValidRange supecified ", this.xmlEvent.getLocation());
        }
        ivr.setValidRangeAppliesToCalibrated(calib);
        return ivr;
    }

    private FloatValidRange readFloatValidRangeSet() throws XMLStreamException {
        log.trace("ValidRangeSet");
        StartElement element = this.xmlEvent.asStartElement();
        boolean calib = this.readBooleanAttribute("validRangeAppliesToCalibrated", element, true);
        FloatValidRange fvr = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ValidRange")) {
                if (fvr != null) {
                    throw new XMLStreamException("Only one ValidRange supported. ", this.xmlEvent.getLocation());
                }
                fvr = this.readFloatValidRange();
                continue;
            }
            if (this.isEndElementWithName("ValidRangeSet")) break;
        }
        if (fvr == null) {
            throw new XMLStreamException("No ValidRange specified ", this.xmlEvent.getLocation());
        }
        fvr.setValidRangeAppliesToCalibrated(calib);
        return fvr;
    }

    private NumberFormatType readToString() throws XMLStreamException {
        log.trace("ToString");
        NumberFormatType numberFormat = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("NumberFormat")) {
                if (numberFormat != null) {
                    throw new XMLStreamException("Only one NumberFormat supported", this.xmlEvent.getLocation());
                }
                numberFormat = this.readNumberFormat();
                continue;
            }
            if (this.isEndElementWithName("ToString")) break;
        }
        if (numberFormat == null) {
            throw new XMLStreamException("No NumberFormat specified", this.xmlEvent.getLocation());
        }
        return numberFormat;
    }

    private NumberFormatType readNumberFormat() throws XMLStreamException {
        String negativeSuffix;
        log.trace("NumberFormat");
        StartElement element = this.xmlEvent.asStartElement();
        NumberFormatType format = new NumberFormatType();
        String numberBase = this.readAttribute("numberBase", element, "Decimal");
        format.setNumberBase(RadixType.valueOf(numberBase.toUpperCase()));
        int minimumFractionDigits = this.readIntAttribute("minimumFractionDigits", element, 0);
        format.setMinimumFractionDigits(minimumFractionDigits);
        String value = this.readAttribute("maximumFractionDigits", element, null);
        if (value != null) {
            format.setMaximumFractionDigits(Integer.parseInt(value));
        }
        int minimumIntegerDigits = this.readIntAttribute("minimumIntegerDigits", element, 1);
        format.setMinimumIntegerDigits(minimumIntegerDigits);
        value = this.readAttribute("maximumIntegerDigits", element, null);
        if (value != null) {
            format.setMaximumIntegerDigits(Integer.parseInt(value));
        }
        format.setNegativeSuffix((negativeSuffix = this.readAttribute("negativeSuffix", element, "")).isEmpty() ? null : negativeSuffix);
        String positiveSuffix = this.readAttribute("positiveSuffix", element, "");
        format.setPositiveSuffix(positiveSuffix.isEmpty() ? null : positiveSuffix);
        String negativePrefix = this.readAttribute("negativePrefix", element, "-");
        format.setNegativePrefix(negativePrefix.isEmpty() ? null : negativePrefix);
        String positivePrefix = this.readAttribute("positivePrefix", element, "");
        format.setPositivePrefix(positivePrefix.isEmpty() ? null : positivePrefix);
        boolean showThousandsGrouping = this.readBooleanAttribute("showThousandsGrouping", element, false);
        format.setShowThousandsGrouping(showThousandsGrouping);
        String notation = this.readAttribute("notation", element, "normal");
        format.setNotation(FloatingPointNotationType.valueOf(notation.toUpperCase()));
        return format;
    }

    private void readAlarmAttributes(AlarmType alarm) {
        String value = this.readAttribute("minViolations", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            int minViolations = Integer.parseInt(value);
            alarm.setMinViolations(minViolations);
        }
    }

    private IncompleteType readBinaryParameterType(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("BinaryParameterType");
        StartElement element = this.checkStartElementPreconditions();
        BinaryParameterType.Builder typeBuilder = new BinaryParameterType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readParameterBaseTypeAttributes(spaceSystem, element, incompleteType);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(typeBuilder);
                continue;
            }
            if (this.isStartElementWithName("UnitSet")) {
                typeBuilder.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                typeBuilder.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                typeBuilder.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                throw new XMLStreamException("Encoding " + this.xmlEvent.asStartElement().getName().getLocalPart() + " not supported for binary parameter", this.xmlEvent.getLocation());
            }
            if (this.isEndElementWithName("BinaryParameterType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private BinaryDataEncoding.Builder readBinaryDataEncoding(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("BinaryDataEncoding");
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        BinaryDataEncoding.Builder binaryDataEncoding = new BinaryDataEncoding.Builder();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("SizeInBits")) {
                IntegerValue v = this.readIntegerValue(spaceSystem);
                if (v instanceof FixedIntegerValue) {
                    binaryDataEncoding.setSizeInBits((int)((FixedIntegerValue)v).getValue());
                    continue;
                }
                if (v instanceof DynamicIntegerValue) {
                    if (v == IGNORED_DYNAMIC_VALUE) continue;
                    binaryDataEncoding.setDynamicSize((DynamicIntegerValue)v);
                    binaryDataEncoding.setType(BinaryDataEncoding.Type.DYNAMIC);
                    continue;
                }
                this.throwException("Only FixedIntegerValue supported for sizeInBits");
                continue;
            }
            if (this.isStartElementWithName("FromBinaryTransformAlgorithm")) {
                binaryDataEncoding.setFromBinaryTransformAlgorithm(this.readCustomAlgorithm(spaceSystem, null));
                continue;
            }
            if (this.isStartElementWithName("ToBinaryTransformAlgorithm")) {
                binaryDataEncoding.setToBinaryTransformAlgorithm(this.readCustomAlgorithm(spaceSystem, null));
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return binaryDataEncoding;
    }

    private void throwException(String msg) throws XMLStreamException {
        throw new XMLStreamException(msg, this.xmlEvent.getLocation());
    }

    private int readIntegerValue() throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        int sizeInBits = 0;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                sizeInBits = this.getIntegerCharacter();
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return sizeInBits;
    }

    int getIntegerCharacter() throws XMLStreamException {
        if (this.xmlEvent.isCharacters()) {
            String value = this.xmlEvent.asCharacters().getData();
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new XMLStreamException("Cannot parse integer '" + value + "'", this.xmlEvent.getLocation());
            }
        }
        throw new IllegalStateException();
    }

    private IncompleteType readStringParameterType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("IntegerParameterType");
        StartElement element = this.checkStartElementPreconditions();
        StringParameterType.Builder typeBuilder = new StringParameterType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readParameterBaseTypeAttributes(spaceSystem, element, incompleteType);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("UnitSet")) {
                typeBuilder.addAllUnits(this.readUnitSet());
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                typeBuilder.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("ContextAlarmList")) {
                this.skipXtceSection("ContextAlarmList");
                continue;
            }
            if (this.isStartElementWithName("IntegerDataEncoding") || this.isStartElementWithName("FloatDataEncoding")) {
                throw new XMLStreamException("Encoding " + this.xmlEvent.asStartElement().getName().getLocalPart() + " not supported for string parameter", this.xmlEvent.getLocation());
            }
            if (this.isEndElementWithName("StringParameterType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private StringDataEncoding.Builder readStringDataEncoding(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StringDataEncoding.Builder stringDataEncoding = new StringDataEncoding.Builder();
        String encoding = this.readAttribute("encoding", this.xmlEvent.asStartElement(), null);
        if (encoding != null) {
            stringDataEncoding.setEncoding(encoding);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("SizeInBits")) {
                this.readStringSizeInBits(spaceSystem, stringDataEncoding);
                continue;
            }
            if (this.isStartElementWithName("Variable")) {
                this.readVariableStringSize(spaceSystem, stringDataEncoding);
                continue;
            }
            if (this.isEndElementWithName("StringDataEncoding")) break;
        }
        if (stringDataEncoding.getSizeType() == null) {
            throw new XMLStreamException("SizeInBits or Variable not specified for the StringDataEncoding", this.xmlEvent.getLocation());
        }
        return stringDataEncoding;
    }

    private void readStringSizeInBits(SpaceSystem spaceSystem, StringDataEncoding.Builder stringDataEncoding) throws XMLStreamException {
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Fixed")) {
                IntegerValue v = this.readIntegerValue(spaceSystem);
                if (v instanceof FixedIntegerValue) {
                    stringDataEncoding.setSizeType(StringDataEncoding.SizeType.FIXED);
                    stringDataEncoding.setSizeInBits((int)((FixedIntegerValue)v).getValue());
                    continue;
                }
                this.throwException("Only FixedValue supported for string size in bits");
                continue;
            }
            if (this.isStartElementWithName("TerminationChar")) {
                stringDataEncoding.setSizeType(StringDataEncoding.SizeType.TERMINATION_CHAR);
                byte[] x = this.readHexBinary();
                if (x == null || x.length != 1) {
                    this.throwException("Terminated strings have to have the size of the termination character of 1");
                }
                stringDataEncoding.setTerminationChar(x[0]);
                continue;
            }
            if (this.isStartElementWithName("LeadingSize")) {
                stringDataEncoding.setSizeType(StringDataEncoding.SizeType.LEADING_SIZE);
                int sizeInBits = this.readIntAttribute("sizeInBitsOfSizeTag", this.xmlEvent.asStartElement(), 16);
                stringDataEncoding.setSizeInBitsOfSizeTag(sizeInBits);
                continue;
            }
            if (this.isEndElementWithName("SizeInBits")) break;
        }
    }

    private void readVariableStringSize(SpaceSystem spaceSystem, StringDataEncoding.Builder stringDataEncoding) throws XMLStreamException {
        this.checkStartElementPreconditions();
        int maxSizeInBits = this.readIntAttribute("maxSizeInBits", this.xmlEvent.asStartElement());
        stringDataEncoding.setMaxSizeInBits(maxSizeInBits);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("DynamicValue")) {
                DynamicIntegerValue div = this.readDynamicValue(spaceSystem);
                if (div == IGNORED_DYNAMIC_VALUE) continue;
                stringDataEncoding.setSizeType(StringDataEncoding.SizeType.FIXED);
                stringDataEncoding.setDynamicBufferSize(div);
                continue;
            }
            if (this.isStartElementWithName("TerminationChar")) {
                stringDataEncoding.setSizeType(StringDataEncoding.SizeType.TERMINATION_CHAR);
                byte[] x = this.readHexBinary();
                if (x == null || x.length != 1) {
                    this.throwException("Terminated strings have to have the size of the termination character of 1");
                }
                stringDataEncoding.setTerminationChar(x[0]);
                continue;
            }
            if (this.isStartElementWithName("LeadingSize")) {
                stringDataEncoding.setSizeType(StringDataEncoding.SizeType.LEADING_SIZE);
                int sizeInBits = this.readIntAttribute("sizeInBitsOfSizeTag", this.xmlEvent.asStartElement(), 16);
                stringDataEncoding.setSizeInBitsOfSizeTag(sizeInBits);
                continue;
            }
            if (this.isEndElementWithName("Variable")) break;
        }
    }

    private byte[] readHexBinary() throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        byte[] b = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                b = HexUtils.unhex(this.xmlEvent.asCharacters().getData());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return b;
    }

    private IncompleteType readIntegerParameterType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("IntegerParameterType");
        StartElement element = this.checkStartElementPreconditions();
        IntegerParameterType.Builder typeBuilder = new IntegerParameterType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readParameterBaseTypeAttributes(spaceSystem, element, incompleteType);
        int sizeInBits = this.readIntAttribute("sizeInBits", element, 32);
        typeBuilder.setSizeInBits(sizeInBits);
        String value = this.readAttribute("signed", element, null);
        if (value != null) {
            boolean signed = Boolean.parseBoolean(value);
            typeBuilder.setSigned(signed);
        }
        if ((value = this.readAttribute("initialValue", element, null)) != null) {
            typeBuilder.setInitialValue(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                typeBuilder.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                typeBuilder.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                throw new XMLStreamException("Cannot use a binary data encoding for integer parameters");
            }
            if (this.isStartElementWithName("DefaultAlarm")) {
                typeBuilder.setDefaultAlarm(this.readDefaultAlarm());
                continue;
            }
            if (this.isStartElementWithName("ContextAlarmList")) {
                typeBuilder.setNumericContextAlarmList(this.readNumericContextAlarmList(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("ValidRange")) {
                typeBuilder.setValidRange(this.readIntegerValidRange(typeBuilder.isSigned()));
                continue;
            }
            if (this.isStartElementWithName("ToString")) {
                typeBuilder.setNumberFormat(this.readToString());
                continue;
            }
            if (this.isEndElementWithName("IntegerParameterType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IntegerDataEncoding.Builder readIntegerDataEncoding(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("IntegerDataEncoding");
        StartElement element = this.checkStartElementPreconditions();
        IntegerDataEncoding.Builder integerDataEncoding = null;
        Integer sizeInBits = null;
        if (this.hasAttribute("sizeInBits", element) && ((sizeInBits = Integer.valueOf(this.readIntAttribute("sizeInBits", element))) < 0 || sizeInBits > 64)) {
            throw new XMLStreamException("Invalid sizeInBits " + sizeInBits + " specified for integer data encoding. Supported are between 0 and 64.", this.xmlEvent.getLocation());
        }
        ByteOrder byteOrder = this.readByteOrder();
        integerDataEncoding = ((IntegerDataEncoding.Builder)new IntegerDataEncoding.Builder().setSizeInBits(sizeInBits)).setByteOrder(byteOrder);
        String value = this.readAttribute("encoding", element, null);
        if (value != null) {
            if ("unsigned".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.UNSIGNED);
            } else if ("signMagnitude".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.SIGN_MAGNITUDE);
            } else if ("twosComplement".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.TWOS_COMPLEMENT);
            } else if ("twosCompliment".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.TWOS_COMPLEMENT);
            } else if ("onesComplement".equalsIgnoreCase(value)) {
                integerDataEncoding.setEncoding(IntegerDataEncoding.Encoding.ONES_COMPLEMENT);
            } else {
                this.throwException("Unsupported encoding '" + value + "'");
            }
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("DefaultCalibrator")) {
                integerDataEncoding.setDefaultCalibrator(this.readCalibrator(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("ContextCalibratorList")) {
                integerDataEncoding.setContextCalibratorList((List)this.readContextCalibratorList(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("IntegerDataEncoding")) {
                return integerDataEncoding;
            }
            this.logUnknown();
        }
    }

    private ByteOrder readByteOrder() throws XMLStreamException {
        String byteOrderStr = this.readAttribute("byteOrder", this.xmlEvent.asStartElement(), null);
        if (byteOrderStr == null) {
            return null;
        }
        ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
        if ("mostSignificantByteFirst".equals(byteOrderStr)) {
            byteOrder = ByteOrder.BIG_ENDIAN;
        } else if ("leastSignificantByteFirst".equals(byteOrderStr)) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        } else {
            throw new XMLStreamException("Unsupported byteOrder '" + byteOrderStr + "' specified for integer data encoding. Supported are mostSignificantByteFirst or leastSignificantByteFirst.", this.xmlEvent.getLocation());
        }
        return byteOrder;
    }

    private List<ContextCalibrator> readContextCalibratorList(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("ContextCalibratorList");
        this.checkStartElementPreconditions();
        ArrayList<ContextCalibrator> clist = new ArrayList<ContextCalibrator>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ContextCalibrator")) {
                clist.add(this.readContextCalibrator(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("ContextCalibratorList")) {
                return clist;
            }
            this.logUnknown();
        }
    }

    private Calibrator readCalibrator(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("DefaultCalibrator");
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        Calibrator calibrator = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("PolynomialCalibrator")) {
                calibrator = this.readPolynomialCalibrator();
                continue;
            }
            if (this.isStartElementWithName("MathOperationCalibrator")) {
                calibrator = (Calibrator)((Object)this.readMathOperation(spaceSystem, null));
                continue;
            }
            if (this.isStartElementWithName("SplineCalibrator")) {
                calibrator = this.readSplineCalibrator();
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return calibrator;
    }

    private MathOperation readMathOperation(SpaceSystem spaceSystem, MathAlgorithm algo) throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        ArrayList<MathOperation.Element> list = new ArrayList<MathOperation.Element>();
        String refName = null;
        if (algo != null) {
            refName = this.readMandatoryAttribute("outputParameterRef", this.xmlEvent.asStartElement());
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ValueOperand")) {
                list.add(new MathOperation.Element(this.readDouble()));
                continue;
            }
            if (this.isStartElementWithName("ThisParameterOperand")) {
                if (algo != null) {
                    throw new XMLStreamException("Cannot reference 'ThisParameter' in algorithms.", this.xmlEvent.getLocation());
                }
                this.skipToTheEnd("ThisParameterOperand");
                list.add(new MathOperation.Element());
                continue;
            }
            if (this.isStartElementWithName("ParameterInstanceRefOperand")) {
                if (algo == null) {
                    throw new XMLStreamException("Cannot reference other paramters in calibrations. Use 'ThisParameterOperand' to refer to the parameter to be calibrated ", this.xmlEvent.getLocation());
                }
                ParameterInstanceRef pref = this.readParameterInstanceRef(spaceSystem, null);
                algo.addInput(new InputParameter(pref));
                list.add(new MathOperation.Element(pref));
                continue;
            }
            if (this.isStartElementWithName("Operator")) {
                list.add(new MathOperation.Element(this.readMathOperator()));
                continue;
            }
            if (this.isStartElementWithName("TriggerSet")) {
                if (algo == null) {
                    throw new XMLStreamException("Cannot specify a trigger set for a calibration");
                }
                algo.setTriggerSet(this.readTriggerSet(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        if (algo != null) {
            TriggeredMathOperation trigMathOp = new TriggeredMathOperation(list);
            NameReference nr = new NameReference(refName, NameReference.Type.PARAMETER).addResolvedAction(nd -> algo.addOutput(new OutputParameter((Parameter)nd)));
            spaceSystem.addUnresolvedReference(nr);
            algo.setMathOperation(trigMathOp);
            return trigMathOp;
        }
        return new MathOperationCalibrator(list);
    }

    private TriggerSetType readTriggerSet(SpaceSystem spaceSystem) throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        TriggerSetType triggerSet = new TriggerSetType();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("OnParameterUpdateTrigger")) {
                triggerSet.addOnParameterUpdateTrigger(this.readOnParameterUpdateTrigger(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("OnContainerUpdateTrigger")) {
                throw new XMLStreamException("OnContainerUpdateTrigger not implemented", this.xmlEvent.getLocation());
            }
            if (this.isStartElementWithName("OnPeriodicRateTrigger")) {
                triggerSet.addOnPeriodicRateTrigger(this.readOnPeriodicRateTrigger(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return triggerSet;
    }

    private OnParameterUpdateTrigger readOnParameterUpdateTrigger(SpaceSystem spaceSystem) throws XMLStreamException {
        String refName = null;
        refName = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        OnParameterUpdateTrigger trigger = new OnParameterUpdateTrigger();
        NameReference nr = new NameReference(refName, NameReference.Type.PARAMETER).addResolvedAction(nd -> trigger.setParameter((Parameter)nd));
        spaceSystem.addUnresolvedReference(nr);
        return trigger;
    }

    private OnPeriodicRateTrigger readOnPeriodicRateTrigger(SpaceSystem spaceSystem) throws XMLStreamException {
        double d = this.readDoubleAttribute("fireRateInSeconds", this.xmlEvent.asStartElement());
        OnPeriodicRateTrigger trigger = new OnPeriodicRateTrigger((long)(1000.0 * d));
        return trigger;
    }

    private double parseDouble(String value) throws XMLStreamException {
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            throw new XMLStreamException("Cannot parse double value '" + value + "'", this.xmlEvent.getLocation());
        }
    }

    private MathOperator readMathOperator() throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        MathOperator m = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                m = MathOperator.fromXtceName(this.xmlEvent.asCharacters().getData());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return m;
    }

    private ContextCalibrator readContextCalibrator(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("ContextCalibrator");
        this.checkStartElementPreconditions();
        MatchCriteria context = null;
        Calibrator calibrator = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ContextMatch")) {
                context = this.readMatchCriteria(spaceSystem, null);
                continue;
            }
            if (this.isStartElementWithName("Calibrator")) {
                calibrator = this.readCalibrator(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName("ContextCalibrator")) break;
        }
        if (context == null) {
            throw new XMLStreamException("Invalid context calibrator, no context specified");
        }
        if (calibrator == null) {
            throw new XMLStreamException("Invalid context calibrator, no calibrator specified", this.xmlEvent.getLocation());
        }
        return new ContextCalibrator(context, calibrator);
    }

    private Calibrator readSplineCalibrator() throws XMLStreamException {
        log.trace("SplineCalibrator");
        this.checkStartElementPreconditions();
        ArrayList<SplinePoint> splinePoints = new ArrayList<SplinePoint>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("SplinePoint")) {
                splinePoints.add(this.readSplinePoint());
                continue;
            }
            if (this.isEndElementWithName("SplineCalibrator")) break;
        }
        return new SplineCalibrator(splinePoints);
    }

    private SplinePoint readSplinePoint() throws XMLStreamException {
        log.trace("SplinePoint");
        this.checkStartElementPreconditions();
        double raw = this.readDoubleAttribute("raw", this.xmlEvent.asStartElement());
        double calibrated = this.readDoubleAttribute("calibrated", this.xmlEvent.asStartElement());
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName("SplinePoint")) {
                return new SplinePoint(raw, calibrated);
            }
            this.logUnknown();
        }
    }

    private Calibrator readPolynomialCalibrator() throws XMLStreamException {
        log.trace("PolynomialCalibrator");
        this.checkStartElementPreconditions();
        int maxExponent = 0;
        HashMap<Integer, Double> polynome = new HashMap<Integer, Double>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Term")) {
                XtceTerm term = this.readTerm();
                if (term.getExponent() > maxExponent) {
                    maxExponent = term.getExponent();
                }
                polynome.put(term.getExponent(), term.getCoefficient());
                continue;
            }
            if (this.isEndElementWithName("PolynomialCalibrator")) {
                double[] coefficients = new double[maxExponent + 1];
                for (Map.Entry entry : polynome.entrySet()) {
                    coefficients[((Integer)entry.getKey()).intValue()] = (Double)entry.getValue();
                }
                return new PolynomialCalibrator(coefficients);
            }
            this.logUnknown();
        }
    }

    private XtceTerm readTerm() throws XMLStreamException {
        log.trace("Term");
        this.checkStartElementPreconditions();
        int exponent = this.readIntAttribute("exponent", this.xmlEvent.asStartElement());
        double coefficient = this.readDoubleAttribute("coefficient", this.xmlEvent.asStartElement());
        do {
            this.xmlEvent = this.xmlEventReader.nextEvent();
        } while (!this.isEndElementWithName("Term"));
        return new XtceTerm(exponent, coefficient);
    }

    private List<UnitType> readUnitSet() throws IllegalStateException, XMLStreamException {
        log.trace("UnitSet");
        ArrayList<UnitType> units = new ArrayList<UnitType>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Unit")) {
                UnitType u = this.readUnit();
                if (u == null) continue;
                units.add(u);
                continue;
            }
            if (this.isEndElementWithName("UnitSet")) {
                return units;
            }
            this.logUnknown();
        }
    }

    private Double readDouble() throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        Double d = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                d = this.parseDouble(this.xmlEvent.asCharacters().getData());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return d;
    }

    private UnitType readUnit() throws XMLStreamException {
        String descriptionValue;
        String factorValue;
        double powerValue;
        block3: {
            log.trace("Unit");
            this.checkStartElementPreconditions();
            StartElement element = this.xmlEvent.asStartElement();
            powerValue = this.readDoubleAttribute("power", element, 1.0);
            factorValue = this.readAttribute("factor", element, null);
            descriptionValue = this.readAttribute("description", element, null);
            do {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.xmlEvent.isCharacters()) break block3;
            } while (!this.isEndElementWithName("Unit"));
            return null;
        }
        String unit = this.xmlEvent.asCharacters().getData();
        UnitType unitType = new UnitType(unit);
        unitType.setPower(powerValue);
        if (factorValue != null) {
            unitType.setFactor(factorValue);
        }
        if (descriptionValue != null) {
            unitType.setDescription(descriptionValue);
        }
        return unitType;
    }

    private IncompleteType readEnumeratedParameterType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("EnumeratedParameterType");
        StartElement element = this.checkStartElementPreconditions();
        EnumeratedParameterType.Builder typeBuilder = new EnumeratedParameterType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readParameterBaseTypeAttributes(spaceSystem, element, incompleteType);
        String value = this.readAttribute("initialValue", element, null);
        if (value != null) {
            typeBuilder.setInitialValue(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                typeBuilder.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                typeBuilder.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                typeBuilder.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("EnumerationList")) {
                this.readEnumerationList(typeBuilder);
                continue;
            }
            if (this.isStartElementWithName("DefaultAlarm")) {
                typeBuilder.setDefaultAlarm(this.readEnumerationAlarm(typeBuilder));
                continue;
            }
            if (this.isStartElementWithName("ContextAlarmList")) {
                typeBuilder.setContextAlarmList(this.readEnumerationContextAlarmList(spaceSystem, typeBuilder));
                continue;
            }
            if (this.isEndElementWithName("EnumeratedParameterType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private List<EnumerationContextAlarm> readEnumerationContextAlarmList(SpaceSystem spaceSystem, EnumeratedDataType.Builder<?> enumParamType) throws XMLStreamException {
        log.trace("ContextAlarmList");
        ArrayList<EnumerationContextAlarm> contextAlarmList = new ArrayList<EnumerationContextAlarm>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ContextAlarm")) {
                contextAlarmList.add(this.readEnumerationContextAlarm(spaceSystem, enumParamType));
                continue;
            }
            if (this.isEndElementWithName("ContextAlarmList")) {
                return contextAlarmList;
            }
            this.logUnknown();
        }
    }

    private EnumerationContextAlarm readEnumerationContextAlarm(SpaceSystem spaceSystem, EnumeratedDataType.Builder<?> enumParamType) throws XMLStreamException {
        log.trace("ContextAlarm");
        EnumerationContextAlarm eca = new EnumerationContextAlarm();
        this.readAlarmAttributes(eca);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ContextMatch")) {
                eca.setContextMatch(this.readMatchCriteria(spaceSystem, null));
                continue;
            }
            if (this.xmlEvent.getEventType() == 1) {
                EnumerationAlarm a = this.readEnumerationAlarm(enumParamType);
                eca.setAlarmList(a.getAlarmList());
                continue;
            }
            if (this.isEndElementWithName("ContextAlarm")) {
                return eca;
            }
            this.logUnknown();
        }
    }

    private void readEnumerationList(EnumeratedDataType.Builder<?> enumDataType) throws XMLStreamException {
        log.trace("EnumerationList");
        this.checkStartElementPreconditions();
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (initialValue != null) {
            enumDataType.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Enumeration")) {
                this.readEnumeration(enumDataType);
                continue;
            }
            if (this.isStartElementWithName("RangeEnumeration")) {
                enumDataType.addEnumerationRange(this.readRangeEnumeration());
                continue;
            }
            if (this.isEndElementWithName("EnumerationList")) {
                return;
            }
            this.logUnknown();
        }
    }

    private EnumerationAlarm readEnumerationAlarm(EnumeratedDataType.Builder<?> enumParamType) throws XMLStreamException {
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        EnumerationAlarm alarm = new EnumerationAlarm();
        alarm.setMinViolations(this.readIntAttribute("minViolations", this.xmlEvent.asStartElement(), 1));
        AlarmLevels defaultAlarmLevel = AlarmLevels.NORMAL;
        String defaultAlarmLevelString = this.readAttribute("defaultAlarmLevel", this.xmlEvent.asStartElement(), null);
        if (defaultAlarmLevelString != null) {
            defaultAlarmLevel = this.getAlarmLevel(defaultAlarmLevelString);
        }
        alarm.setDefaultAlarmLevel(defaultAlarmLevel);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("EnumerationAlarm")) {
                String label = this.readAttribute("enumerationLabel", this.xmlEvent.asStartElement(), null);
                if (label == null) {
                    label = this.readAttribute("enumerationValue", this.xmlEvent.asStartElement(), null);
                }
                if (label == null) {
                    throw new XMLStreamException(this.fileName + ": error in definition of " + enumParamType.getName() + "EnumerationAlarm: no enumerationLabel specified", this.xmlEvent.getLocation());
                }
                if (!enumParamType.hasLabel(label)) {
                    throw new XMLStreamException("Reference to invalid enumeration label '" + label + "'");
                }
                AlarmLevels level = this.getAlarmLevel(this.readMandatoryAttribute("alarmLevel", this.xmlEvent.asStartElement()));
                alarm.addAlarm(label, level);
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return alarm;
    }

    private AlarmLevels getAlarmLevel(String level) throws XMLStreamException {
        try {
            return AlarmLevels.fromXtce(level);
        }
        catch (IllegalArgumentException e) {
            String s = Arrays.stream(AlarmLevels.values()).map(al -> al.xtceName).collect(Collectors.joining(", ", "[", "]"));
            throw new XMLStreamException("Invalid alarm level '" + level + "'; use one of: " + s);
        }
    }

    private ValueEnumerationRange readRangeEnumeration() throws XMLStreamException {
        log.trace("RangeEnumeration");
        this.checkStartElementPreconditions();
        boolean isMinInclusive = true;
        boolean isMaxInclusive = true;
        double min = 0.0;
        double max = 0.0;
        String value = this.readAttribute("maxInclusive", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            max = this.parseDouble(value);
            isMaxInclusive = true;
        }
        if ((value = this.readAttribute("minInclusive", this.xmlEvent.asStartElement(), null)) != null) {
            isMinInclusive = true;
            min = this.parseDouble(value);
        }
        if ((value = this.readAttribute("maxExclusive", this.xmlEvent.asStartElement(), null)) != null) {
            max = this.parseDouble(value);
            isMaxInclusive = false;
        }
        if ((value = this.readAttribute("minExclusive", this.xmlEvent.asStartElement(), null)) != null) {
            isMinInclusive = false;
            min = this.parseDouble(value);
        }
        if ((value = this.readAttribute("label", this.xmlEvent.asStartElement(), null)) == null) {
            log.error("Attribute label is missing.");
            value = "UNDEF";
        }
        ValueEnumerationRange range = new ValueEnumerationRange(min, max, isMinInclusive, isMaxInclusive, value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName("RangeEnumeration")) {
                return range;
            }
            this.logUnknown();
        }
    }

    private void readEnumeration(EnumeratedDataType.Builder<?> enumDataType) throws XMLStreamException {
        log.trace("Enumeration");
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        long longValue = this.readLongAttribute("value", element);
        String label = this.readMandatoryAttribute("label", element);
        String description = this.readAttribute("shortDescription", element, null);
        String maxValue = this.readAttribute("maxValue", element, null);
        if (maxValue != null) {
            double mvd = Double.parseDouble(maxValue);
            ValueEnumerationRange ver = new ValueEnumerationRange(longValue, mvd, true, true, label);
            ver.setDescription(description);
            enumDataType.addEnumerationRange(ver);
        } else {
            ValueEnumeration ve = new ValueEnumeration(longValue, label);
            ve.setDescription(description);
            enumDataType.addEnumerationValue(ve);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName("Enumeration")) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readParameterSet(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("ParameterSet");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Parameter")) {
                this.readParameter(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("ParameterRef")) {
                this.skipXtceSection("ParameterRef");
                continue;
            }
            if (this.isEndElementWithName("ParameterSet")) {
                return;
            }
            this.logUnknown();
        }
    }

    private Parameter readParameter(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("Parameter");
        this.checkStartElementPreconditions();
        Parameter parameter = null;
        StartElement element = this.xmlEvent.asStartElement();
        String value = this.readMandatoryAttribute("name", element);
        parameter = new Parameter(value);
        parameter.setPersistent(true);
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        value = this.readMandatoryAttribute("parameterTypeRef", element);
        ParameterType ptype = spaceSystem.getParameterType(value);
        if (ptype != null) {
            parameter.setParameterType(ptype);
            if (initialValue != null) {
                parameter.setInitialValue(ptype.convertType(initialValue));
            }
        } else {
            Parameter p = parameter;
            NameReference nr = new NameReference(value, NameReference.Type.PARAMETER_TYPE).addResolvedAction(nd -> {
                ParameterType ptype1 = (ParameterType)((Object)nd);
                p.setParameterType(ptype1);
                if (initialValue != null) {
                    p.setInitialValue(ptype1.convertType(initialValue));
                }
            });
            spaceSystem.addUnresolvedReference(nr);
        }
        parameter.setShortDescription(this.readAttribute("shortDescription", element, null));
        spaceSystem.addParameter(parameter);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(parameter);
                continue;
            }
            if (this.isStartElementWithName("ParameterProperties")) {
                this.readParameterProperties(spaceSystem, parameter);
                continue;
            }
            if (this.isEndElementWithName("Parameter")) {
                return parameter;
            }
            this.logUnknown();
        }
    }

    private XtceParameterProperties readParameterProperties(SpaceSystem spaceSystem, Parameter p) throws XMLStreamException {
        log.trace("ParameterProperties");
        this.checkStartElementPreconditions();
        String v = this.readAttribute("dataSource", this.xmlEvent.asStartElement(), null);
        if (v != null) {
            try {
                p.setDataSource(DataSource.valueOf(v.toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                throw new XMLStreamException("invalid dataSource '" + v + "'. Valid values: " + Stream.of(DataSource.values()).map(ds -> ds.name().toLowerCase()).collect(Collectors.joining(", ")));
            }
        }
        boolean persistence = this.readBooleanAttribute("persistence", this.xmlEvent.asStartElement(), true);
        p.setPersistent(persistence);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ValidityCondition")) {
                this.readMatchCriteria(spaceSystem, null);
                continue;
            }
            if (this.isStartElementWithName("PhysicalAddressSet")) {
                this.skipXtceSection("PhysicalAddressSet");
                continue;
            }
            if (this.isStartElementWithName("SystemName")) {
                this.skipXtceSection("SystemName");
                continue;
            }
            if (this.isStartElementWithName("TimeAssociation")) {
                this.skipXtceSection("TimeAssociation");
                continue;
            }
            if (this.isEndElementWithName("ParameterProperties")) {
                return null;
            }
            this.logUnknown();
        }
    }

    private RateInStream readRateInStream(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        String basis = this.readAttribute("basis", this.xmlEvent.asStartElement(), null);
        if (basis != null && !"perSecond".equalsIgnoreCase(basis)) {
            throw new XMLStreamException("Currently unsupported rate in stream basis: " + basis);
        }
        long minInterval = -1L;
        long maxInterval = -1L;
        String v = this.readAttribute("minimumValue", this.xmlEvent.asStartElement(), null);
        if (v != null) {
            maxInterval = (long)(1000.0 / this.parseDouble(v));
        }
        if ((v = this.readAttribute("maximumValue", this.xmlEvent.asStartElement(), null)) != null) {
            minInterval = (long)(1000.0 / this.parseDouble(v));
        }
        RateInStream ris = new RateInStream(minInterval, maxInterval);
        this.xmlEvent = this.xmlEventReader.nextEvent();
        if (!this.isEndElementWithName("DefaultRateInStream")) {
            throw new IllegalStateException("DefaultRateInStream end element expected");
        }
        return ris;
    }

    private MatchCriteria readMatchCriteria(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        log.trace("MatchCriteria");
        this.checkStartElementPreconditions();
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        MatchCriteria criteria = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Comparison")) {
                criteria = this.readComparison(spaceSystem, metaCmd);
                continue;
            }
            if (this.isStartElementWithName("ComparisonList")) {
                criteria = this.readComparisonList(spaceSystem, metaCmd);
                continue;
            }
            if (this.isStartElementWithName("BooleanExpression")) {
                criteria = this.readBooleanExpression(spaceSystem, metaCmd);
                continue;
            }
            if (this.isStartElementWithName("CustomAlgorithm")) {
                this.skipXtceSection("CustomAlgorithm");
                continue;
            }
            if (this.isEndElementWithName(tag)) {
                return criteria;
            }
            this.logUnknown();
        }
    }

    private ComparisonList readComparisonList(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        log.trace("ComparisonList");
        this.checkStartElementPreconditions();
        ComparisonList list = new ComparisonList();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Comparison")) {
                list.addComparison(this.readComparison(spaceSystem, metaCmd));
                continue;
            }
            if (this.isEndElementWithName("ComparisonList")) {
                return list;
            }
            this.logUnknown();
        }
    }

    private BooleanExpression readBooleanExpression(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        log.trace("BooleanExpression");
        this.checkStartElementPreconditions();
        BooleanExpression expr = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Condition")) {
                expr = this.readCondition(spaceSystem, metaCmd);
                continue;
            }
            if (this.isStartElementWithName("ANDedConditions")) {
                expr = this.readAndCondition(spaceSystem, metaCmd);
                continue;
            }
            if (this.isStartElementWithName("ORedConditions")) {
                expr = this.readOrCondition(spaceSystem, metaCmd);
                continue;
            }
            if (this.isEndElementWithName("BooleanExpression")) {
                if (expr == null) {
                    throw new XMLStreamException("BooleanExpression has to contain one of Condition, ANDedCondition or ORedCondition", this.xmlEvent.getLocation());
                }
                return expr;
            }
            this.logUnknown();
        }
    }

    private ParameterValueChange readParameterValueChange(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("ParameterValueChange");
        this.checkStartElementPreconditions();
        ParameterValueChange pvc = new ParameterValueChange();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ParameterRef")) {
                Location xmlLocation = this.xmlEvent.getLocation();
                CompletableFuture<ParameterInstanceRef> cf = new CompletableFuture<ParameterInstanceRef>();
                pvc.setParameterRef(this.readParameterRef(spaceSystem, cf));
                cf.thenAccept(ref -> {
                    ParameterType ptype = ref.getParameter().getParameterType();
                    if (ref.getMemberPath() != null) {
                        ptype = AggregateTypeUtil.getMemberType(ptype, ref.getMemberPath());
                    }
                    if (!(ptype instanceof NumericParameterType)) {
                        this.throwException(xmlLocation, "Invalid parameter of type " + ptype + " used in ParameterValuChange verifier; expecting a numeric parameter");
                    }
                });
                continue;
            }
            if (this.isStartElementWithName("Change")) {
                double delta = this.readDoubleAttribute("value", this.xmlEvent.asStartElement());
                if (delta == 0.0) {
                    this.throwException(this.xmlEvent.getLocation(), "change value cannot be 0");
                }
                pvc.setDelta(delta);
                continue;
            }
            if (this.isEndElementWithName("ParameterValueChange")) {
                if (pvc.getParameterRef() == null) {
                    throw new XMLStreamException("ParameterValueChange has to contain a reference to a parameter", this.xmlEvent.getLocation());
                }
                if (pvc.getDelta() == 0.0) {
                    throw new XMLStreamException("ParameterValueChange has to contain a change value", this.xmlEvent.getLocation());
                }
                return pvc;
            }
            this.logUnknown();
        }
    }

    private Condition readCondition(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        log.trace("Condition");
        this.checkStartElementPreconditions();
        ArgumentInstanceRef lValueRef = null;
        ArgumentInstanceRef rValueRef = null;
        OperatorType comparisonOperator = null;
        String rvalue = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ParameterInstanceRef")) {
                ParameterOrArgumentRef ref;
                String paraRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
                ParameterOrArgumentRef parameterOrArgumentRef = ref = paraRef.startsWith("/yamcs/cmd/arg") ? this.readArgumentInstanceRef(spaceSystem, metaCmd) : this.readParameterInstanceRef(spaceSystem, null);
                if (lValueRef == null) {
                    lValueRef = ref;
                    continue;
                }
                rValueRef = ref;
                continue;
            }
            if (this.isStartElementWithName("ArgumentInstanceRef")) {
                ArgumentInstanceRef ref = this.readArgumentInstanceRef(spaceSystem, metaCmd);
                if (lValueRef == null) {
                    lValueRef = ref;
                    continue;
                }
                rValueRef = ref;
                continue;
            }
            if (this.isStartElementWithName("ComparisonOperator")) {
                comparisonOperator = this.readComparisonOperator();
                continue;
            }
            if (this.isStartElementWithName("Value")) {
                rvalue = this.readStringBetweenTags("Value");
                continue;
            }
            if (this.isEndElementWithName("Condition")) {
                Condition cond;
                if (lValueRef == null) {
                    throw new XMLStreamException("Condition without left value", this.xmlEvent.getLocation());
                }
                if (comparisonOperator == null) {
                    throw new XMLStreamException("Condition without comparison operator", this.xmlEvent.getLocation());
                }
                if (rValueRef != null) {
                    cond = new Condition(comparisonOperator, (ParameterOrArgumentRef)lValueRef, rValueRef);
                } else if (rvalue != null) {
                    cond = new Condition(comparisonOperator, (ParameterOrArgumentRef)lValueRef, rvalue);
                } else {
                    throw new XMLStreamException("Condition without right value", this.xmlEvent.getLocation());
                }
                return cond;
            }
            this.logUnknown();
        }
    }

    private ORedConditions readOrCondition(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        log.trace("ORedConditions");
        this.checkStartElementPreconditions();
        ORedConditions cond = new ORedConditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Condition")) {
                cond.addConditionExpression(this.readCondition(spaceSystem, metaCmd));
                continue;
            }
            if (this.isStartElementWithName("ANDedConditions")) {
                cond.addConditionExpression(this.readAndCondition(spaceSystem, metaCmd));
                continue;
            }
            if (this.isEndElementWithName("ORedConditions")) {
                return cond;
            }
            this.logUnknown();
        }
    }

    private ANDedConditions readAndCondition(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        log.trace("ANDedConditions");
        this.checkStartElementPreconditions();
        ANDedConditions cond = new ANDedConditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Condition")) {
                cond.addConditionExpression(this.readCondition(spaceSystem, metaCmd));
                continue;
            }
            if (this.isStartElementWithName("ORedConditions")) {
                cond.addConditionExpression(this.readOrCondition(spaceSystem, metaCmd));
                continue;
            }
            if (this.isEndElementWithName("ANDedConditions")) {
                return cond;
            }
            this.logUnknown();
        }
    }

    private OperatorType readComparisonOperator() throws XMLStreamException {
        Location loc = this.xmlEvent.getLocation();
        String s = this.readStringBetweenTags("ComparisonOperator");
        try {
            return OperatorType.fromSymbol(s);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Unknown operator '" + s + "'", loc);
        }
    }

    private void readContainerSet(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("ContainerSet");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("SequenceContainer")) {
                SequenceContainer sc = this.readSequenceContainer(spaceSystem);
                if (this.excludedContainers.contains(sc.getName())) {
                    log.debug("Not adding '" + sc.getName() + "' to the SpaceSystem because excluded by configuration");
                    continue;
                }
                spaceSystem.addSequenceContainer(sc);
                continue;
            }
            if (this.isEndElementWithName("ContainerSet")) {
                return;
            }
            this.logUnknown();
        }
    }

    private SequenceContainer readSequenceContainer(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("SequenceContainer");
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        SequenceContainer seqContainer = new SequenceContainer(value);
        seqContainer.setShortDescription(this.readAttribute("shortDescription", this.xmlEvent.asStartElement(), null));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(seqContainer);
                continue;
            }
            if (this.isStartElementWithName("EntryList")) {
                this.readEntryList(spaceSystem, seqContainer, null);
                continue;
            }
            if (this.isStartElementWithName("BaseContainer")) {
                this.readBaseContainer(spaceSystem, seqContainer);
                continue;
            }
            if (this.isStartElementWithName("DefaultRateInStream")) {
                seqContainer.setRateInStream(this.readRateInStream(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryEncoding")) {
                BinaryDataEncoding.Builder bde = this.readBinaryDataEncoding(spaceSystem);
                seqContainer.setSizeInBits(bde.getSizeInBits());
                continue;
            }
            if (this.isEndElementWithName("SequenceContainer")) {
                return seqContainer;
            }
            this.logUnknown();
        }
    }

    private void readBaseContainer(SpaceSystem spaceSystem, SequenceContainer seqContainer) throws XMLStreamException {
        log.trace("BaseContainer");
        StartElement element = this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("containerRef", element);
        if (this.excludedContainers.contains(refName)) {
            log.debug("adding " + seqContainer.getName() + " to the list of the excluded containers because its parent is excluded");
            this.excludedContainers.add(seqContainer.getName());
        } else {
            SequenceContainer baseContainer = spaceSystem.getSequenceContainer(refName);
            if (baseContainer != null) {
                seqContainer.setBaseContainer(baseContainer);
            } else {
                SequenceContainer finalsc = seqContainer;
                NameReference nr = new NameReference(refName, NameReference.Type.SEQUENCE_CONTAINER).addResolvedAction(nd -> finalsc.setBaseContainer((SequenceContainer)nd));
                spaceSystem.addUnresolvedReference(nr);
            }
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("RestrictionCriteria")) {
                MatchCriteria criteria = this.readMatchCriteria(spaceSystem, null);
                seqContainer.setRestrictionCriteria(criteria);
                continue;
            }
            if (this.isEndElementWithName("BaseContainer")) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readEntryList(SpaceSystem spaceSystem, Container container, MetaCommand mc) throws XMLStreamException {
        log.trace("EntryList");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            SequenceEntry entry = null;
            if (this.isStartElementWithName("ParameterRefEntry")) {
                entry = this.readParameterRefEntry(spaceSystem);
            } else if (this.isStartElementWithName("ParameterSegmentRefEntry")) {
                this.skipXtceSection("ParameterSegmentRefEntry");
            } else if (this.isStartElementWithName("ContainerRefEntry")) {
                entry = this.readContainerRefEntry(spaceSystem);
            } else if (this.isStartElementWithName("ContainerSegmentRefEntry")) {
                this.skipXtceSection("ContainerSegmentRefEntry");
            } else if (this.isStartElementWithName("StreamSegmentEntry")) {
                this.skipXtceSection("StreamSegmentEntry");
            } else if (this.isStartElementWithName("IndirectParameterRefEntry")) {
                this.skipXtceSection("IndirectParameterRefEntry");
            } else if (this.isStartElementWithName("ArrayParameterRefEntry")) {
                entry = this.readArrayParameterRefEntry(spaceSystem);
            } else if (this.isStartElementWithName("ArgumentRefEntry")) {
                entry = this.readArgumentRefEntry(spaceSystem, mc);
            } else if (this.isStartElementWithName("ArrayArgumentRefEntry")) {
                this.skipXtceSection("ArrayArgumentRefEntry");
            } else if (this.isStartElementWithName("FixedValueEntry")) {
                entry = this.readFixedValueEntry(spaceSystem);
            } else {
                if (this.isEndElementWithName("EntryList")) {
                    return;
                }
                this.logUnknown();
            }
            if (entry == null) continue;
            container.addEntry(entry);
        }
    }

    private SequenceEntry readArrayParameterRefEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        ArrayParameterEntry parameterEntry;
        log.trace("ArrayParameterRefEntry");
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        SequenceEntry.ReferenceLocationType locationType = SequenceEntry.ReferenceLocationType.PREVIOUS_ENTRY;
        ArrayParameterEntry finalpe = parameterEntry = new ArrayParameterEntry(0, locationType);
        XtceStaxReader.makeParameterReference(spaceSystem, refName, (param, path) -> finalpe.setParameter(param));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("LocationInContainerInBits")) {
                this.readLocationInContainerInBits(parameterEntry);
                continue;
            }
            if (this.isStartElementWithName("RepeatEntry")) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                parameterEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName("IncludeCondition")) {
                parameterEntry.setIncludeCondition(this.readMatchCriteria(spaceSystem, null));
                continue;
            }
            if (this.isStartElementWithName("DimensionList")) {
                parameterEntry.setSize(this.readDimensionList(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("ArrayParameterRefEntry")) {
                return parameterEntry;
            }
            this.logUnknown();
        }
    }

    private List<IntegerValue> readDimensionList(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("DimensionList");
        this.checkStartElementPreconditions();
        ArrayList<IntegerValue> l = new ArrayList<IntegerValue>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Dimension")) {
                l.add(this.readDimension(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("Size")) {
                l.add(this.readIntegerValue(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("DimensionList")) {
                return l;
            }
            this.logUnknown();
        }
    }

    private IntegerValue readDimension(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("Dimension");
        this.checkStartElementPreconditions();
        IntegerValue endingIndex = null;
        IntegerValue startingIndex = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("StartingIndex")) {
                startingIndex = this.readIntegerValue(spaceSystem);
                if (startingIndex instanceof FixedIntegerValue && ((FixedIntegerValue)startingIndex).getValue() == 0L) continue;
                throw new XMLStreamException("Dimension indexes must be specified with FixedValue starting from 0 (partial array entries not supported)", this.xmlEvent.getLocation());
            }
            if (this.isStartElementWithName("EndingIndex")) {
                endingIndex = this.readIntegerValue(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName("Dimension")) {
                if (endingIndex == null) {
                    throw new XMLStreamException("EndingIndex not specified");
                }
                if (endingIndex instanceof FixedIntegerValue) {
                    long v = ((FixedIntegerValue)endingIndex).getValue();
                    return new FixedIntegerValue(v + 1L);
                }
                if (!(endingIndex instanceof DynamicIntegerValue)) {
                    throw new IllegalArgumentException("Unknown type " + endingIndex.getClass());
                }
                DynamicIntegerValue div = (DynamicIntegerValue)endingIndex;
                div.setIntercept(div.getIntercept() + 1L);
                return endingIndex;
            }
            this.logUnknown();
        }
    }

    private SequenceEntry readParameterRefEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        ParameterEntry parameterEntry;
        log.trace("ParameterRefEntry");
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        SequenceEntry.ReferenceLocationType locationType = SequenceEntry.ReferenceLocationType.PREVIOUS_ENTRY;
        ParameterEntry finalpe = parameterEntry = new ParameterEntry(0, locationType);
        NameReference nr = new NameReference(refName, NameReference.Type.PARAMETER).addResolvedAction(nd -> finalpe.setParameter((Parameter)nd));
        spaceSystem.addUnresolvedReference(nr);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("LocationInContainerInBits")) {
                this.readLocationInContainerInBits(parameterEntry);
                continue;
            }
            if (this.isStartElementWithName("RepeatEntry")) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                parameterEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName("IncludeCondition")) {
                parameterEntry.setIncludeCondition(this.readMatchCriteria(spaceSystem, null));
                continue;
            }
            if (this.isEndElementWithName("ParameterRefEntry")) {
                return parameterEntry;
            }
            this.logUnknown();
        }
    }

    private ContainerEntry readContainerRefEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("ContainerRefEntry");
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("containerRef", this.xmlEvent.asStartElement());
        SequenceEntry.ReferenceLocationType locationType = SequenceEntry.ReferenceLocationType.PREVIOUS_ENTRY;
        SequenceContainer container = spaceSystem.getSequenceContainer(refName);
        ContainerEntry containerEntry = null;
        if (container != null) {
            containerEntry = new ContainerEntry(0, locationType, container);
        } else {
            ContainerEntry finalce = containerEntry = new ContainerEntry(0, locationType);
            NameReference nr = new NameReference(refName, NameReference.Type.SEQUENCE_CONTAINER).addResolvedAction(nd -> finalce.setRefContainer((SequenceContainer)nd));
            spaceSystem.addUnresolvedReference(nr);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("LocationInContainerInBits")) {
                this.readLocationInContainerInBits(containerEntry);
                continue;
            }
            if (this.isStartElementWithName("RepeatEntry")) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                containerEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName("IncludeCondition")) {
                containerEntry.setIncludeCondition(this.readMatchCriteria(spaceSystem, null));
                continue;
            }
            if (this.isEndElementWithName("ContainerRefEntry")) {
                return containerEntry;
            }
            this.logUnknown();
        }
    }

    private Repeat readRepeatEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("RepeatEntry");
        Repeat r = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Count")) {
                r = new Repeat(this.readIntegerValue(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("RepeatEntry")) break;
        }
        return r;
    }

    private IntegerValue readIntegerValue(SpaceSystem spaceSystem) throws XMLStreamException {
        String tag = this.xmlEvent.asStartElement().getName().getLocalPart();
        this.checkStartElementPreconditions();
        IntegerValue v = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("FixedValue")) {
                v = new FixedIntegerValue(this.readIntegerValue());
                continue;
            }
            if (this.isStartElementWithName("DynamicValue")) {
                v = this.readDynamicValue(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName(tag)) {
                return v;
            }
            this.logUnknown();
        }
    }

    private DynamicIntegerValue readDynamicValue(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("DynamicValue");
        this.checkStartElementPreconditions();
        DynamicIntegerValue v = null;
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ParameterInstanceRef")) {
                String paramRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
                if (YAMCS_IGNORE.equals(paramRef)) {
                    v = IGNORED_DYNAMIC_VALUE;
                    continue;
                }
                v = new DynamicIntegerValue(this.readParameterInstanceRef(spaceSystem, null));
                continue;
            }
            if (this.isStartElementWithName("ArgumentInstanceRef")) {
                v = new DynamicIntegerValue(this.readArgumentInstanceRef(spaceSystem, null));
                continue;
            }
            if (this.isStartElementWithName("LinearAdjustment")) {
                if (v == null) {
                    throw new XMLStreamException("ParameterInstanceRef or ArgumentInstanceRef has to be specified before LinearAdjustment");
                }
                LinearAdjusment ladj = this.readLinearAdjusment();
                v.setIntercept((long)ladj.getIntercept());
                v.setSlope((long)ladj.getSlope());
                continue;
            }
            if (this.isEndElementWithName("DynamicValue")) {
                if (v == null) {
                    throw new XMLStreamException("No ParameterInstanceRef section found");
                }
                return v;
            }
            this.logUnknown();
        }
    }

    private LinearAdjusment readLinearAdjusment() throws XMLStreamException {
        log.trace("LinearAdjustment");
        StartElement startElement = this.checkStartElementPreconditions();
        double intercept = this.readDoubleAttribute("intercept", startElement, 0.0);
        double slope = this.readDoubleAttribute("slope", startElement, 1.0);
        return new LinearAdjusment(intercept, slope);
    }

    private ParameterInstanceRef readParameterInstanceRef(SpaceSystem spaceSystem, CompletableFuture<ParameterInstanceRef> resolvedCf) throws XMLStreamException {
        log.trace("ParameterInstanceRef");
        StartElement startElement = this.checkStartElementPreconditions();
        String paramRef = this.readMandatoryAttribute("parameterRef", startElement);
        boolean useCalibrated = this.readBooleanAttribute("useCalibratedValue", startElement, true);
        int instance = this.readIntAttribute("instance", startElement, 0);
        ParameterInstanceRef instanceRef = new ParameterInstanceRef(useCalibrated);
        instanceRef.setInstance(instance);
        XtceStaxReader.makeParameterReference(spaceSystem, paramRef, (para, path) -> {
            instanceRef.setParameter(para);
            instanceRef.setMemberPath(path);
            if (resolvedCf != null) {
                resolvedCf.complete(instanceRef);
            }
        });
        return instanceRef;
    }

    private ArgumentInstanceRef readArgumentInstanceRef(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        StartElement startElement = this.checkStartElementPreconditions();
        String argRef = "ParameterInstanceRef".equals(startElement.getName().getLocalPart()) || "InputParameterInstanceRef".equals(startElement.getName().getLocalPart()) ? this.readMandatoryAttribute("parameterRef", startElement).substring("/yamcs/cmd/arg".length() + 1) : this.readMandatoryAttribute("argumentRef", startElement);
        boolean useCalibrated = this.readBooleanAttribute("useCalibratedValue", startElement, true);
        ArgumentInstanceRef argInstRef = new ArgumentInstanceRef();
        if (metaCmd == null) {
            argInstRef.setArgument(new Argument(argRef));
        } else {
            ArgumentReference ref = ArgumentReference.getReference(metaCmd, argRef);
            ref.addResolvedAction((arg, path) -> {
                argInstRef.setArgument(arg);
                argInstRef.setMemberPath(path);
                return true;
            });
            if (!ref.isResolved()) {
                spaceSystem.addUnresolvedReference(ref);
            }
        }
        argInstRef.setUseCalibratedValue(useCalibrated);
        return argInstRef;
    }

    private ParameterInstanceRef readParameterRef(SpaceSystem spaceSystem, CompletableFuture<ParameterInstanceRef> resolvedCf) throws XMLStreamException {
        log.trace("ParameterRef");
        String paramRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        ParameterInstanceRef instanceRef = new ParameterInstanceRef();
        XtceStaxReader.makeParameterReference(spaceSystem, paramRef, (para, path) -> {
            instanceRef.setParameter(para);
            instanceRef.setMemberPath(path);
            if (resolvedCf != null) {
                resolvedCf.complete(instanceRef);
            }
        });
        return instanceRef;
    }

    private void readLocationInContainerInBits(SequenceEntry entry) throws XMLStreamException {
        SequenceEntry.ReferenceLocationType location;
        log.trace("LocationInContainerInBits");
        this.checkStartElementPreconditions();
        int locationInContainerInBits = 0;
        String value = this.readAttribute("referenceLocation", this.xmlEvent.asStartElement(), "previousEntry");
        if (value.equalsIgnoreCase("previousEntry")) {
            location = SequenceEntry.ReferenceLocationType.PREVIOUS_ENTRY;
        } else if (value.equalsIgnoreCase("containerStart")) {
            location = SequenceEntry.ReferenceLocationType.CONTAINER_START;
        } else {
            throw new XMLStreamException("Currently unsupported reference location: " + value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("FixedValue")) {
                locationInContainerInBits = this.readIntegerValue();
                continue;
            }
            if (this.isStartElementWithName("DynamicValue")) {
                this.skipXtceSection("DynamicValue");
                continue;
            }
            if (this.isStartElementWithName("DiscreteLookupList")) {
                this.skipXtceSection("DiscreteLookupList");
                continue;
            }
            if (this.isEndElementWithName("LocationInContainerInBits")) {
                entry.setLocation(location, locationInContainerInBits);
                return;
            }
            this.logUnknown();
        }
    }

    private Comparison readComparison(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        Comparison comparison;
        log.trace("Comparison");
        this.checkStartElementPreconditions();
        String ref = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        String value = this.readAttribute("comparisonOperator", this.xmlEvent.asStartElement(), null);
        if (value == null) {
            value = "==";
        }
        OperatorType optype = OperatorType.fromSymbol(value);
        String theValue = this.readMandatoryAttribute("value", this.xmlEvent.asStartElement());
        boolean useCalibratedValue = this.readBooleanAttribute("useCalibratedValue", this.xmlEvent.asStartElement(), true);
        if (ref.startsWith("/yamcs/cmd/arg")) {
            if (metaCmd == null) {
                throw new XtceLoadException(this.fileName, this.xmlEvent.getLocation(), "Cannot use reference to command arguments in comparisons not linked to commands");
            }
            String argName = ref.substring("/yamcs/cmd/arg".length() + 1);
            Argument arg = metaCmd.getArgument(argName);
            if (arg == null) {
                throw new XtceLoadException(this.fileName, this.xmlEvent.getLocation(), "No argument named '" + argName + "' for command" + metaCmd.getName());
            }
            ArgumentInstanceRef instanceRef = new ArgumentInstanceRef(arg);
            comparison = new Comparison(instanceRef, theValue, optype);
        } else {
            ParameterInstanceRef instanceRef = new ParameterInstanceRef(useCalibratedValue);
            comparison = new Comparison(instanceRef, theValue, optype);
            XtceStaxReader.makeParameterReference(spaceSystem, ref, (p, path) -> {
                instanceRef.setParameter(p);
                instanceRef.setMemberPath(path);
                if (!(p instanceof SystemParameter)) {
                    comparison.validateValueType();
                }
            });
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName("Comparison")) {
                return comparison;
            }
            this.logUnknown();
        }
    }

    private XtceNotImplemented readMessageSet() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection("MessageSet");
        return null;
    }

    private XtceNotImplemented readStreamSet() throws IllegalStateException, XMLStreamException {
        this.skipXtceSection("StreamSet");
        return null;
    }

    private void readAlgorithmSet(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("AlgorithmSet");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            Algorithm algo = null;
            if (this.isStartElementWithName("MathAlgorithm")) {
                algo = this.readMathAlgorithm(spaceSystem);
            } else if (this.isStartElementWithName("CustomAlgorithm")) {
                algo = this.readCustomAlgorithm(spaceSystem, null);
            } else if (this.isEndElementWithName("AlgorithmSet")) {
                return;
            }
            if (algo == null) continue;
            spaceSystem.addAlgorithm(algo);
        }
    }

    private MathAlgorithm readMathAlgorithm(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        this.checkStartElementPreconditions();
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        MathAlgorithm algo = new MathAlgorithm(value);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("MathOperation")) {
                this.readMathOperation(spaceSystem, algo);
            }
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(algo);
                continue;
            }
            if (this.isEndElementWithName("MathAlgorithm")) {
                return algo;
            }
            this.logUnknown();
        }
    }

    private void readCommandMetaData(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("CommandMetaData");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ParameterTypeSet")) {
                this.readParameterTypeSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("ParameterSet")) {
                this.readParameterSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("ArgumentTypeSet")) {
                this.readArgumentTypeSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("MetaCommandSet")) {
                this.readMetaCommandSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("CommandContainerSet")) {
                this.readCommandContainerSet(spaceSystem);
                continue;
            }
            if (this.isStartElementWithName("MessageSet")) {
                this.readMessageSet();
                continue;
            }
            if (this.isStartElementWithName("AlgorithmSet")) {
                this.readAlgorithmSet(spaceSystem);
                continue;
            }
            if (this.isEndElementWithName("CommandMetaData")) {
                return;
            }
            this.logUnknown();
        }
    }

    private void readArgumentTypeSet(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("ArgumentTypeSet");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            IncompleteType incompleteType = null;
            if (this.isStartElementWithName("BooleanArgumentType")) {
                incompleteType = this.readBooleanArgumentType(spaceSystem);
            } else if (this.isStartElementWithName("EnumeratedArgumentType")) {
                incompleteType = this.readEnumeratedArgumentType(spaceSystem);
            } else if (this.isStartElementWithName("FloatArgumentType")) {
                incompleteType = this.readFloatArgumentType(spaceSystem);
            } else if (this.isStartElementWithName("IntegerArgumentType")) {
                incompleteType = this.readIntegerArgumentType(spaceSystem);
            } else if (this.isStartElementWithName("BinaryArgumentType")) {
                incompleteType = this.readBinaryArgumentType(spaceSystem);
            } else if (this.isStartElementWithName("StringArgumentType")) {
                incompleteType = this.readStringArgumentType(spaceSystem);
            } else if (this.isStartElementWithName("AggregateArgumentType")) {
                incompleteType = this.readAggregateArgumentType(spaceSystem);
            } else if (this.isStartElementWithName("AbsoluteTimeArgumentType")) {
                incompleteType = this.readAbsoluteTimeArgumentType(spaceSystem);
            } else if (this.isStartElementWithName("ArrayArgumentType")) {
                incompleteType = this.readArrayArgumentType(spaceSystem);
            } else {
                this.logUnknown();
            }
            if (incompleteType != null) {
                incompleteType.scheduleCompletion();
            }
            if (this.isEndElementWithName("ArgumentTypeSet")) {
                return;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readBooleanArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("BooleanArgumentType");
        StartElement element = this.checkStartElementPreconditions();
        BooleanArgumentType.Builder typeBuilder = new BooleanArgumentType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readArgumentBaseTypeAttributes(spaceSystem, element, incompleteType);
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (initialValue != null) {
            typeBuilder.setInitialValue(initialValue);
        }
        typeBuilder.setOneStringValue(this.readAttribute("oneStringValue", element, "True"));
        typeBuilder.setZeroStringValue(this.readAttribute("zeroStringValue", element, "False"));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                typeBuilder.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                typeBuilder.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                typeBuilder.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("BooleanArgumentType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readFloatArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        String initialValue;
        log.trace("FloatArgumentType");
        StartElement element = this.checkStartElementPreconditions();
        FloatArgumentType.Builder typeBuilder = new FloatArgumentType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readArgumentBaseTypeAttributes(spaceSystem, element, incompleteType);
        String value = this.readAttribute("sizeInBits", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            int sizeInBits = Integer.parseInt(value);
            if (sizeInBits != 32 && sizeInBits != 64) {
                throw new XMLStreamException("Float encoding " + sizeInBits + " not supported; Only 32 and 64 bits are supported", this.xmlEvent.getLocation());
            }
            typeBuilder.setSizeInBits(sizeInBits);
        }
        if ((initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null)) != null) {
            typeBuilder.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                typeBuilder.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                typeBuilder.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                throw new XMLStreamException("Encoding " + this.xmlEvent.asStartElement().getName().getLocalPart() + " not supported for float argument", this.xmlEvent.getLocation());
            }
            if (this.isStartElementWithName("ValidRange")) {
                typeBuilder.setValidRange(this.readFloatValidRange());
                continue;
            }
            if (this.isStartElementWithName("ValidRangeSet")) {
                typeBuilder.setValidRange(this.readFloatValidRangeSet());
                continue;
            }
            if (this.isStartElementWithName("ToString")) {
                typeBuilder.setNumberFormat(this.readNumberFormat());
                continue;
            }
            if (this.isEndElementWithName("FloatArgumentType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readEnumeratedArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("EnumeratedArgumentType");
        StartElement element = this.checkStartElementPreconditions();
        EnumeratedArgumentType.Builder typeBuilder = new EnumeratedArgumentType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readArgumentBaseTypeAttributes(spaceSystem, element, incompleteType);
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (initialValue != null) {
            typeBuilder.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                typeBuilder.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                typeBuilder.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                typeBuilder.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("EnumerationList")) {
                this.readEnumerationList(typeBuilder);
                continue;
            }
            if (this.isEndElementWithName("EnumeratedArgumentType")) break;
        }
        return incompleteType;
    }

    private IncompleteType readAggregateArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("AggregateArgumentType");
        StartElement element = this.checkStartElementPreconditions();
        AggregateArgumentType.Builder typeBuilder = new AggregateArgumentType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        String name = this.readMandatoryAttribute("name", element);
        typeBuilder.setName(name);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("MemberList")) {
                typeBuilder.addMembers(this.readMemberList(spaceSystem, false));
                continue;
            }
            if (this.isEndElementWithName("AggregateArgumentType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readIntegerArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        String initialValue;
        log.trace("IntegerArgumentType");
        StartElement element = this.checkStartElementPreconditions();
        IntegerArgumentType.Builder typeBuilder = new IntegerArgumentType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readArgumentBaseTypeAttributes(spaceSystem, element, incompleteType);
        int sizeInBits = this.readIntAttribute("sizeInBits", this.xmlEvent.asStartElement(), 32);
        typeBuilder.setSizeInBits(sizeInBits);
        String value = this.readAttribute("signed", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            boolean signed = Boolean.parseBoolean(value);
            typeBuilder.setSigned(signed);
        }
        if ((initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null)) != null) {
            typeBuilder.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("IntegerDataEncoding")) {
                typeBuilder.setEncoding(this.readIntegerDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("FloatDataEncoding")) {
                typeBuilder.setEncoding(this.readFloatDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                throw new XMLStreamException("Cannot use a binary data encoding for integer arguments");
            }
            if (this.isStartElementWithName("ValidRange")) {
                typeBuilder.setValidRange(this.readIntegerValidRange(typeBuilder.isSigned()));
                continue;
            }
            if (this.isStartElementWithName("ValidRangeSet")) {
                typeBuilder.setValidRange(this.readIntegerValidRangeSet(typeBuilder.isSigned()));
                continue;
            }
            if (this.isEndElementWithName("IntegerArgumentType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readBinaryArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("BinaryArgumentType");
        StartElement element = this.checkStartElementPreconditions();
        BinaryArgumentType.Builder typeBuilder = new BinaryArgumentType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readArgumentBaseTypeAttributes(spaceSystem, element, incompleteType);
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (initialValue != null) {
            typeBuilder.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                typeBuilder.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName("BinaryArgumentType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readStringArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("StringArgumentType");
        StartElement element = this.checkStartElementPreconditions();
        StringArgumentType.Builder typeBuilder = new StringArgumentType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readArgumentBaseTypeAttributes(spaceSystem, element, incompleteType);
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (initialValue != null) {
            typeBuilder.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("StringDataEncoding")) {
                typeBuilder.setEncoding(this.readStringDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryDataEncoding")) {
                typeBuilder.setEncoding(this.readBinaryDataEncoding(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("SizeRangeInCharacters")) {
                typeBuilder.setSizeRangeInCharacters(this.readIntegerRange(false));
                continue;
            }
            if (this.isStartElementWithName("ContextAlarmList")) {
                this.skipXtceSection("ContextAlarmList");
                continue;
            }
            if (this.isStartElementWithName("IntegerDataEncoding") || this.isStartElementWithName("FloatDataEncoding")) {
                throw new XMLStreamException("Encoding " + this.xmlEvent.asStartElement().getName().getLocalPart() + " not supported for string argument", this.xmlEvent.getLocation());
            }
            if (this.isEndElementWithName("StringArgumentType")) {
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readAbsoluteTimeArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("AbsoluteTimeArgumentType");
        StartElement element = this.checkStartElementPreconditions();
        AbsoluteTimeArgumentType.Builder typeBuilder = new AbsoluteTimeArgumentType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        this.readArgumentBaseTypeAttributes(spaceSystem, element, incompleteType);
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (initialValue != null) {
            typeBuilder.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readBaseTypeProperties(typeBuilder)) continue;
            if (this.isStartElementWithName("ReferenceTime")) {
                typeBuilder.setReferenceTime(this.readReferenceTime(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("Encoding")) {
                this.readEncoding(spaceSystem, typeBuilder);
                continue;
            }
            if (this.isEndElementWithName("AbsoluteTimeArgumentType")) {
                if (typeBuilder.getReferenceTime() == null) {
                    throw new XMLStreamException("AbsoluteTimeArgumentType without a reference time not supported", this.xmlEvent.getLocation());
                }
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private IncompleteType readArrayArgumentType(SpaceSystem spaceSystem) throws XMLStreamException {
        int dim;
        log.trace("ArrayArgumentType");
        StartElement element = this.checkStartElementPreconditions();
        ArrayArgumentType.Builder typeBuilder = new ArrayArgumentType.Builder();
        IncompleteType incompleteType = new IncompleteType(spaceSystem, typeBuilder);
        typeBuilder.setName(this.readMandatoryAttribute("name", element));
        typeBuilder.setShortDescription(this.readAttribute("shortDescription", element, null));
        String refName = this.readMandatoryAttribute("arrayTypeRef", this.xmlEvent.asStartElement());
        NameReference nr = new NameReference(refName, NameReference.Type.ARGUMENT_TYPE).addResolvedAction(nd -> typeBuilder.setElementType((ArgumentType)((Object)nd)));
        incompleteType.addReference(nr);
        spaceSystem.addUnresolvedReference(nr);
        if (this.hasAttribute("numberOfDimensions", element)) {
            dim = this.readIntAttribute("numberOfDimensions", element);
            typeBuilder.setNumberOfDimensions(dim);
        } else {
            dim = -1;
        }
        String initialValue = this.readAttribute("initialValue", this.xmlEvent.asStartElement(), null);
        if (initialValue != null) {
            typeBuilder.setInitialValue(initialValue);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.readNamedItemProperty(typeBuilder)) continue;
            if (this.isStartElementWithName("DimensionList")) {
                List<IntegerValue> dimList = this.readDimensionList(spaceSystem);
                dim = dimList.size();
                typeBuilder.setSize(dimList);
                continue;
            }
            if (this.isEndElementWithName("ArrayArgumentType")) {
                if (dim == -1) {
                    throw new XMLStreamException("Neither numberOfDimensions (XTCE 1.1) attribute nor DimensionList (XTCE 1.2) element defined for the ArrayParameter " + typeBuilder.getName());
                }
                return incompleteType;
            }
            this.logUnknown();
        }
    }

    private void readCommandContainerSet(SpaceSystem spaceSystem) throws XMLStreamException {
        this.skipXtceSection("CommandContainerSet");
    }

    private void readMetaCommandSet(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("MetaCommandSet");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("MetaCommand")) {
                MetaCommand mc = this.readMetaCommand(spaceSystem);
                if (this.excludedContainers.contains(mc.getName())) {
                    log.debug("Not adding '{}' to the SpaceSystem because excluded by configuration", (Object)mc.getName());
                    continue;
                }
                spaceSystem.addMetaCommand(mc);
                continue;
            }
            if (this.isEndElementWithName("MetaCommandSet")) break;
        }
    }

    private MetaCommand readMetaCommand(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("MetaCommand");
        this.checkStartElementPreconditions();
        MetaCommand mc = null;
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        mc = new MetaCommand(value);
        mc.setAbstract(this.readBooleanAttribute("abstract", this.xmlEvent.asStartElement(), false));
        value = this.readAttribute("shortDescription", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            mc.setShortDescription(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(mc);
                continue;
            }
            if (this.isStartElementWithName("BaseMetaCommand")) {
                this.readBaseMetaCommand(spaceSystem, mc);
                continue;
            }
            if (this.isStartElementWithName("CommandContainer")) {
                CommandContainer cc = this.readCommandContainer(spaceSystem, mc);
                mc.setCommandContainer(cc);
                spaceSystem.addCommandContainer(cc);
                continue;
            }
            if (this.isStartElementWithName("ArgumentList")) {
                this.readArgumentList(spaceSystem, mc);
                continue;
            }
            if (this.isStartElementWithName("VerifierSet")) {
                this.readVerifierSet(spaceSystem, mc);
                continue;
            }
            if (this.isStartElementWithName("DefaultSignificance")) {
                mc.setDefaultSignificance(this.readSignificance(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("TransmissionConstraintList")) {
                this.readTransmissionConstraintList(spaceSystem, mc);
                continue;
            }
            if (this.isEndElementWithName("MetaCommand")) {
                return mc;
            }
            this.logUnknown();
        }
    }

    private void readBaseMetaCommand(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace("BaseMetaCommand");
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("metaCommandRef", this.xmlEvent.asStartElement());
        if (refName != null) {
            if (this.excludedContainers.contains(refName)) {
                log.debug("adding {} to the list of the excluded containers because its parent is excluded", (Object)mc.getName());
                this.excludedContainers.add(mc.getName());
            } else {
                MetaCommand baseContainer = spaceSystem.getMetaCommand(refName);
                if (baseContainer != null) {
                    mc.setBaseMetaCommand(baseContainer);
                } else {
                    MetaCommand finalmc = mc;
                    NameReference nr = new NameReference(refName, NameReference.Type.META_COMMAND).addResolvedAction(nd -> finalmc.setBaseMetaCommand((MetaCommand)nd));
                    spaceSystem.addUnresolvedReference(nr);
                }
            }
            while (true) {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.isStartElementWithName("ArgumentAssignmentList")) {
                    this.readArgumentAssignmentList(spaceSystem, mc);
                    continue;
                }
                if (this.isEndElementWithName("BaseMetaCommand")) {
                    return;
                }
                this.logUnknown();
            }
        }
    }

    private void readArgumentAssignmentList(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace("ArgumentAssignmentList");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ArgumentAssignment")) {
                ArgumentAssignment aa = this.readArgumentAssignment(spaceSystem);
                mc.addArgumentAssignment(aa);
                continue;
            }
            if (this.isEndElementWithName("ArgumentAssignmentList")) break;
        }
    }

    private ArgumentAssignment readArgumentAssignment(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("ArgumentAssignment");
        this.checkStartElementPreconditions();
        StartElement element = this.xmlEvent.asStartElement();
        String argumentName = this.readMandatoryAttribute("argumentName", element);
        String argumentValue = this.readMandatoryAttribute("argumentValue", element);
        this.skipToTheEnd("ArgumentAssignment");
        return new ArgumentAssignment(argumentName, argumentValue);
    }

    private void readArgumentList(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace("ArgumentList");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("Argument")) {
                Argument arg = this.readArgument(spaceSystem);
                mc.addArgument(arg);
                continue;
            }
            if (this.isEndElementWithName("ArgumentList")) break;
        }
    }

    private Argument readArgument(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        log.trace("Argument");
        this.checkStartElementPreconditions();
        Argument arg = null;
        StartElement element = this.xmlEvent.asStartElement();
        String name = this.readMandatoryAttribute("name", element);
        arg = new Argument(name);
        String initialValue = this.readAttribute("initialValue", element, null);
        String argumentTypeRef = this.readMandatoryAttribute("argumentTypeRef", element);
        Argument arg1 = arg;
        NameReference nr = new NameReference(argumentTypeRef, NameReference.Type.ARGUMENT_TYPE).addResolvedAction(nd -> {
            ArgumentType atype1 = (ArgumentType)((Object)nd);
            if (initialValue != null) {
                arg1.setInitialValue(atype1.convertType(initialValue));
            }
            arg1.setArgumentType(atype1);
        });
        spaceSystem.addUnresolvedReference(nr);
        arg.setShortDescription(this.readAttribute("shortDescription", element, null));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(arg);
                continue;
            }
            if (this.isEndElementWithName("Argument")) {
                return arg;
            }
            this.logUnknown();
        }
    }

    private void readVerifierSet(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace("VerifierSet");
        this.checkStartElementPreconditions();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isStartElement() && this.xmlEvent.asStartElement().getName().getLocalPart().endsWith("Verifier")) {
                CommandVerifier cmdVerifier = this.readVerifier(spaceSystem, mc);
                if (cmdVerifier == null) continue;
                mc.addVerifier(cmdVerifier);
                continue;
            }
            if (this.isEndElementWithName("VerifierSet")) {
                return;
            }
            this.logUnknown();
        }
    }

    private CommandVerifier readVerifier(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        StartElement element = this.checkStartElementPreconditions();
        String tag = element.getName().getLocalPart();
        String stage = this.readAttribute("name", element, null);
        String type = tag.substring(0, tag.length() - 8);
        if (stage == null) {
            stage = type;
        }
        List<Object> ancillaryData = Collections.emptyList();
        CommandVerifier cmdVerifier = null;
        while (true) {
            MatchCriteria matchCriteria;
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("ContainerRef")) {
                cmdVerifier = new CommandVerifier(CommandVerifier.Type.CONTAINER, stage);
                this.readContainerRef(spaceSystem, cmdVerifier);
                continue;
            }
            if (this.isStartElementWithName("CustomAlgorithm")) {
                cmdVerifier = new CommandVerifier(CommandVerifier.Type.ALGORITHM, stage);
                CustomAlgorithm algo = this.readCustomAlgorithm(spaceSystem, metaCmd);
                algo.setScope(Algorithm.Scope.COMMAND_VERIFICATION);
                cmdVerifier.setAlgorithm(algo);
                continue;
            }
            if (this.isStartElementWithName("Comparison")) {
                cmdVerifier = new CommandVerifier(CommandVerifier.Type.MATCH_CRITERIA, stage);
                matchCriteria = this.readComparison(spaceSystem, metaCmd);
                cmdVerifier.setMatchCriteria(matchCriteria);
                continue;
            }
            if (this.isStartElementWithName("ComparisonList")) {
                cmdVerifier = new CommandVerifier(CommandVerifier.Type.MATCH_CRITERIA, stage);
                matchCriteria = this.readComparisonList(spaceSystem, metaCmd);
                cmdVerifier.setMatchCriteria(matchCriteria);
                continue;
            }
            if (this.isStartElementWithName("BooleanExpression")) {
                cmdVerifier = new CommandVerifier(CommandVerifier.Type.MATCH_CRITERIA, stage);
                matchCriteria = this.readBooleanExpression(spaceSystem, metaCmd);
                cmdVerifier.setMatchCriteria(matchCriteria);
                continue;
            }
            if (this.isStartElementWithName("ParameterValueChange")) {
                cmdVerifier = new CommandVerifier(CommandVerifier.Type.PARAMETER_VALUE_CHANGE, stage);
                ParameterValueChange paraValueChange = this.readParameterValueChange(spaceSystem);
                cmdVerifier.setParameterValueChange(paraValueChange);
                continue;
            }
            if (this.isStartElementWithName("CheckWindow")) {
                if (cmdVerifier == null) {
                    throw new XMLStreamException("CheckWindow specified before the verifier.", this.xmlEvent.getLocation());
                }
                CheckWindow cw = this.readCheckWindow(spaceSystem);
                cmdVerifier.setCheckWindow(cw);
                continue;
            }
            if (this.isStartElementWithName("AncillaryDataSet")) {
                ancillaryData = this.readAncillaryDataSet();
                continue;
            }
            if (this.isStartElementWithName("ReturnParmRef")) {
                if (cmdVerifier == null) {
                    throw new XMLStreamException("ReturnParmRef specified before the verifier.", this.xmlEvent.getLocation());
                }
                CommandVerifier cmdVerifier1 = cmdVerifier;
                String paramRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
                XtceStaxReader.makeParameterReference(spaceSystem, paramRef, (param, path) -> cmdVerifier1.setReturnParameter(param));
                continue;
            }
            if (this.isEndElementWithName(tag)) {
                if (cmdVerifier != null) {
                    if (cmdVerifier.getCheckWindow() == null) {
                        throw new XMLStreamException("No CheckWindow specified for command verifier", this.xmlEvent.getLocation());
                    }
                    CommandVerifier.TerminationAction onSuccess = null;
                    CommandVerifier.TerminationAction onFail = null;
                    CommandVerifier.TerminationAction onTimeout = null;
                    if ("Failed".equals(type)) {
                        onSuccess = CommandVerifier.TerminationAction.FAIL;
                    } else if ("Complete".equals(type)) {
                        onSuccess = CommandVerifier.TerminationAction.SUCCESS;
                        onFail = CommandVerifier.TerminationAction.FAIL;
                    } else {
                        onFail = CommandVerifier.TerminationAction.FAIL;
                    }
                    for (AncillaryData ancillaryData2 : ancillaryData) {
                        if (ancillaryData2.getName().equals("yamcs.onSuccess")) {
                            if (ancillaryData2.getValue() != null) {
                                onSuccess = CommandVerifier.TerminationAction.valueOf(ancillaryData2.getValue());
                                continue;
                            }
                            onSuccess = null;
                            continue;
                        }
                        if (ancillaryData2.getName().equals("yamcs.onFail")) {
                            if (ancillaryData2.getValue() != null) {
                                onFail = CommandVerifier.TerminationAction.valueOf(ancillaryData2.getValue());
                                continue;
                            }
                            onFail = null;
                            continue;
                        }
                        if (!ancillaryData2.getName().equals("yamcs.onTimeout")) continue;
                        if (ancillaryData2.getValue() != null) {
                            onTimeout = CommandVerifier.TerminationAction.valueOf(ancillaryData2.getValue());
                            continue;
                        }
                        onTimeout = null;
                    }
                    cmdVerifier.setOnSuccess(onSuccess);
                    cmdVerifier.setOnFail(onFail);
                    cmdVerifier.setOnTimeout(onTimeout);
                }
                return cmdVerifier;
            }
            this.logUnknown();
        }
    }

    private void readContainerRef(SpaceSystem spaceSystem, CommandVerifier cmdVerifier) throws XMLStreamException {
        String refName = this.readMandatoryAttribute("containerRef", this.xmlEvent.asStartElement());
        SequenceContainer container = spaceSystem.getSequenceContainer(refName);
        if (container != null) {
            cmdVerifier.setContainerRef(container);
        } else {
            NameReference nr = new NameReference(refName, NameReference.Type.SEQUENCE_CONTAINER).addResolvedAction(nd -> cmdVerifier.setContainerRef((SequenceContainer)nd));
            spaceSystem.addUnresolvedReference(nr);
        }
        this.xmlEvent = this.xmlEventReader.nextEvent();
        if (!this.isEndElementWithName("ContainerRef")) {
            throw new IllegalStateException("ContainerRef end element expected");
        }
    }

    private CheckWindow readCheckWindow(SpaceSystem spaceSystem) throws XMLStreamException {
        StartElement element = this.xmlEvent.asStartElement();
        String v = this.readAttribute("timeToStartChecking", element, null);
        long timeToStartChecking = v == null ? -1L : this.parseDuration(v);
        long timeToStopChecking = this.parseDuration(this.readMandatoryAttribute("timeToStopChecking", element));
        v = this.readAttribute("timeWindowIsRelativeTo", element, "timeLastVerifierPassed");
        try {
            CheckWindow.TimeWindowIsRelativeToType timeWindowIsRelativeTo = CheckWindow.TimeWindowIsRelativeToType.fromXtce(v);
            return new CheckWindow(timeToStartChecking, timeToStopChecking, timeWindowIsRelativeTo);
        }
        catch (IllegalArgumentException e) {
            throw new XMLStreamException("Invalid value '" + v + "' for timeWindowIsRelativeTo");
        }
    }

    long parseDuration(String v) {
        Duration d;
        try {
            d = DatatypeFactory.newInstance().newDuration(v);
        }
        catch (DatatypeConfigurationException e) {
            throw new Error(e);
        }
        return d.getTimeInMillis(new Date());
    }

    private CommandContainer readCommandContainer(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace("CommandContainer");
        this.checkStartElementPreconditions();
        CommandContainer cmdContainer = null;
        String value = this.readMandatoryAttribute("name", this.xmlEvent.asStartElement());
        cmdContainer = new CommandContainer(value);
        value = this.readAttribute("shortDescription", this.xmlEvent.asStartElement(), null);
        if (value != null) {
            cmdContainer.setShortDescription(value);
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(cmdContainer);
                continue;
            }
            if (this.isStartElementWithName("EntryList")) {
                this.readEntryList(spaceSystem, cmdContainer, mc);
                continue;
            }
            if (this.isStartElementWithName("BaseContainer")) {
                this.readBaseContainer(spaceSystem, cmdContainer);
                continue;
            }
            if (this.isStartElementWithName("DefaultRateInStream")) {
                cmdContainer.setRateInStream(this.readRateInStream(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("BinaryEncoding")) {
                BinaryDataEncoding.Builder bde = this.readBinaryDataEncoding(spaceSystem);
                cmdContainer.setSizeInBits(bde.getSizeInBits());
                continue;
            }
            if (this.isEndElementWithName("CommandContainer")) {
                return cmdContainer;
            }
            this.logUnknown();
        }
    }

    private void readBaseContainer(SpaceSystem spaceSystem, CommandContainer mcContainer) throws IllegalStateException, XMLStreamException {
        log.trace("BaseContainer");
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("containerRef", this.xmlEvent.asStartElement());
        if (this.excludedContainers.contains(refName)) {
            log.debug("adding {} to the list of the excluded containers because its parent is excluded", (Object)mcContainer.getName());
            this.excludedContainers.add(mcContainer.getName());
        } else {
            CommandContainer baseContainer = spaceSystem.getCommandContainer(refName);
            if (baseContainer != null) {
                mcContainer.setBaseContainer(baseContainer);
            } else {
                CommandContainer finalsc = mcContainer;
                NameReference nr = new NameReference(refName, NameReference.Type.COMMAND_CONTAINER).addResolvedAction(nd -> finalsc.setBaseContainer((Container)nd));
                spaceSystem.addUnresolvedReference(nr);
            }
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("RestrictionCriteria")) {
                MatchCriteria criteria = this.readMatchCriteria(spaceSystem, null);
                mcContainer.setRestrictionCriteria(criteria);
                continue;
            }
            if (this.isEndElementWithName("BaseContainer")) {
                return;
            }
            this.logUnknown();
        }
    }

    private ArgumentEntry readArgumentRefEntry(SpaceSystem spaceSystem, MetaCommand mc) throws XMLStreamException {
        log.trace("ArgumentRefEntry");
        this.checkStartElementPreconditions();
        String refName = this.readMandatoryAttribute("argumentRef", this.xmlEvent.asStartElement());
        Argument arg = mc.getArgument(refName);
        ArgumentEntry argumentEntry = null;
        if (arg == null) {
            throw new XMLStreamException("Undefined argument reference '" + refName + "'", this.xmlEvent.getLocation());
        }
        argumentEntry = new ArgumentEntry(arg);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("LocationInContainerInBits")) {
                this.readLocationInContainerInBits(argumentEntry);
                continue;
            }
            if (this.isStartElementWithName("RepeatEntry")) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                argumentEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName("IncludeCondition")) {
                this.skipXtceSection("IncludeCondition");
                continue;
            }
            if (this.isEndElementWithName("ArgumentRefEntry")) {
                return argumentEntry;
            }
            this.logUnknown();
        }
    }

    private FixedValueEntry readFixedValueEntry(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("FixedValueEntry");
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String name = this.readAttribute("name", startElement, null);
        String value = this.readMandatoryAttribute("binaryValue", startElement);
        byte[] binaryValue = HexUtils.unhex(value);
        int sizeInBits = this.readIntAttribute("sizeInBits", startElement, binaryValue.length * 8);
        FixedValueEntry fixedValueEntry = new FixedValueEntry(name, binaryValue, sizeInBits);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("LocationInContainerInBits")) {
                this.readLocationInContainerInBits(fixedValueEntry);
                continue;
            }
            if (this.isStartElementWithName("RepeatEntry")) {
                Repeat r = this.readRepeatEntry(spaceSystem);
                fixedValueEntry.setRepeatEntry(r);
                continue;
            }
            if (this.isStartElementWithName("IncludeCondition")) {
                this.skipXtceSection("IncludeCondition");
                continue;
            }
            if (this.isEndElementWithName("FixedValueEntry")) {
                return fixedValueEntry;
            }
            this.logUnknown();
        }
    }

    private CustomAlgorithm readCustomAlgorithm(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String tag = startElement.getName().getLocalPart();
        String name = this.readMandatoryAttribute("name", startElement);
        CustomAlgorithm algo = new CustomAlgorithm(name);
        algo.setShortDescription(this.readAttribute("shortDescription", startElement, null));
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isNamedItemProperty()) {
                this.readNamedItemProperty(algo);
                continue;
            }
            if (this.isStartElementWithName("AlgorithmText")) {
                this.readCustomAlgorithmText(algo);
                continue;
            }
            if (this.isStartElementWithName("TriggerSet")) {
                algo.setTriggerSet(this.readTriggerSet(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("OutputSet")) {
                algo.setOutputSet(this.readOutputSet(spaceSystem));
                continue;
            }
            if (this.isStartElementWithName("InputSet")) {
                this.addInputSet(spaceSystem, algo, metaCmd);
                continue;
            }
            if (this.isEndElementWithName(tag)) {
                return algo;
            }
            this.logUnknown();
        }
    }

    private void readCustomAlgorithmText(CustomAlgorithm algo) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String tag = startElement.getName().getLocalPart();
        String language = this.readMandatoryAttribute("language", startElement);
        if (!("JavaScript".equals(language) || "python".equals(language) || "java".equalsIgnoreCase(language) || "java-expression".equalsIgnoreCase(language))) {
            throw new XtceLoadException(this.fileName, this.xmlEvent.getLocation(), "Invalid algorithm language '" + language + "'. Supported are 'JavaScript', 'python', 'java' and 'java-expression'");
        }
        algo.setLanguage(language);
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.xmlEvent.isCharacters()) {
                algo.setAlgorithmText(this.xmlEvent.asCharacters().getData());
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
    }

    private void addInputSet(SpaceSystem spaceSystem, CustomAlgorithm algo, MetaCommand metaCmd) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String tag = startElement.getName().getLocalPart();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("InputParameterInstanceRef")) {
                this.addInputParameterInstanceRef(spaceSystem, algo, metaCmd);
                continue;
            }
            if (this.isStartElementWithName("InputArgumentInstanceRef")) {
                if (metaCmd == null) {
                    throw new XtceLoadException(this.fileName, this.xmlEvent.getLocation(), "Argument references can only be used in algorithms related to commands");
                }
                this.addInputArgumentInstanceRef(spaceSystem, algo, metaCmd);
                continue;
            }
            if (this.isStartElementWithName("Constant")) {
                throw new XMLStreamException("Constant input parameters not supported", this.xmlEvent.getLocation());
            }
            if (this.isEndElementWithName(tag)) {
                return;
            }
            this.logUnknown();
        }
    }

    private void addInputParameterInstanceRef(SpaceSystem spaceSystem, CustomAlgorithm algo, MetaCommand metaCmd) throws XMLStreamException {
        InputParameter inputParameter;
        log.trace("InputParameterInstanceRef");
        String paramRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        String inputName = this.readAttribute("inputName", this.xmlEvent.asStartElement(), null);
        if (paramRef.startsWith("/yamcs/cmd/arg")) {
            ArgumentInstanceRef argRef = this.readArgumentInstanceRef(spaceSystem, metaCmd);
            inputParameter = new InputParameter(argRef, inputName);
        } else {
            ParameterInstanceRef instanceRef = this.readParameterInstanceRef(spaceSystem, null);
            inputParameter = new InputParameter(instanceRef, inputName);
        }
        List<AncillaryData> adlist = algo.getAncillaryData();
        if (adlist != null) {
            boolean mandatory = algo.getAncillaryData().stream().anyMatch(ad -> "Yamcs:AlgorithmMandatoryInput".equalsIgnoreCase(ad.getName()) && Objects.equals(ad.getValue(), inputName));
            inputParameter.setMandatory(mandatory);
        }
        algo.addInput(inputParameter);
    }

    private void addInputArgumentInstanceRef(SpaceSystem spaceSystem, CustomAlgorithm algo, MetaCommand metaCmd) throws XMLStreamException {
        log.trace("InputArgumentInstanceRef");
        String inputName = this.readAttribute("inputName", this.xmlEvent.asStartElement(), null);
        ArgumentInstanceRef argRef = this.readArgumentInstanceRef(spaceSystem, metaCmd);
        InputParameter inputParameter = new InputParameter(argRef, inputName);
        algo.addInput(inputParameter);
    }

    private List<OutputParameter> readOutputSet(SpaceSystem spaceSystem) throws XMLStreamException {
        this.checkStartElementPreconditions();
        StartElement startElement = this.xmlEvent.asStartElement();
        String tag = startElement.getName().getLocalPart();
        ArrayList<OutputParameter> result = new ArrayList<OutputParameter>();
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("OutputParameterRef")) {
                result.add(this.readOutputParameterRef(spaceSystem));
                continue;
            }
            if (this.isEndElementWithName(tag)) break;
        }
        return result;
    }

    private Significance readSignificance(SpaceSystem spaceSystem) throws IllegalStateException, XMLStreamException {
        Significance.Levels clevel;
        log.trace("DefaultSignificance");
        this.checkStartElementPreconditions();
        String reason = this.readAttribute("reasonForWarning", this.xmlEvent.asStartElement(), null);
        String conseq = this.readMandatoryAttribute("consequenceLevel", this.xmlEvent.asStartElement());
        try {
            clevel = Significance.Levels.fromString(conseq.toLowerCase());
        }
        catch (IllegalArgumentException e) {
            String allowedValues = Arrays.stream(Significance.Levels.values()).map(l -> l.xtceAlias()).collect(Collectors.joining(", "));
            throw new XMLStreamException("Invalid consequence level '" + conseq + "'; allowed values: [" + allowedValues + "]");
        }
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isEndElementWithName("DefaultSignificance")) {
                return new Significance(clevel, reason);
            }
            this.logUnknown();
        }
    }

    private void readTransmissionConstraintList(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        log.trace("TransmissionConstraintList");
        while (true) {
            this.xmlEvent = this.xmlEventReader.nextEvent();
            if (this.isStartElementWithName("TransmissionConstraint")) {
                TransmissionConstraint trc = this.readTransmissionConstraint(spaceSystem, metaCmd);
                metaCmd.addTransmissionConstrain(trc);
                continue;
            }
            if (this.isEndElementWithName("TransmissionConstraintList")) break;
        }
    }

    TransmissionConstraint readTransmissionConstraint(SpaceSystem spaceSystem, MetaCommand metaCmd) throws XMLStreamException {
        log.trace("TransmissionConstraint");
        StartElement element = this.xmlEvent.asStartElement();
        String timeouts = this.readAttribute("timeOut", element, null);
        long timeout = timeouts == null ? 0L : this.parseDuration(timeouts);
        MatchCriteria matchCriteria = this.readMatchCriteria(spaceSystem, metaCmd);
        return new TransmissionConstraint(matchCriteria, timeout);
    }

    private OutputParameter readOutputParameterRef(SpaceSystem spaceSystem) throws XMLStreamException {
        log.trace("OutputParameterRef");
        String paramRef = this.readMandatoryAttribute("parameterRef", this.xmlEvent.asStartElement());
        String outputName = this.readAttribute("outputName", this.xmlEvent.asStartElement(), null);
        OutputParameter outp = new OutputParameter();
        outp.setOutputName(outputName);
        NameReference nr = new NameReference(paramRef, NameReference.Type.PARAMETER).addResolvedAction(nd -> outp.setParameter((Parameter)nd));
        spaceSystem.addUnresolvedReference(nr);
        return outp;
    }

    private void addToSkipStatistics(String xtceSectionName) {
        Integer count = this.xtceSkipStatistics.get(xtceSectionName);
        if (count == null) {
            this.xtceSkipStatistics.put(xtceSectionName, 1);
        } else {
            this.xtceSkipStatistics.put(xtceSectionName, count + 1);
        }
    }

    public void writeStatistics() {
        log.info("------------------");
        log.info("Statistics of skipped elements: ");
        for (Map.Entry<String, Integer> entry : this.xtceSkipStatistics.entrySet()) {
            log.info(">> {} : {} ", (Object)entry.getKey(), (Object)entry.getValue());
        }
        log.info("------------------");
    }

    private void skipXtceSection(String sectionName) throws XMLStreamException {
        log.trace(sectionName);
        this.checkStartElementPreconditions();
        this.addToSkipStatistics(sectionName);
        try {
            while (true) {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.isStartElementWithName(sectionName)) {
                    this.skipXtceSection(sectionName);
                    continue;
                }
                if (this.isEndElementWithName(sectionName)) break;
            }
            log.info("Section <{}> skipped", (Object)sectionName);
            return;
        }
        catch (NoSuchElementException e) {
            throw new XMLStreamException("End of section unreachable: " + sectionName, this.xmlEvent.getLocation());
        }
    }

    private void skipToTheEnd(String sectionName) throws XMLStreamException, IllegalStateException {
        log.trace(sectionName);
        this.checkStartElementPreconditions();
        try {
            while (true) {
                this.xmlEvent = this.xmlEventReader.nextEvent();
                if (this.isStartElementWithName(sectionName)) {
                    this.skipXtceSection(sectionName);
                    continue;
                }
                if (this.isEndElementWithName(sectionName)) break;
            }
            return;
        }
        catch (NoSuchElementException e) {
            throw new XMLStreamException("End of section unreachable: " + sectionName, this.xmlEvent.getLocation());
        }
    }

    private boolean isNamedItemProperty() {
        if (this.xmlEvent.getEventType() != 1) {
            return false;
        }
        String name = this.xmlEvent.asStartElement().getName().getLocalPart();
        return "AliasSet".equals(name) || "LongDescription".equals(name) || "AncillaryDataSet".equals(name);
    }

    void readNamedItemProperty(NameDescription nd) throws XMLStreamException {
        if (this.isStartElementWithName("AliasSet")) {
            nd.setAliasSet(this.readAliasSet());
        } else if (this.isStartElementWithName("AncillaryDataSet")) {
            nd.setAncillaryData(this.readAncillaryDataSet());
        } else if (this.isStartElementWithName("LongDescription")) {
            nd.setLongDescription(this.readStringBetweenTags("LongDescription"));
        }
    }

    boolean readNamedItemProperty(NameDescription.Builder<?> nd) throws XMLStreamException {
        if (this.isStartElementWithName("AliasSet")) {
            nd.setAliasSet(this.readAliasSet());
        } else if (this.isStartElementWithName("AncillaryDataSet")) {
            nd.setAncillaryData(this.readAncillaryDataSet());
        } else if (this.isStartElementWithName("LongDescription")) {
            nd.setLongDescription(this.readStringBetweenTags("LongDescription"));
        } else {
            return false;
        }
        return true;
    }

    public void setExcludedContainers(Set<String> excludedContainers) {
        this.excludedContainers = excludedContainers;
    }

    private void logUnknown() {
        if (this.xmlEvent.isStartElement()) {
            StartElement element = this.xmlEvent.asStartElement();
            log.warn("Skipping unknown tag {} at {}:{}", new Object[]{element.getName().getLocalPart(), element.getLocation().getLineNumber(), element.getLocation().getColumnNumber()});
        }
    }

    public static ParameterReference getParameterReference(SpaceSystem spaceSystem, String paramName) {
        ParameterReference paraRef = new ParameterReference(paramName);
        spaceSystem.addUnresolvedReference(paraRef);
        return paraRef;
    }

    public static void makeParameterReference(SpaceSystem spaceSystem, String paramRef, ParameterReference.ParameterResolvedAction action) {
        XtceStaxReader.getParameterReference(spaceSystem, paramRef).addResolvedAction(action);
    }

    void throwException(Location location, String message) {
        throw new XtceLoadException(this.fileName, location, message);
    }
}

