/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.api.EffectiveName;

public class PropertyNaming {
    private final EffectiveName canonicalName;
    private final List<EffectiveName> aliases;

    public PropertyNaming(EffectiveName canonicalName, List<EffectiveName> aliases) {
        this.canonicalName = canonicalName;
        this.aliases = aliases != null ? Collections.unmodifiableList(aliases) : Collections.emptyList();
    }

    public EffectiveName getCanonicalName() {
        return this.canonicalName;
    }

    public List<EffectiveName> getAliases() {
        return this.aliases;
    }

    public List<EffectiveName> getInAliases() {
        ArrayList ns = new ArrayList();
        this.aliases.stream().filter(a -> a.isIn()).forEachOrdered(a -> ns.add(a));
        return Collections.unmodifiableList(ns);
    }

    public List<EffectiveName> getOutAliases() {
        ArrayList ns = new ArrayList();
        this.aliases.stream().filter(a -> a.isOut()).forEachOrdered(a -> ns.add(a));
        return Collections.unmodifiableList(ns);
    }
}

