/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.api;

import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.internal.ValueProblem;

public class ValidatedValue<T> {
    private final Property<T> property;
    private final T value;
    private ProblemList<ValueProblem> problems;

    public boolean equals(Object obj) {
        boolean basicPropsEq = false;
        if (obj instanceof ValidatedValue) {
            ValidatedValue other = (ValidatedValue)obj;
            if (this.property == other.property) {
                if (this.value != null && other.value != null) {
                    basicPropsEq = this.value.equals(other.value);
                } else if (this.value == null && other.value == null) {
                    basicPropsEq = true;
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        if (this.property != null) {
            hash *= this.property.hashCode();
        }
        if (this.value != null) {
            hash *= this.value.hashCode();
        }
        return hash;
    }

    public ValidatedValue(Property<T> prop, T value) {
        this.property = prop;
        this.value = value;
    }

    public ValidatedValue(Property<T> prop, T value, ProblemList<ValueProblem> inIssues) {
        this.property = prop;
        this.value = value;
        if (inIssues != null && inIssues.size() > 0) {
            this.problems = inIssues;
        }
    }

    public Property<T> getProperty() {
        return this.property;
    }

    public T getValue() {
        return this.value;
    }

    public void addProblem(ValueProblem problem) {
        if (this.problems == null) {
            this.problems = new ProblemList();
        }
        this.problems.add(problem);
    }

    public boolean hasProblems() {
        return this.problems != null && this.problems.size() > 0;
    }

    public ProblemList<Problem> getProblems() {
        if (this.problems != null) {
            return new ProblemList.UnmodifiableProblemList<Problem>(this.problems);
        }
        return ProblemList.EMPTY_PROBLEM_LIST;
    }
}

