/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.compile;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.yarnandtail.andhow.compile.SimpleType;
import org.yarnandtail.andhow.compile.SimpleVariable;
import org.yarnandtail.andhow.service.PropertyRegistrationList;
import org.yarnandtail.andhow.util.NameUtil;

public class CompileUnit {
    private final String classCanonName;
    private PropertyRegistrationList registrations;
    private List<String> errors;
    private boolean initClass;
    private boolean testInitClass;
    private ArrayDeque<SimpleType> innerPathStack = new ArrayDeque();

    public CompileUnit(String classCanonName) {
        this.classCanonName = classCanonName;
    }

    public boolean isInitClass() {
        return this.initClass;
    }

    public void setInitClass(boolean initClass) {
        this.initClass = initClass;
    }

    public boolean istestInitClass() {
        return this.testInitClass;
    }

    public void setTestInitClass(boolean testInitClass) {
        this.testInitClass = testInitClass;
    }

    public void pushType(SimpleType simpleName) {
        if (this.innerPathStack == null) {
            this.innerPathStack = new ArrayDeque();
        }
        this.innerPathStack.addLast(simpleName);
    }

    public void pushType(String name, boolean _static) {
        this.pushType(new SimpleType(name, _static));
    }

    public SimpleType popType() {
        if (this.innerPathStack == null || this.innerPathStack.size() == 0) {
            throw new RuntimeException("The nesting order of inner classes is broken - expected to be in an inner class.");
        }
        return this.innerPathStack.pollLast();
    }

    public boolean addProperty(SimpleVariable variableElement) {
        if (variableElement.isStatic() && variableElement.isFinal()) {
            if (this.registrations == null) {
                this.registrations = new PropertyRegistrationList(this.classCanonName);
            }
            this.registrations.add(variableElement.getName(), this.getInnerPathNames());
            return true;
        }
        this.addPropertyError(variableElement.getName(), "New AndHow Properties must be assigned to a static final field.");
        return false;
    }

    public boolean addProperty(String name, boolean _static, boolean _final) {
        return this.addProperty(new SimpleVariable(name, _static, _final));
    }

    public List<SimpleType> getInnerPath() {
        ArrayList<SimpleType> innerPath = this.innerPathStack != null && this.innerPathStack.size() > 0 ? new ArrayList<SimpleType>(this.innerPathStack) : Collections.EMPTY_LIST;
        return innerPath;
    }

    public List<String> getInnerPathNames() {
        ArrayList<String> pathNames;
        if (this.innerPathStack != null && this.innerPathStack.size() > 0) {
            pathNames = new ArrayList<String>();
            Iterator<SimpleType> it = this.innerPathStack.iterator();
            while (it.hasNext()) {
                pathNames.add(it.next().getName());
            }
        } else {
            pathNames = Collections.EMPTY_LIST;
        }
        return pathNames;
    }

    public void addPropertyError(String propName, String msg) {
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        String parentName = NameUtil.getJavaName(this.classCanonName, this.getInnerPathNames());
        this.errors.add("The AndHow Property '" + propName + "' in " + parentName + " is invalid: " + msg);
    }

    public String getRootCanonicalName() {
        return this.classCanonName;
    }

    public String getRootSimpleName() {
        int dotPos = this.classCanonName.lastIndexOf(".");
        if (dotPos > 0) {
            return this.classCanonName.substring(dotPos + 1);
        }
        return this.classCanonName;
    }

    public String getRootPackageName() {
        int dotPos = this.classCanonName.lastIndexOf(".");
        if (dotPos > 0) {
            return this.classCanonName.substring(0, dotPos);
        }
        return null;
    }

    public PropertyRegistrationList getRegistrations() {
        return this.registrations;
    }

    public List<String> getErrors() {
        if (this.errors != null) {
            return this.errors;
        }
        return Collections.EMPTY_LIST;
    }

    public boolean hasErrors() {
        if (this.errors != null) {
            return !this.errors.isEmpty();
        }
        return false;
    }

    public boolean hasRegistrations() {
        return this.registrations != null && !this.registrations.isEmpty();
    }
}

