/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.internal.PropertyCoord;
import org.yarnandtail.andhow.util.TextUtil;

public abstract class RequirementProblem
implements Problem {
    protected PropertyCoord propertyCoord;

    public PropertyCoord getPropertyCoord() {
        return this.propertyCoord;
    }

    @Override
    public String getFullMessage() {
        return this.getProblemContext() + ": " + this.getProblemDescription();
    }

    public static class RequiredPropertyGroupProblem
    extends RequirementProblem {
        public RequiredPropertyGroupProblem(Class<?> group) {
            this.propertyCoord = new PropertyCoord(group, null);
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("PropertyGroup {}", this.propertyCoord.getGroup().getCanonicalName());
        }

        @Override
        public String getProblemDescription() {
            return "This PropertyGroup is required - A value for at least one its propertides must be found by one of the loaders";
        }
    }

    public static class NonNullPropertyProblem
    extends RequirementProblem {
        public NonNullPropertyProblem(Class<?> group, Property<?> prop) {
            this.propertyCoord = new PropertyCoord(group, prop);
        }

        @Override
        public String getProblemContext() {
            return TextUtil.format("Property {}", this.propertyCoord.getPropName());
        }

        @Override
        public String getProblemDescription() {
            return "This Property must be non-null - It must have a non-null default or be loaded by one of the loaders to a non-null value";
        }
    }
}

