/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.yarnandtail.andhow.api.Loader;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.ValidatedValues;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.internal.ValidatedValuesWithContextBase;
import org.yarnandtail.andhow.internal.ValidatedValuesWithContextImmutable;

public class ValidatedValuesWithContextMutable
extends ValidatedValuesWithContextBase {
    private final ArrayList<LoaderValues> loadedValuesList = new ArrayList();
    private boolean problem = false;

    public void addValues(LoaderValues values) {
        this.loadedValuesList.add(values);
        if (values.getProblems().size() > 0) {
            this.problem = true;
        }
    }

    @Override
    public ValidatedValuesWithContext getValueMapWithContextImmutable() {
        return new ValidatedValuesWithContextImmutable(this.loadedValuesList);
    }

    @Override
    public <T> T getExplicitValue(Property<T> prop) {
        return this.getExplicitValue(this.loadedValuesList, prop);
    }

    @Override
    public <T> T getValue(Property<T> prop) {
        return this.getEffectiveValue(this.loadedValuesList, prop);
    }

    @Override
    public boolean isExplicitlySet(Property<?> prop) {
        return this.isPropertyPresent(this.loadedValuesList, prop);
    }

    @Override
    public List<LoaderValues> getAllLoaderValues() {
        return Collections.unmodifiableList(this.loadedValuesList);
    }

    @Override
    public LoaderValues getAllValuesLoadedByLoader(Loader loader) {
        return this.getAllValuesLoadedByLoader(this.loadedValuesList, loader);
    }

    @Override
    public LoaderValues getEffectiveValuesLoadedByLoader(Loader loader) {
        return this.getEffectiveValuesLoadedByLoader(this.loadedValuesList, loader);
    }

    @Override
    public ValidatedValues getValueMapImmutable() {
        return this.buildValueMapImmutable(this.loadedValuesList);
    }

    @Override
    public boolean hasProblems() {
        return this.problem;
    }
}

