/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import org.yarnandtail.andhow.api.ParsingException;
import org.yarnandtail.andhow.util.TextUtil;

public class KVP {
    public static final KVP NULL_KVP = new KVP();
    private String name;
    private String value;

    private KVP() {
    }

    public KVP(String name) throws ParsingException {
        this.name = TextUtil.trimToNull(name);
        if (this.name == null) {
            throw new ParsingException("The key (parameter name) cannot be empty", name);
        }
    }

    public KVP(String name, String value) throws ParsingException {
        this.name = TextUtil.trimToNull(name);
        this.value = TextUtil.trimToNull(value);
        if (this.name == null) {
            throw new ParsingException("The key (parameter name) cannot be empty", name);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public static KVP splitKVP(String arg, String delimiter) throws ParsingException {
        if ((arg = TextUtil.trimToNull(arg)) != null) {
            String[] ss = arg.split(delimiter, 2);
            String name = null;
            String value = null;
            if (ss.length > 0 && (name = TextUtil.trimToNull(ss[0])) == null) {
                throw new ParsingException("The key (parameter name) cannot be empty", arg);
            }
            if (ss.length > 1) {
                value = ss[1];
            }
            return new KVP(name, value);
        }
        return NULL_KVP;
    }
}

