/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.ReadLoader;
import org.yarnandtail.andhow.api.StaticPropertyConfiguration;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.load.BaseLoader;

public class MapLoader
extends BaseLoader
implements ReadLoader {
    protected Map<?, ?> map;
    protected boolean unknownPropertyAProblem = true;

    public void setMap(Map<?, ?> map) {
        this.map = map;
    }

    public Map<?, ?> getMap() {
        return this.map;
    }

    @Override
    public LoaderValues load(StaticPropertyConfiguration appConfigDef, ValidatedValuesWithContext existingValues) {
        Map<?, ?> props = this.getMap();
        if (props != null) {
            ArrayList<ValidatedValue> values = new ArrayList<ValidatedValue>();
            ProblemList<Problem> problems = new ProblemList<Problem>();
            Set<?> keys = props.keySet();
            for (Object key : keys) {
                if (key == null) continue;
                Object val = props.get(key);
                String sVal = val != null ? val.toString() : null;
                this.attemptToAdd(appConfigDef, values, problems, key.toString(), sVal);
            }
            values.trimToSize();
            return new LoaderValues(this, values, problems);
        }
        return new LoaderValues(this);
    }

    @Override
    public String getSpecificLoadDescription() {
        return "Map";
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return true;
    }

    @Override
    public void setUnknownPropertyAProblem(boolean isAProblem) {
        this.unknownPropertyAProblem = isAProblem;
    }

    @Override
    public boolean isUnknownPropertyAProblem() {
        return this.unknownPropertyAProblem;
    }

    @Override
    public String getLoaderType() {
        return "Map";
    }

    @Override
    public String getLoaderDialect() {
        return null;
    }

    @Override
    public void releaseResources() {
        this.map = null;
    }
}

