/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.load.std;

import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.yarnandtail.andhow.GroupInfo;
import org.yarnandtail.andhow.api.BasePropertyGroup;
import org.yarnandtail.andhow.api.LoaderValues;
import org.yarnandtail.andhow.api.LookupLoader;
import org.yarnandtail.andhow.api.Problem;
import org.yarnandtail.andhow.api.ProblemList;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.api.SamplePrinter;
import org.yarnandtail.andhow.api.StandardLoader;
import org.yarnandtail.andhow.api.StaticPropertyConfiguration;
import org.yarnandtail.andhow.api.ValidatedValue;
import org.yarnandtail.andhow.api.ValidatedValues;
import org.yarnandtail.andhow.api.ValidatedValuesWithContext;
import org.yarnandtail.andhow.internal.LoaderProblem;
import org.yarnandtail.andhow.load.BaseLoader;
import org.yarnandtail.andhow.property.QuotedSpacePreservingTrimmer;
import org.yarnandtail.andhow.property.StrProp;
import org.yarnandtail.andhow.sample.JndiLoaderSamplePrinter;
import org.yarnandtail.andhow.util.AndHowLog;
import org.yarnandtail.andhow.util.TextUtil;

public class StdJndiLoader
extends BaseLoader
implements LookupLoader,
StandardLoader {
    private boolean failedEnvironmentAProblem = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public LoaderValues load(StaticPropertyConfiguration appConfigDef, ValidatedValuesWithContext existingValues) {
        AndHowLog log = AndHowLog.getLogger(StdJndiLoader.class);
        List<String> jndiRoots = this.buildJndiRoots(existingValues);
        ArrayList<ValidatedValue> values = new ArrayList<ValidatedValue>();
        ProblemList<Problem> problems = new ProblemList<Problem>();
        try {
            InitialContext ctx = new InitialContext();
            ArrayList propNames = new ArrayList();
            for (Property<?> prop : appConfigDef.getProperties()) {
                List<String> propJndiNames = this.buildJndiNames(appConfigDef, jndiRoots, prop);
                for (String propName : propJndiNames) {
                    try {
                        Object o = ctx.lookup(propName);
                        if (o == null) continue;
                        this.attemptToAdd(appConfigDef, values, problems, prop, o);
                    }
                    catch (NameNotFoundException o) {
                    }
                    catch (NamingException ne) {
                        if (ne.getRootCause() instanceof NameNotFoundException) continue;
                        throw ne;
                    }
                }
                continue;
                return new LoaderValues(this, values, problems);
            }
        }
        catch (NamingException ex) {
            if (this.isFailedEnvironmentAProblem()) {
                log.error("Unable to read from JNDI - Does JNDI exist in this environment? If this is expected, initialize the JndiLoader ignore non-JNDI environments.", ex);
                problems.add(new LoaderProblem.JndiContextLoaderProblem(this));
                return new LoaderValues(this, values, problems);
            }
            log.debug("No JNDI Environment found, or a naming error encountered.  The JndiLoader is configured to ignore this.");
        }
        return new LoaderValues(this, values, problems);
    }

    @Override
    public boolean isTrimmingRequiredForStringValues() {
        return false;
    }

    @Override
    public String getSpecificLoadDescription() {
        return "JNDI properties in the system-wide JNDI context";
    }

    @Override
    public Class<?> getClassConfig() {
        return CONFIG.class;
    }

    @Override
    public SamplePrinter getConfigSamplePrinter() {
        return new JndiLoaderSamplePrinter();
    }

    protected List<String> buildJndiRoots(ValidatedValues values) {
        List<String> addRoots;
        ArrayList<String> myJndiRoots = new ArrayList<String>();
        if (values.getValue(CONFIG.ADDED_JNDI_ROOTS) != null) {
            addRoots = this.split(values.getValue(CONFIG.ADDED_JNDI_ROOTS));
            myJndiRoots.addAll(addRoots);
        }
        addRoots = this.split(values.getValue(CONFIG.STANDARD_JNDI_ROOTS));
        myJndiRoots.addAll(addRoots);
        return myJndiRoots;
    }

    protected List<String> buildJndiNames(StaticPropertyConfiguration appConfigDef, List<String> roots, Property prop) {
        ArrayList<String> propNames = new ArrayList<String>();
        ArrayList<String> propJndiNames = new ArrayList<String>();
        if (appConfigDef.getNamingStrategy().isUriNameDistict(appConfigDef.getCanonicalName(prop))) {
            propNames.add(appConfigDef.getNamingStrategy().getUriName(appConfigDef.getCanonicalName(prop)));
        }
        propNames.add(appConfigDef.getCanonicalName(prop));
        appConfigDef.getAliases(prop).stream().filter(a -> a.isIn()).forEach(a -> {
            propNames.add(a.getActualName());
            if (appConfigDef.getNamingStrategy().isUriNameDistict(a.getActualName())) {
                propNames.add(appConfigDef.getNamingStrategy().getUriName(a.getActualName()));
            }
        });
        for (String root : roots) {
            for (String propName : propNames) {
                propJndiNames.add(root + propName);
            }
        }
        return propJndiNames;
    }

    protected List<String> split(String rootStr) {
        ArrayList<String> cleanRoots = new ArrayList<String>();
        if (rootStr != null) {
            QuotedSpacePreservingTrimmer trimmer = QuotedSpacePreservingTrimmer.instance();
            String[] roots = rootStr.split(",");
            for (int i = 0; i < roots.length; ++i) {
                String s = trimmer.trim(roots[i]);
                if (s == null) continue;
                cleanRoots.add(s);
            }
            return cleanRoots;
        }
        return TextUtil.EMPTY_STRING_LIST;
    }

    @Override
    public String getLoaderType() {
        return "JNDI";
    }

    @Override
    public String getLoaderDialect() {
        return null;
    }

    @Override
    public void setFailedEnvironmentAProblem(boolean isAProblem) {
        this.failedEnvironmentAProblem = isAProblem;
    }

    @Override
    public boolean isFailedEnvironmentAProblem() {
        return this.failedEnvironmentAProblem;
    }

    @GroupInfo(name="JndiLoader Configuration", desc="Since JNDI providers use different base URIs to store entries, base URIs must be configurable. The most common URI roots are \"java:\", \"java:comp/env/\" or just \"\".To preserve whitespace or indicate an empty string, use double quotes around an individual comma separated value.If your container/provider uses something different, set one of these properties. All configured JNDI roots will be searched for each application property.Typically there are multiple roots to search and multiple forms of property names, leading to the possibility of duplicate/conflicting JNDI entries. If multiple entries are found in JNDI for a property, a runtime error is thrown at startup.")
    public static interface CONFIG
    extends BasePropertyGroup {
        public static final StrProp STANDARD_JNDI_ROOTS = ((StrProp.StrBuilder)((StrProp.StrBuilder)((StrProp.StrBuilder)((StrProp.StrBuilder)StrProp.builder().defaultValue("java:comp/env/,java:,\"\"")).mustBeNonNull()).desc("A comma separated list of standard JNDI root locations to be searched for properties. Setting this property will replace the standard list, use ADDED_JNDI_ROOTS to only add to the list. ")).helpText("The final JNDI URIs to be searched will look like this '[root][Property Name]'")).build();
        public static final StrProp ADDED_JNDI_ROOTS = ((StrProp.StrBuilder)((StrProp.StrBuilder)StrProp.builder().desc("A comma separated list of JNDI root locations to be prepended to the standard list for searching. Setting this property does not affect the STANDARD_JNDI_ROOTS.")).helpText("The final JNDI URIs to be searched will look like this '[root][Property Name]'")).build();
    }
}

