/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.service;

import java.util.List;
import org.yarnandtail.andhow.util.NameUtil;

public class PropertyRegistration
implements Comparable<PropertyRegistration> {
    private final String classCanonName;
    private final String[] innerPath;
    private final String propName;

    PropertyRegistration(String classCanonName, String propName) {
        this.classCanonName = classCanonName;
        this.propName = propName;
        this.innerPath = null;
    }

    PropertyRegistration(String classCanonName, String propName, String ... innerPathNesting) {
        this.classCanonName = classCanonName;
        this.propName = propName;
        this.innerPath = innerPathNesting != null && innerPathNesting.length > 0 ? innerPathNesting : null;
    }

    PropertyRegistration(String classCanonName, String propName, List<String> innerPathNesting) {
        this.classCanonName = classCanonName;
        this.propName = propName;
        this.innerPath = innerPathNesting != null && innerPathNesting.size() > 0 ? innerPathNesting.toArray(new String[innerPathNesting.size()]) : null;
    }

    public String getCanonicalRootName() {
        return this.classCanonName;
    }

    public String getPropertyName() {
        return this.propName;
    }

    public String[] getInnerPath() {
        return this.innerPath;
    }

    public int getInnerPathLength() {
        if (this.innerPath == null) {
            return 0;
        }
        return this.innerPath.length;
    }

    public String getCanonicalPropertyName() {
        return NameUtil.getAndHowName(this.classCanonName, this.propName, this.innerPath);
    }

    public String getJavaCanonicalParentName() {
        return NameUtil.getJavaName(this.classCanonName, this.innerPath);
    }

    public String getCanonicalParentName() {
        return NameUtil.getAndHowName(this.classCanonName, this.innerPath);
    }

    public int compareRootTo(PropertyRegistration o) {
        if (this.classCanonName.equals(o.classCanonName)) {
            return 0;
        }
        String[] thisPath = this.classCanonName.split("\\.");
        String[] thatPath = o.classCanonName.split("\\.");
        int minLen = Math.min(thisPath.length, thatPath.length);
        for (int i = 0; i < minLen; ++i) {
            if (i == minLen - 1) {
                if (thisPath.length < thatPath.length) {
                    return -1;
                }
                if (thisPath.length > thatPath.length) {
                    return 1;
                }
                return thisPath[i].compareTo(thatPath[i]);
            }
            int comp = thisPath[i].compareTo(thatPath[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    public int compareInnerPathTo(PropertyRegistration o) {
        String[] thisPath = this.innerPath;
        String[] thatPath = o.innerPath;
        if (thisPath == null) {
            if (thatPath == null) {
                return 0;
            }
            return -1;
        }
        if (thatPath == null) {
            return 1;
        }
        int minLen = Math.min(thisPath.length, thatPath.length);
        for (int i = 0; i < minLen; ++i) {
            int comp;
            if (i == minLen - 1) {
                comp = thisPath[i].compareTo(thatPath[i]);
                if (comp != 0) {
                    return comp;
                }
                if (thisPath.length < thatPath.length) {
                    return -1;
                }
                if (thisPath.length > thatPath.length) {
                    return 1;
                }
                return 0;
            }
            comp = thisPath[i].compareTo(thatPath[i]);
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }

    @Override
    public int compareTo(PropertyRegistration o) {
        int comp = this.compareRootTo(o);
        if (comp != 0) {
            return comp;
        }
        comp = this.compareInnerPathTo(o);
        if (comp != 0) {
            return comp;
        }
        return this.getPropertyName().compareTo(o.getPropertyName());
    }
}

