/*
 * Decompiled with CFR 0.152.
 */
package org.yarnandtail.andhow.util;

import java.util.List;
import org.yarnandtail.andhow.api.Property;
import org.yarnandtail.andhow.util.AndHowUtil;

public class NameUtil {
    public static String getAndHowName(String classCanonName, String propName, List<String> innerPath) {
        if (innerPath != null && innerPath.size() > 0) {
            return classCanonName + "." + String.join((CharSequence)".", innerPath) + "." + propName;
        }
        return classCanonName + "." + propName;
    }

    public static String getAndHowName(String classCanonName, String propName, String ... innerPath) {
        if (innerPath != null && innerPath.length > 0) {
            return classCanonName + "." + String.join((CharSequence)".", innerPath) + "." + propName;
        }
        return classCanonName + "." + propName;
    }

    public static String getJavaName(String classCanonName, String[] innerPath) {
        if (innerPath != null && innerPath.length > 0) {
            return classCanonName + "$" + String.join((CharSequence)"$", innerPath);
        }
        return classCanonName;
    }

    public static String getJavaName(String classCanonName, List<String> innerPath) {
        if (innerPath != null && innerPath.size() > 0) {
            return classCanonName + "$" + String.join((CharSequence)"$", innerPath);
        }
        return classCanonName;
    }

    public static String getAndHowName(String classCanonName, String[] innerPath) {
        if (innerPath != null && innerPath.length > 0) {
            return classCanonName + "." + String.join((CharSequence)".", innerPath);
        }
        return classCanonName;
    }

    public static String getAndHowName(Class<?> group) {
        return group.getCanonicalName();
    }

    public static String getJavaName(Class<?> group) {
        return group.getName();
    }

    public static String getAndHowName(Class<?> group, Property<?> property) throws IllegalArgumentException, IllegalAccessException, SecurityException {
        String fieldName = AndHowUtil.getFieldName(group, property);
        if (fieldName != null) {
            return NameUtil.getAndHowName(group) + "." + fieldName;
        }
        return null;
    }
}

