/*
 * Decompiled with CFR 0.152.
 */
package org.yunchen.gb.plugin.springsecurity.rest;

import com.nimbusds.jwt.JWT;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.time.TimeCategory;
import groovy.time.TimeDuration;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.util.Date;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberDiv;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.yunchen.gb.plugin.springsecurity.rest.service.JwtService;
import org.yunchen.gb.plugin.springsecurity.rest.token.AccessToken;
import org.yunchen.gb.plugin.springsecurity.rest.token.storage.TokenStorageService;

public class RestAuthenticationProvider
implements AuthenticationProvider,
GroovyObject {
    @Autowired
    private TokenStorageService tokenStorageService;
    private Boolean useJwt;
    @Autowired
    private JwtService jwtService;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public RestAuthenticationProvider() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Object v0;
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.useJwt}, new String[]{"Use JWT: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        Assert.isInstanceOf(AccessToken.class, (Object)authentication, (String)"Only AccessToken is supported");
        AccessToken authenticationRequest = (AccessToken)((Object)ScriptBytecodeAdapter.asType((Object)authentication, AccessToken.class));
        AccessToken authenticationResult = new AccessToken(authenticationRequest.getAccessToken());
        if (DefaultTypeTransformation.booleanUnbox((Object)authenticationRequest.getAccessToken())) {
            Object v5;
            AccessToken accessToken;
            Object v1;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{authenticationRequest.getAccessToken()}, new String[]{"Trying to validate token ", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
            UserDetails userDetails = this.tokenStorageService.loadUserByToken(authenticationRequest.getAccessToken());
            Integer expiration = null;
            JWT jwt = null;
            Boolean bl = this.useJwt;
            if (bl == null ? false : bl) {
                JWT jWT;
                Date now = new Date();
                jwt = jWT = this.jwtService.parse(authenticationRequest.getAccessToken());
                Date expiry = jwt.getJWTClaimsSet().getExpirationTime();
                if (DefaultTypeTransformation.booleanUnbox((Object)expiry)) {
                    Object v4;
                    Object v3;
                    if (log.isDebugEnabled()) {
                        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{now, expiry}, new String[]{"Now is ", " and token expires at ", ""})));
                        v3 = null;
                    } else {
                        v3 = null;
                    }
                    TimeDuration timeDuration = TimeCategory.minus((Date)expiry, (Date)now);
                    int n = Math.round(DefaultTypeTransformation.floatUnbox((Object)ScriptBytecodeAdapter.asType((Object)NumberNumberDiv.div((Number)timeDuration.toMilliseconds(), (Number)1000), Float.TYPE)));
                    expiration = n;
                    if (log.isDebugEnabled()) {
                        log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{expiration}, new String[]{"Expiration: ", ""})));
                        v4 = null;
                    } else {
                        v4 = null;
                    }
                }
            }
            authenticationResult = accessToken = new AccessToken(userDetails, userDetails.getAuthorities(), authenticationRequest.getAccessToken(), null, expiration, jwt, null);
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{authenticationResult}, new String[]{"Authentication result: ", ""})));
                v5 = null;
            } else {
                v5 = null;
            }
        }
        return authenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return AccessToken.class.isAssignableFrom(authentication.getSuperclass());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != RestAuthenticationProvider.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.yunchen.gb.plugin.springsecurity.rest.RestAuthenticationProvider");
    }

    @Generated
    public TokenStorageService getTokenStorageService() {
        return this.tokenStorageService;
    }

    @Generated
    public void setTokenStorageService(TokenStorageService tokenStorageService) {
        this.tokenStorageService = tokenStorageService;
    }

    @Generated
    public Boolean getUseJwt() {
        return this.useJwt;
    }

    @Generated
    public Boolean isUseJwt() {
        return this.useJwt;
    }

    @Generated
    public void setUseJwt(Boolean bl) {
        this.useJwt = bl;
    }

    @Generated
    public JwtService getJwtService() {
        return this.jwtService;
    }

    @Generated
    public void setJwtService(JwtService jwtService) {
        this.jwtService = jwtService;
    }
}

