/*
 * Decompiled with CFR 0.152.
 */
package org.yunchen.gb.plugin.springsecurity.rest;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.filter.GenericFilterBean;
import org.yunchen.gb.plugin.springsecurity.rest.token.AccessToken;
import org.yunchen.gb.plugin.springsecurity.rest.token.reader.TokenReader;
import org.yunchen.gb.plugin.springsecurity.rest.token.storage.TokenNotFoundException;
import org.yunchen.gb.plugin.springsecurity.rest.token.storage.TokenStorageService;

public class RestLogoutFilter
extends GenericFilterBean
implements GroovyObject {
    private String endpointUrl;
    private String headerName;
    @Autowired
    private TokenReader tokenReader;
    @Autowired
    private TokenStorageService tokenStorageService;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    @Generated
    public RestLogoutFilter() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest servletRequest = (HttpServletRequest)ScriptBytecodeAdapter.asType((Object)request, HttpServletRequest.class);
        HttpServletResponse servletResponse = (HttpServletResponse)ScriptBytecodeAdapter.asType((Object)response, HttpServletResponse.class);
        String actualUri = StringGroovyMethods.minus((CharSequence)servletRequest.getRequestURI(), (Object)servletRequest.getContextPath());
        if (ScriptBytecodeAdapter.compareEqual((Object)actualUri, (Object)this.endpointUrl)) {
            if (ScriptBytecodeAdapter.compareNotEqual((Object)servletRequest.getMethod(), (Object)"POST")) {
                Object v0;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{servletRequest.getMethod(), HttpServletResponse.SC_METHOD_NOT_ALLOWED}, new String[]{"", " HTTP method is not supported. Setting status to ", ""})));
                    v0 = null;
                } else {
                    v0 = null;
                }
                servletResponse.setStatus(HttpServletResponse.SC_METHOD_NOT_ALLOWED);
                return;
            }
            AccessToken accessToken = this.tokenReader.findToken(servletRequest);
            if (DefaultTypeTransformation.booleanUnbox((Object)((Object)accessToken))) {
                Object v1;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{accessToken}, new String[]{"Token found: ", ""})));
                    v1 = null;
                } else {
                    v1 = null;
                }
                try {
                    log.debug("Trying to remove the token");
                    this.tokenStorageService.removeToken(accessToken.getAccessToken());
                }
                catch (TokenNotFoundException ignored) {
                    servletResponse.setStatus(HttpServletResponse.SC_NOT_FOUND, "Token not found");
                }
            } else {
                Object v2;
                if (log.isDebugEnabled()) {
                    log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{HttpServletResponse.SC_BAD_REQUEST}, new String[]{"Token is missing. Sending a ", " Bad Request response"})));
                    v2 = null;
                } else {
                    v2 = null;
                }
                servletResponse.setStatus(HttpServletResponse.SC_BAD_REQUEST, "Token header is missing");
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != RestLogoutFilter.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.yunchen.gb.plugin.springsecurity.rest.RestLogoutFilter");
    }

    @Generated
    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    @Generated
    public void setEndpointUrl(String string) {
        this.endpointUrl = string;
    }

    @Generated
    public String getHeaderName() {
        return this.headerName;
    }

    @Generated
    public void setHeaderName(String string) {
        this.headerName = string;
    }

    @Generated
    public TokenReader getTokenReader() {
        return this.tokenReader;
    }

    @Generated
    public void setTokenReader(TokenReader tokenReader) {
        this.tokenReader = tokenReader;
    }

    @Generated
    public TokenStorageService getTokenStorageService() {
        return this.tokenStorageService;
    }

    @Generated
    public void setTokenStorageService(TokenStorageService tokenStorageService) {
        this.tokenStorageService = tokenStorageService;
    }
}

