/*
 * Decompiled with CFR 0.152.
 */
package org.yunchen.gb.plugin.springsecurity.rest.oauth;

import groovy.lang.Delegate;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.pac4j.core.profile.CommonProfile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.yunchen.gb.plugin.springsecurity.config.SpringSecurityConfigurationProperties;
import org.yunchen.gb.plugin.springsecurity.rest.oauth.OauthUser;
import org.yunchen.gb.plugin.springsecurity.rest.oauth.OauthUserDetailsService;

@Configuration
@EnableConfigurationProperties(value={SpringSecurityConfigurationProperties.class})
public class DefaultOauthUserDetailsService
implements OauthUserDetailsService,
GroovyObject {
    @Autowired
    private SpringSecurityConfigurationProperties securityproperties;
    @Delegate
    private UserDetailsService userDetailsService;
    @Autowired
    private UserDetailsChecker preAuthenticationChecks;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public DefaultOauthUserDetailsService() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public OauthUser loadUserByUserProfile(CommonProfile userProfile, Collection<GrantedAuthority> defaultRoles) throws UsernameNotFoundException {
        String userDomainClass = this.userDomainClassName();
        if (!DefaultTypeTransformation.booleanUnbox((Object)userDomainClass)) {
            return this.instantiateOauthUser(userProfile, defaultRoles);
        }
        return this.loadUserByUserProfileWhenUserDomainClassIsSet(userProfile, defaultRoles);
    }

    public OauthUser loadUserByUserProfileWhenUserDomainClassIsSet(CommonProfile userProfile, Collection<GrantedAuthority> defaultRoles) {
        OauthUser oauthUser = null;
        try {
            OauthUser oauthUser2;
            Object v2;
            Object v1;
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{userProfile}, new String[]{"Trying to fetch user details for user profile: ", ""})));
                v0 = null;
            } else {
                v0 = null;
            }
            UserDetails userDetails = this.userDetailsService.loadUserByUsername(userProfile.getId());
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.preAuthenticationChecks.getClass().getName()}, new String[]{"Checking user details with ", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
            UserDetailsChecker userDetailsChecker = this.preAuthenticationChecks;
            if (userDetailsChecker != null) {
                userDetailsChecker.check(userDetails);
                v2 = null;
            } else {
                v2 = null;
            }
            Collection allRoles = DefaultGroovyMethods.plus((List)((List)ScriptBytecodeAdapter.asType((Object)userDetails.getAuthorities(), List.class)), defaultRoles);
            oauthUser = oauthUser2 = new OauthUser(userDetails.getUsername(), userDetails.getPassword(), allRoles, userProfile);
        }
        catch (UsernameNotFoundException unfe) {
            OauthUser oauthUser3;
            Object v3;
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{defaultRoles}, new String[]{"User not found. Creating a new one with default roles: ", ""})));
                v3 = null;
            } else {
                v3 = null;
            }
            oauthUser = oauthUser3 = this.instantiateOauthUser(userProfile, defaultRoles);
        }
        return oauthUser;
    }

    public OauthUser instantiateOauthUser(CommonProfile userProfile, Collection<GrantedAuthority> defaultRoles) {
        return new OauthUser(userProfile.getId(), "N/A", defaultRoles, userProfile);
    }

    public String userDomainClassName() {
        CallSite[] callSiteArray = DefaultOauthUserDetailsService.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[0].callGetProperty(callSiteArray[1].callGroovyObjectGetProperty((Object)this.securityproperties)));
    }

    @Generated
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        return this.userDetailsService.loadUserByUsername(username);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != DefaultOauthUserDetailsService.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.yunchen.gb.plugin.springsecurity.rest.oauth.DefaultOauthUserDetailsService");
    }

    @Generated
    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    @Generated
    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    @Generated
    public UserDetailsChecker getPreAuthenticationChecks() {
        return this.preAuthenticationChecks;
    }

    @Generated
    public void setPreAuthenticationChecks(UserDetailsChecker userDetailsChecker) {
        this.preAuthenticationChecks = userDetailsChecker;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "userDomainClassName";
        stringArray[1] = "userloookup";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[2];
        DefaultOauthUserDetailsService.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(DefaultOauthUserDetailsService.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = DefaultOauthUserDetailsService.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

