/*
 * Decompiled with CFR 0.152.
 */
package org.yunchen.gb.plugin.springsecurity.rest.token.generation.jwt;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.time.TimeCategory;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Date;
import java.util.List;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.userdetails.UserDetails;
import org.yunchen.gb.plugin.springsecurity.rest.service.JwtService;
import org.yunchen.gb.plugin.springsecurity.rest.token.AccessToken;
import org.yunchen.gb.plugin.springsecurity.rest.token.generation.TokenGenerator;
import org.yunchen.gb.plugin.springsecurity.rest.token.generation.jwt.CustomClaimProvider;
import org.yunchen.gb.plugin.springsecurity.rest.token.storage.jwt.JwtTokenStorageService;

public abstract class AbstractJwtTokenGenerator
implements TokenGenerator,
GroovyObject {
    private Integer defaultExpiration;
    private JwtTokenStorageService jwtTokenStorageService;
    private List<CustomClaimProvider> customClaimProviders;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public AbstractJwtTokenGenerator() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Override
    public AccessToken generateAccessToken(UserDetails details) {
        Object v0;
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{this.defaultExpiration}, new String[]{"Generating an access token with default expiration: ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        return this.generateAccessToken(details, this.defaultExpiration);
    }

    @Override
    public AccessToken generateAccessToken(UserDetails details, Integer expiration) {
        return this.generateAccessToken(details, true, expiration);
    }

    public AccessToken generateAccessToken(UserDetails details, boolean withRefreshToken, Integer expiration) {
        log.debug("Serializing the principal received");
        String serializedPrincipal = this.serializePrincipal(details);
        JWTClaimsSet.Builder builder = this.generateClaims(details, serializedPrincipal, expiration);
        log.debug("Generating access token...");
        JWT accessTokenJwt = this.generateAccessToken(builder.build());
        String accessToken = accessTokenJwt.serialize();
        JWT refreshTokenJwt = null;
        String refreshToken = null;
        if (withRefreshToken) {
            String string;
            JWT jWT;
            log.debug("Generating refresh token...");
            refreshTokenJwt = jWT = this.generateRefreshToken(details, serializedPrincipal, expiration);
            refreshToken = string = refreshTokenJwt.serialize();
        }
        return new AccessToken(details, details.getAuthorities(), accessToken, refreshToken, expiration, accessTokenJwt, refreshTokenJwt);
    }

    /*
     * WARNING - void declaration
     */
    public JWTClaimsSet.Builder generateClaims(UserDetails details, String serializedPrincipal, Integer expiration) {
        void var3_3;
        void var2_2;
        Reference details2 = new Reference((Object)details);
        Reference serializedPrincipal2 = new Reference((Object)var2_2);
        Reference expiration2 = new Reference((Object)var3_3);
        CallSite[] callSiteArray = AbstractJwtTokenGenerator.$getCallSiteArray();
        Reference builder = new Reference((Object)((JWTClaimsSet.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(JWTClaimsSet.Builder.class), JWTClaimsSet.Builder.class)));
        callSiteArray[1].call((Object)((JWTClaimsSet.Builder)builder.get()), callSiteArray[2].callGetProperty((Object)((UserDetails)details2.get())));
        Reference now = new Reference((Object)((Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[3].callConstructor(Date.class), Date.class)));
        callSiteArray[4].call((Object)((JWTClaimsSet.Builder)builder.get()), (Object)((Date)now.get()));
        if (DefaultTypeTransformation.booleanUnbox((Object)((Integer)expiration2.get()))) {
            Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[5].call((Object)log)) ? callSiteArray[6].call((Object)log, (Object)new GStringImpl(new Object[]{(Integer)expiration2.get()}, new String[]{"Setting expiration to ", ""})) : null;
            public final class _generateClaims_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference builder;
                private /* synthetic */ Reference now;
                private /* synthetic */ Reference expiration;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;
                private static /* synthetic */ SoftReference $callSiteArray;

                public _generateClaims_closure1(Object _outerInstance, Object _thisObject, Reference builder, Reference now, Reference expiration) {
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    CallSite[] callSiteArray = _generateClaims_closure1.$getCallSiteArray();
                    super(_outerInstance, _thisObject);
                    this.builder = reference3 = builder;
                    this.now = reference2 = now;
                    this.expiration = reference = expiration;
                }

                public Object doCall(Object it) {
                    CallSite[] callSiteArray = _generateClaims_closure1.$getCallSiteArray();
                    return callSiteArray[0].call(this.builder.get(), callSiteArray[1].call(this.now.get(), callSiteArray[2].callGetProperty(this.expiration.get())));
                }

                @Generated
                public JWTClaimsSet.Builder getBuilder() {
                    CallSite[] callSiteArray = _generateClaims_closure1.$getCallSiteArray();
                    return (JWTClaimsSet.Builder)ScriptBytecodeAdapter.castToType((Object)this.builder.get(), JWTClaimsSet.Builder.class);
                }

                @Generated
                public Date getNow() {
                    CallSite[] callSiteArray = _generateClaims_closure1.$getCallSiteArray();
                    return (Date)ScriptBytecodeAdapter.castToType((Object)this.now.get(), Date.class);
                }

                @Generated
                public Integer getExpiration() {
                    CallSite[] callSiteArray = _generateClaims_closure1.$getCallSiteArray();
                    return (Integer)ScriptBytecodeAdapter.castToType((Object)this.expiration.get(), Integer.class);
                }

                @Generated
                public Object doCall() {
                    CallSite[] callSiteArray = _generateClaims_closure1.$getCallSiteArray();
                    return this.doCall(null);
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _generateClaims_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }

                private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                    stringArray[0] = "expirationTime";
                    stringArray[1] = "plus";
                    stringArray[2] = "seconds";
                }

                private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                    String[] stringArray = new String[3];
                    _generateClaims_closure1.$createCallSiteArray_1(stringArray);
                    return new CallSiteArray(_generateClaims_closure1.class, stringArray);
                }

                private static /* synthetic */ CallSite[] $getCallSiteArray() {
                    CallSiteArray callSiteArray;
                    if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                        callSiteArray = _generateClaims_closure1.$createCallSiteArray();
                        $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                    }
                    return callSiteArray.array;
                }
            }
            callSiteArray[7].callCurrent((GroovyObject)this, TimeCategory.class, (Object)new _generateClaims_closure1(this, this, builder, now, expiration2));
        }
        public final class _generateClaims_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _generateClaims_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _generateClaims_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _generateClaims_closure2.$getCallSiteArray();
                return callSiteArray[0].callGetProperty(it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _generateClaims_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateClaims_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "authority";
                return new CallSiteArray(_generateClaims_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generateClaims_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[8].call((Object)((JWTClaimsSet.Builder)builder.get()), (Object)"roles", callSiteArray[9].callSafe(callSiteArray[10].callGetProperty((Object)((UserDetails)details2.get())), (Object)new _generateClaims_closure2(this, this)));
        callSiteArray[11].call((Object)((JWTClaimsSet.Builder)builder.get()), (Object)"principal", (Object)((String)serializedPrincipal2.get()));
        public final class _generateClaims_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference builder;
            private /* synthetic */ Reference details;
            private /* synthetic */ Reference serializedPrincipal;
            private /* synthetic */ Reference expiration;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _generateClaims_closure3(Object _outerInstance, Object _thisObject, Reference builder, Reference details, Reference serializedPrincipal, Reference expiration) {
                Reference reference;
                Reference reference2;
                Reference reference3;
                Reference reference4;
                CallSite[] callSiteArray = _generateClaims_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.builder = reference4 = builder;
                this.details = reference3 = details;
                this.serializedPrincipal = reference2 = serializedPrincipal;
                this.expiration = reference = expiration;
            }

            public Object doCall(CustomClaimProvider customClaimProvider) {
                CallSite[] callSiteArray = _generateClaims_closure3.$getCallSiteArray();
                return callSiteArray[0].call((Object)customClaimProvider, this.builder.get(), this.details.get(), this.serializedPrincipal.get(), this.expiration.get());
            }

            @Generated
            public Object call(CustomClaimProvider customClaimProvider) {
                CallSite[] callSiteArray = _generateClaims_closure3.$getCallSiteArray();
                return callSiteArray[1].callCurrent((GroovyObject)this, (Object)customClaimProvider);
            }

            @Generated
            public JWTClaimsSet.Builder getBuilder() {
                CallSite[] callSiteArray = _generateClaims_closure3.$getCallSiteArray();
                return (JWTClaimsSet.Builder)ScriptBytecodeAdapter.castToType((Object)this.builder.get(), JWTClaimsSet.Builder.class);
            }

            @Generated
            public UserDetails getDetails() {
                CallSite[] callSiteArray = _generateClaims_closure3.$getCallSiteArray();
                return (UserDetails)ScriptBytecodeAdapter.castToType((Object)this.details.get(), UserDetails.class);
            }

            @Generated
            public String getSerializedPrincipal() {
                CallSite[] callSiteArray = _generateClaims_closure3.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.serializedPrincipal.get());
            }

            @Generated
            public Integer getExpiration() {
                CallSite[] callSiteArray = _generateClaims_closure3.$getCallSiteArray();
                return (Integer)ScriptBytecodeAdapter.castToType((Object)this.expiration.get(), Integer.class);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _generateClaims_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "provideCustomClaims";
                stringArray[1] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[2];
                _generateClaims_closure3.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_generateClaims_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _generateClaims_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[12].call(this.customClaimProviders, (Object)new _generateClaims_closure3(this, this, builder, details2, serializedPrincipal2, expiration2));
        Object object = DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[13].call((Object)log)) ? callSiteArray[14].call((Object)log, (Object)new GStringImpl(new Object[]{callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].call((Object)((JWTClaimsSet.Builder)builder.get()))))}, new String[]{"Generated claim set: ", ""})) : null;
        return (JWTClaimsSet.Builder)builder.get();
    }

    protected String serializePrincipal(UserDetails principal) {
        String string = JwtService.serialize(principal);
        try {
            return string;
        }
        catch (Exception exception) {
            Object v1;
            Object v0;
            if (log.isDebugEnabled()) {
                log.debug(exception.getMessage());
                v0 = null;
            } else {
                v0 = null;
            }
            if (log.isDebugEnabled()) {
                log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{principal.getClass(), principal}, new String[]{"The principal class (", ") is not serializable. Object: ", ""})));
                v1 = null;
            } else {
                v1 = null;
            }
            String string2 = ShortTypeHandling.castToString(null);
            return string2;
        }
    }

    protected abstract JWT generateAccessToken(JWTClaimsSet var1);

    protected JWT generateRefreshToken(UserDetails principal, String serializedPrincipal, Integer expiration) {
        JWTClaimsSet.Builder builder = this.generateClaims(principal, serializedPrincipal, expiration);
        builder.expirationTime(null);
        return this.generateAccessToken(builder.build());
    }

    @Generated
    public AccessToken generateAccessToken(UserDetails details, boolean withRefreshToken) {
        CallSite[] callSiteArray = AbstractJwtTokenGenerator.$getCallSiteArray();
        return this.generateAccessToken(details, withRefreshToken, this.defaultExpiration);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != AbstractJwtTokenGenerator.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"org.yunchen.gb.plugin.springsecurity.rest.token.generation.jwt.AbstractJwtTokenGenerator");
    }

    @Generated
    public Integer getDefaultExpiration() {
        return this.defaultExpiration;
    }

    @Generated
    public void setDefaultExpiration(Integer n) {
        this.defaultExpiration = n;
    }

    @Generated
    public JwtTokenStorageService getJwtTokenStorageService() {
        return this.jwtTokenStorageService;
    }

    @Generated
    public void setJwtTokenStorageService(JwtTokenStorageService jwtTokenStorageService) {
        this.jwtTokenStorageService = jwtTokenStorageService;
    }

    @Generated
    public List<CustomClaimProvider> getCustomClaimProviders() {
        return this.customClaimProviders;
    }

    @Generated
    public void setCustomClaimProviders(List<CustomClaimProvider> list) {
        this.customClaimProviders = list;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "subject";
        stringArray[2] = "username";
        stringArray[3] = "<$constructor$>";
        stringArray[4] = "issueTime";
        stringArray[5] = "isDebugEnabled";
        stringArray[6] = "debug";
        stringArray[7] = "use";
        stringArray[8] = "claim";
        stringArray[9] = "collect";
        stringArray[10] = "authorities";
        stringArray[11] = "claim";
        stringArray[12] = "each";
        stringArray[13] = "isDebugEnabled";
        stringArray[14] = "debug";
        stringArray[15] = "toString";
        stringArray[16] = "toJSONObject";
        stringArray[17] = "build";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[18];
        AbstractJwtTokenGenerator.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(AbstractJwtTokenGenerator.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = AbstractJwtTokenGenerator.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

