/*
 * Decompiled with CFR 0.152.
 */
package org.yunchen.gb.plugin.springsecurity.rest.util;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.KeyLengthException;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.jwt.SignedJWT;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Date;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.yunchen.gb.plugin.springsecurity.rest.SpringSecurityRestConfigurationProperties;

public final class JwtSecurityUtils
implements GroovyObject {
    private static SpringSecurityRestConfigurationProperties springSecurityRestConfigurationProperties;
    private static JWSAlgorithm jwsAlgorithm;
    private static JWSSigner signer;
    private static long expirationSeconds;
    private static String jwtSecret;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public JwtSecurityUtils() {
        MetaClass metaClass;
        CallSite[] callSiteArray = JwtSecurityUtils.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String generateToken(String subject, String key, String obj, boolean noExpirationTime, String issuer) throws JOSEException {
        CallSite[] callSiteArray = JwtSecurityUtils.$getCallSiteArray();
        JWTClaimsSet.Builder claimsSetBuilder = (JWTClaimsSet.Builder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[0].callConstructor(JWTClaimsSet.Builder.class), JWTClaimsSet.Builder.class);
        callSiteArray[1].call((Object)claimsSetBuilder, (Object)subject);
        Date now = (Date)ScriptBytecodeAdapter.castToType((Object)callSiteArray[2].callConstructor(Date.class), Date.class);
        callSiteArray[3].call((Object)claimsSetBuilder, (Object)now);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigL() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            if (!noExpirationTime) {
                callSiteArray[4].call((Object)claimsSetBuilder, callSiteArray[5].callConstructor(Date.class, callSiteArray[6].call(callSiteArray[7].call((Object)now), callSiteArray[8].call((Object)expirationSeconds, (Object)1000))));
            }
        } else if (!noExpirationTime) {
            callSiteArray[9].call((Object)claimsSetBuilder, callSiteArray[10].callConstructor(Date.class, callSiteArray[11].call(callSiteArray[12].call((Object)now), (Object)(expirationSeconds * (long)1000))));
        }
        callSiteArray[13].call((Object)claimsSetBuilder, (Object)key, (Object)obj);
        callSiteArray[14].call((Object)claimsSetBuilder, (Object)issuer);
        JWTClaimsSet claimsSet = (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[15].call((Object)claimsSetBuilder), JWTClaimsSet.class);
        JWT accessTokenJwt = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[16].callStatic(JwtSecurityUtils.class, (Object)claimsSet);
            accessTokenJwt = (JWT)ScriptBytecodeAdapter.castToType((Object)object, JWT.class);
        } else {
            JWT jWT;
            accessTokenJwt = jWT = JwtSecurityUtils.generateAccessToken(claimsSet);
        }
        String accessToken = ShortTypeHandling.castToString((Object)callSiteArray[17].call((Object)accessTokenJwt));
        return accessToken;
    }

    public static JWT generateAccessToken(JWTClaimsSet claimsSet) throws JOSEException {
        CallSite[] callSiteArray = JwtSecurityUtils.$getCallSiteArray();
        SignedJWT signedJWT = (SignedJWT)ScriptBytecodeAdapter.castToType((Object)callSiteArray[18].callConstructor(SignedJWT.class, callSiteArray[19].callConstructor(JWSHeader.class, (Object)jwsAlgorithm), (Object)claimsSet), SignedJWT.class);
        if (ScriptBytecodeAdapter.compareEqual((Object)signer, null)) {
            try {
                Object object = callSiteArray[20].callConstructor(MACSigner.class, (Object)jwtSecret);
                signer = (JWSSigner)ScriptBytecodeAdapter.castToType((Object)object, JWSSigner.class);
            }
            catch (KeyLengthException e) {
                callSiteArray[21].call((Object)e);
            }
        }
        callSiteArray[22].call((Object)signedJWT, (Object)signer);
        return signedJWT;
    }

    public static JWTClaimsSet validateToken(String tokenValue) throws Exception {
        CallSite[] callSiteArray = JwtSecurityUtils.$getCallSiteArray();
        JWT jwt = (JWT)ScriptBytecodeAdapter.castToType((Object)callSiteArray[23].call(JWTParser.class, (Object)tokenValue), JWT.class);
        SignedJWT signedJwt = (SignedJWT)ScriptBytecodeAdapter.castToType((Object)jwt, SignedJWT.class);
        if (!DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[24].call((Object)signedJwt, callSiteArray[25].callConstructor(MACVerifier.class, (Object)jwtSecret)))) {
            throw (Throwable)callSiteArray[26].callConstructor(JOSEException.class, (Object)"Invalid signature");
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)callSiteArray[27].call(callSiteArray[28].call(callSiteArray[29].call((Object)jwt)), callSiteArray[30].callConstructor(Date.class)))) {
            throw (Throwable)callSiteArray[31].callConstructor(Exception.class, (Object)new GStringImpl(new Object[]{tokenValue}, new String[]{"Token ", " has expired"}));
        }
        return (JWTClaimsSet)ScriptBytecodeAdapter.castToType((Object)callSiteArray[32].call((Object)jwt), JWTClaimsSet.class);
    }

    @Generated
    public static String generateToken(String subject, String key, String obj, boolean noExpirationTime) throws JOSEException {
        CallSite[] callSiteArray = JwtSecurityUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return JwtSecurityUtils.generateToken(subject, key, obj, noExpirationTime, "Security REST Plugin");
        }
        return JwtSecurityUtils.generateToken(subject, key, obj, noExpirationTime, "Security REST Plugin");
    }

    @Generated
    public static String generateToken(String subject, String key, String obj) throws JOSEException {
        CallSite[] callSiteArray = JwtSecurityUtils.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return JwtSecurityUtils.generateToken(subject, key, obj, false, "Security REST Plugin");
        }
        return JwtSecurityUtils.generateToken(subject, key, obj, false, "Security REST Plugin");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != JwtSecurityUtils.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        String string;
        jwtSecret = string = "atlease256bits(The secret length must be at least 256 bits)";
        int n = 7200;
        expirationSeconds = n;
    }

    @Generated
    public static SpringSecurityRestConfigurationProperties getSpringSecurityRestConfigurationProperties() {
        return springSecurityRestConfigurationProperties;
    }

    @Generated
    public static void setSpringSecurityRestConfigurationProperties(SpringSecurityRestConfigurationProperties springSecurityRestConfigurationProperties) {
        JwtSecurityUtils.springSecurityRestConfigurationProperties = springSecurityRestConfigurationProperties;
    }

    @Generated
    public static JWSAlgorithm getJwsAlgorithm() {
        return jwsAlgorithm;
    }

    @Generated
    public static void setJwsAlgorithm(JWSAlgorithm jWSAlgorithm) {
        jwsAlgorithm = jWSAlgorithm;
    }

    @Generated
    public static JWSSigner getSigner() {
        return signer;
    }

    @Generated
    public static void setSigner(JWSSigner jWSSigner) {
        signer = jWSSigner;
    }

    @Generated
    public static long getExpirationSeconds() {
        return expirationSeconds;
    }

    @Generated
    public static void setExpirationSeconds(long l) {
        expirationSeconds = l;
    }

    @Generated
    public static String getJwtSecret() {
        return jwtSecret;
    }

    @Generated
    public static void setJwtSecret(String string) {
        jwtSecret = string;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "subject";
        stringArray[2] = "<$constructor$>";
        stringArray[3] = "issueTime";
        stringArray[4] = "expirationTime";
        stringArray[5] = "<$constructor$>";
        stringArray[6] = "plus";
        stringArray[7] = "getTime";
        stringArray[8] = "multiply";
        stringArray[9] = "expirationTime";
        stringArray[10] = "<$constructor$>";
        stringArray[11] = "plus";
        stringArray[12] = "getTime";
        stringArray[13] = "claim";
        stringArray[14] = "issuer";
        stringArray[15] = "build";
        stringArray[16] = "generateAccessToken";
        stringArray[17] = "serialize";
        stringArray[18] = "<$constructor$>";
        stringArray[19] = "<$constructor$>";
        stringArray[20] = "<$constructor$>";
        stringArray[21] = "printStackTrace";
        stringArray[22] = "sign";
        stringArray[23] = "parse";
        stringArray[24] = "verify";
        stringArray[25] = "<$constructor$>";
        stringArray[26] = "<$constructor$>";
        stringArray[27] = "before";
        stringArray[28] = "getExpirationTime";
        stringArray[29] = "getJWTClaimsSet";
        stringArray[30] = "<$constructor$>";
        stringArray[31] = "<$constructor$>";
        stringArray[32] = "getJWTClaimsSet";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[33];
        JwtSecurityUtils.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(JwtSecurityUtils.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = JwtSecurityUtils.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

