package org.yunchen.gb.plugin.springsecurity


import org.yunchen.gb.plugin.springsecurity.config.SpringSecurityConfigurationProperties
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Conditional
import org.springframework.context.annotation.Configuration
import org.springframework.core.annotation.Order
import org.springframework.security.authentication.AuthenticationDetailsSource
import org.springframework.security.authentication.AuthenticationManager
import org.springframework.security.authentication.AuthenticationTrustResolver
import org.springframework.security.web.access.AccessDeniedHandler
import org.springframework.security.web.access.AccessDeniedHandlerImpl
import org.springframework.security.web.access.ExceptionTranslationFilter
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter
import org.springframework.security.web.savedrequest.NullRequestCache
import org.springframework.security.web.savedrequest.RequestCache
import org.springframework.security.web.util.ThrowableAnalyzer
import org.springframework.stereotype.Component
import org.yunchen.gb.plugin.springsecurity.web.UpdateRequestContextHolderExceptionTranslationFilter

/**
 * Created by @Author:xiaopeng on 2017/9/22.
 */
@Order(21)
@Configuration
@EnableConfigurationProperties([SpringSecurityConfigurationProperties.class])
@Component
@Conditional(GbSpringSecurityBasicCondition.class)
class GbSpringSecurityBasicBean {
    @Autowired
    private SpringSecurityConfigurationProperties securityproperties;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private AuthenticationDetailsSource authenticationDetailsSource;
    @Autowired
    private AuthenticationTrustResolver authenticationTrustResolver;
    @Autowired
    private ThrowableAnalyzer throwableAnalyzer;
    @Bean('basicAuthenticationEntryPoint')
    public BasicAuthenticationEntryPoint getBasicAuthenticationEntryPoint(){
        return new BasicAuthenticationEntryPoint(realmName: securityproperties.basic.realmName?:'GB realmName');
    }
    @Bean('basicAuthenticationFilter')
    public BasicAuthenticationFilter getBasicAuthenticationFilter(){
        BasicAuthenticationFilter basicAuthenticationFilter=new BasicAuthenticationFilter(authenticationManager,getBasicAuthenticationEntryPoint());
        basicAuthenticationFilter.credentialsCharset=securityproperties.basic.credentialsCharset?:'UTF-8';
        //@todo rememberMeServices
        //basicAuthenticationFilter.rememberMeServices=??
        return basicAuthenticationFilter;
    }
    @Bean('basicAccessDeniedHandler')
    public AccessDeniedHandler getAccessDeniedHandlerImpl(){
        return new AccessDeniedHandlerImpl();
    }
    @Bean('basicRequestCache')
    public RequestCache getRequestCache(){
        return new NullRequestCache();
    }
    @Bean('basicExceptionTranslationFilter')
    public ExceptionTranslationFilter getUpdateRequestContextHolderExceptionTranslationFilter(){
        ExceptionTranslationFilter exceptionTranslationFilter= new UpdateRequestContextHolderExceptionTranslationFilter(getBasicAuthenticationEntryPoint(),getRequestCache());
        exceptionTranslationFilter.accessDeniedHandler=getAccessDeniedHandlerImpl();
        exceptionTranslationFilter.authenticationTrustResolver=authenticationTrustResolver;
        exceptionTranslationFilter.throwableAnalyzer=throwableAnalyzer;
        return exceptionTranslationFilter;
    }

}
