package org.yunchen.gb.plugin.springsecurity

import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy
import org.yunchen.gb.core.GbStartupRunner
import org.yunchen.gb.core.config.ServerConfigurationProperties
import org.yunchen.gb.plugin.springsecurity.config.FailureLoginHandler
import org.yunchen.gb.plugin.springsecurity.config.SpringSecurityConfigurationProperties
import org.yunchen.gb.plugin.springsecurity.config.SuccessLoginHandler
import org.yunchen.gb.plugin.springsecurity.config.filter.AlreadyLoginFilter
import org.yunchen.gb.plugin.springsecurity.config.filter.ScaleCookieLogoutFilter
import org.yunchen.gb.plugin.springsecurity.config.filter.ScaleCookieValidationFilter
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.boot.context.properties.EnableConfigurationProperties
import org.springframework.context.annotation.Bean
import org.springframework.context.annotation.Configuration
import org.springframework.core.annotation.Order
import org.springframework.security.access.AccessDecisionManager
import org.springframework.security.access.SecurityMetadataSource
import org.springframework.security.authentication.AuthenticationManager
import org.springframework.security.authentication.AuthenticationTrustResolver
import org.springframework.security.authentication.dao.DaoAuthenticationProvider


import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder
import org.springframework.security.config.annotation.web.builders.HttpSecurity
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer
import org.springframework.security.core.session.SessionRegistry
import org.springframework.security.core.userdetails.UserDetailsService
import org.springframework.security.crypto.password.PasswordEncoder
import org.springframework.security.web.PortResolver
import org.springframework.security.web.access.AccessDeniedHandler
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter
import org.springframework.security.web.authentication.AuthenticationFailureHandler
import org.springframework.security.web.authentication.AuthenticationSuccessHandler
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter
import org.springframework.security.web.authentication.logout.LogoutFilter
import org.springframework.security.web.header.Header
import org.springframework.security.web.header.writers.StaticHeadersWriter
import org.springframework.security.web.savedrequest.RequestCache

import org.springframework.stereotype.Component
import org.springframework.web.cors.CorsConfiguration
import org.springframework.web.cors.CorsConfigurationSource
import org.springframework.web.cors.UrlBasedCorsConfigurationSource
import org.yunchen.gb.plugin.springsecurity.web.access.AjaxAwareAccessDeniedHandler
import org.yunchen.gb.plugin.springsecurity.web.access.intercept.AbstractFilterInvocationDefinition
import org.yunchen.gb.plugin.springsecurity.web.access.intercept.GbFilterSecurityInterceptor

import javax.servlet.Filter
/**
 * Created by @Author:xiaopeng on 2017/6/18.
 */
@EnableWebSecurity
@Order(49)
@Configuration
@EnableConfigurationProperties([ServerConfigurationProperties.class,SpringSecurityConfigurationProperties.class])
@Component
class GbSpringSecurityConfig extends WebSecurityConfigurerAdapter {
    @Autowired
    private ServerConfigurationProperties serverproperties;
    @Autowired
    private SpringSecurityConfigurationProperties securityproperties;
    @Autowired
    private GbSpringSecurityService gbSpringSecurityService;
    @Autowired
    private GbStartupRunner gbStartupRunner
    @Autowired
    private UserDetailsService userDetailsService
    @Autowired
    private PasswordEncoder passwordEncoder
    @Autowired
    private AccessDecisionManager accessDecisionManager
    @Autowired
    private SecurityMetadataSource securityMetadataSource
    @Autowired
    private SessionRegistry sessionRegistry
    @Autowired
    private PortResolver portResolver
    @Autowired
    private RequestCache requestCache
    @Autowired
    private AuthenticationTrustResolver authenticationTrustResolver;
    @Autowired
    DaoAuthenticationProvider daoAuthenticationProvider
    //@Autowired
    //private BasicAuthenticationFilter basicAuthenticationFilter;
    /** exceptionTranslationFilter */
    //@Bean("accessDeniedHandler")
    public AccessDeniedHandler  getAccessDeniedHandler(){
        return   new AjaxAwareAccessDeniedHandler(errorPage:securityproperties.getAdh().getErrorPage(),
                ajaxErrorPage:securityproperties.getAdh().getAjaxErrorPage(),
                useForward:securityproperties.getAdh().getUseForward(),
                portResolver:portResolver,authenticationTrustResolver:authenticationTrustResolver,
                requestCache: requestCache
        );
    }
    @Bean("scaleCookieValidationFilter")
    public ScaleCookieValidationFilter getScaleCookieValidationFilter(){
        return new ScaleCookieValidationFilter(gbSpringSecurityService: gbSpringSecurityService,securityproperties: securityproperties);
    }
    @Bean("scaleCookieLogoutFilter")
    public ScaleCookieLogoutFilter getScaleCookieLogoutFilter(){
        return new ScaleCookieLogoutFilter(endpointUrl: securityproperties.logout.filterProcessesUrl);
    }
    @Bean("authenticationSuccessHandler")
    public AuthenticationSuccessHandler  getSuccessLoginHandler(){
        return new SuccessLoginHandler(springSecurityConfigurationProperties: securityproperties);
    }
    @Bean("authenticationFailureHandler")
    public AuthenticationFailureHandler  getFailureLoginHandler(){
        return new FailureLoginHandler();
    }
    //add to fix could-not-autowire-authentication-manager-in-spring-boot-2-0-0 bug
    //2019-05-31
    @Bean
    @Override
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Order(50)
    @Override
    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider(daoAuthenticationProvider);
        auth.userDetailsService(userDetailsService).passwordEncoder(passwordEncoder);
        GbSpringSecurityUtils.authenticationManagerBuilder=auth;
    }
    @Order(51)
    @Override
    protected void configure(HttpSecurity http) throws Exception {
        //执行一次init
        gbStartupRunner.run(null);
        gbStartupRunner.setHasRuned(true);
        //禁用csrf 和 cors
        if(securityproperties.getCsrf() && securityproperties.getCsrf()=='disable'){
            http.csrf().disable();
        }else{
            http.csrf();
        }
        if(securityproperties.getCors() && securityproperties.getCors()=='disable'){
            http.cors().disable();
        }else{
            http.cors();
        }
        if(securityproperties.headers?.size()>0){
            List list=[]
            securityproperties.headers.each{one->
                one.each {k,v->
                    list << new Header(k.toString(),v.toString())
                }

            }
            StaticHeadersWriter staticHeadersWriter=new StaticHeadersWriter(list)
            http.headers().addHeaderWriter(staticHeadersWriter);
        }
        //全部禁止匿名访问访问和允许iframe（//任何请求,登录后可以访问）
        HeadersConfigurer<HttpSecurity> headersConfigurer=http.authorizeRequests().anyRequest().authenticated().and().headers()
        if(securityproperties.frameOptions=="disabled"){
            headersConfigurer.frameOptions().disable();
        }else if(securityproperties.frameOptions=="deny"){
            headersConfigurer.frameOptions().deny();
        }else{
            headersConfigurer.frameOptions().sameOrigin();
        }
        //设置验证地址、访问成功和失败的处理器
        http.formLogin().loginProcessingUrl(securityproperties.getApf().getFilterProcessesUrl())
                .successHandler(getSuccessLoginHandler())
                .failureHandler(getFailureLoginHandler())
                .and().logout().logoutUrl(securityproperties.logout.filterProcessesUrl).logoutSuccessUrl(securityproperties.logout.afterLogoutUrl).permitAll();//注销行为任意访问*/
        //
        LoginUrlAuthenticationEntryPoint loginUrlAuthenticationEntryPoint=new LoginUrlAuthenticationEntryPoint(securityproperties.getAuth().getLoginFormUrl());
        //是否跳转
        loginUrlAuthenticationEntryPoint.setUseForward(false);
        http.exceptionHandling().authenticationEntryPoint(loginUrlAuthenticationEntryPoint)
                .accessDeniedHandler(getAccessDeniedHandler());

        //设置requestmap 的过滤器
        Filter fsi=new GbFilterSecurityInterceptor();
        AbstractFilterInvocationDefinition securityMetadataSource=securityMetadataSource;
        securityMetadataSource.reset();
        fsi.setSecurityMetadataSource(securityMetadataSource);
        fsi.setAccessDecisionManager(accessDecisionManager);
        //requestmap的访问
        http.addFilterBefore(fsi, FilterSecurityInterceptor.class);
        //增加session是否登录Filter
        http.addFilterBefore(new AlreadyLoginFilter(), UsernamePasswordAuthenticationFilter.class);

        //添加ScaleCookieValidationFilter 2020-02-07
        if(securityproperties?.scale?.enableCookie){
            http.addFilterAfter(getScaleCookieValidationFilter(), AnonymousAuthenticationFilter.class);
            http.addFilterBefore(getScaleCookieLogoutFilter(),LogoutFilter.class);
        }

        //2.0中暂不支持basicAuth @todo
        //http.addFilterAt(basicAuthenticationFilter,BasicAuthenticationFilter.class);
        // add SessionFixationPrevention
        def sessionManagement = http.sessionManagement()
        if(securityproperties.useSessionFixationPrevention){
            SessionFixationProtectionStrategy sessionFixationProtectionStrategy=new SessionFixationProtectionStrategy()
            sessionFixationProtectionStrategy.migrateSessionAttributes = securityproperties.sessionFixationPrevention.migrate
            sessionFixationProtectionStrategy.alwaysCreateSession = securityproperties.sessionFixationPrevention.alwaysCreateSession
            sessionManagement = sessionManagement.sessionAuthenticationStrategy(sessionFixationProtectionStrategy)
        }else{
            sessionManagement.sessionAuthenticationStrategy(new NullAuthenticatedSessionStrategy())
        }
        //
        //配置同名用户登录访问数目
        sessionManagement.maximumSessions(securityproperties.sessionAuthenticationStrategy.maximumSessions)
                .maxSessionsPreventsLogin(securityproperties.sessionAuthenticationStrategy.maxSessionsPreventsLogin)
                .sessionRegistry(sessionRegistry)
                .expiredUrl(securityproperties.sessionAuthenticationStrategy.expiredUrl);
        GbSpringSecurityUtils.httpSecurity=http;
    }
    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        if(securityproperties.cors=='enable'){
            CorsConfiguration configuration = new CorsConfiguration();
            configuration.setAllowCredentials(securityproperties.corsConfig.allowCredentials);
            configuration.setAllowedOrigins(securityproperties.corsConfig.allowedOrigins.tokenize(','))
            configuration.setAllowedHeaders(securityproperties.corsConfig.allowedHeaders.tokenize(","))
            configuration.setAllowedMethods(securityproperties.corsConfig.allowedMethods.tokenize(","))
            UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
            source.registerCorsConfiguration(securityproperties.corsConfig.corsPath?:'/**', configuration);
            return source;
        }else{
            return new UrlBasedCorsConfigurationSource();
        }

    }
/*    @Bean
    public CorsFilter corsFilter() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowCredentials(securityproperties.corsConfig.allowCredentials);
        configuration.setAllowedOrigins(securityproperties.corsConfig.allowedOrigins.tokenize(','))
        configuration.setAllowedHeaders(securityproperties.corsConfig.allowedHeaders.tokenize(","))
        configuration.setAllowedMethods(securityproperties.corsConfig.allowedMethods.tokenize(","))
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration(securityproperties.corsConfig.corsPath?:'/**', configuration);
        return new CorsFilter(source);
    }*/
}
