package org.yunchen.gb.plugin.springsecurity


import groovy.transform.CompileStatic
import groovy.transform.EqualsAndHashCode
import groovy.transform.ToString

import org.springframework.http.HttpMethod
import org.springframework.security.access.ConfigAttribute

/**
 * @author <a href='mailto:burt@burtbeckwith.com'>Burt Beckwith</a>
 */
@EqualsAndHashCode(includes='pattern,configAttributes,httpMethod')
@ToString(includeNames=true)
@CompileStatic
class InterceptedUrl {
    String pattern
    Collection<ConfigAttribute> configAttributes = Collections.emptyList()
    HttpMethod httpMethod
    boolean filters = true
    Boolean https // true->https, false->http, null->any
    Class<?> closureClass

    InterceptedUrl(String pattern, Collection<String> tokens, HttpMethod httpMethod) {
        this.pattern = pattern
        this.configAttributes = ReflectionUtils.buildConfigAttributes(tokens)
        this.httpMethod = httpMethod
    }

    InterceptedUrl(String pattern, HttpMethod httpMethod, Collection<ConfigAttribute> configAttributes) {
        this.pattern = pattern
        this.httpMethod = httpMethod
        this.configAttributes = configAttributes
    }

    InterceptedUrl(String pattern, Class<?> closureClass, HttpMethod httpMethod) {
        this.pattern = pattern
        this.closureClass = closureClass
        this.httpMethod = httpMethod
    }
}
